/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.task.UpdateHeatMapTask;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;

public class EnrichmentMapActionListener
implements RowsSetListener {
    private EnrichmentMap map;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private List<CyNode> Nodes;
    private List<CyEdge> Edges;
    private CyApplicationManager applicationManager;
    private SynchronousTaskManager syncTaskManager;
    private final CytoPanel cytoPanelSouth;
    private FileUtil fileUtil;
    private StreamUtil streamUtil;
    private boolean heatMapUpdating;

    public EnrichmentMapActionListener(HeatMapPanel heatMapPanel_node, HeatMapPanel heatMapPanel_edge, CyApplicationManager applicationManager, CySwingApplication application, FileUtil fileUtil, StreamUtil streamUtil, SynchronousTaskManager syncTaskManager) {
        this.applicationManager = applicationManager;
        this.fileUtil = fileUtil;
        this.streamUtil = streamUtil;
        this.syncTaskManager = syncTaskManager;
        this.edgeOverlapPanel = heatMapPanel_edge;
        this.nodeOverlapPanel = heatMapPanel_node;
        this.heatMapUpdating = false;
        this.cytoPanelSouth = application.getCytoPanel(CytoPanelName.SOUTH);
    }

    public boolean isHeatMapUpdating() {
        return this.heatMapUpdating;
    }

    private boolean initialize(CyNetwork network) {
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        this.map = manager.getMap(network.getSUID());
        if (this.map != null) {
            if (this.map.getParams().isData() && this.map.getParams().getHmParams() == null) {
                HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel);
                if (this.map.getParams().isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                    hmParams.initColorGradients(this.map.getDataset("Dataset 1").getExpressionSets(), this.map.getDataset("Dataset 2").getExpressionSets());
                } else {
                    hmParams.initColorGradients(this.map.getDataset("Dataset 1").getExpressionSets());
                }
                this.map.getParams().setHmParams(hmParams);
            }
            this.Nodes = this.map.getParams().getSelectedNodes();
            this.Edges = this.map.getParams().getSelectedEdges();
            return true;
        }
        return false;
    }

    public void handleEvent(RowsSetEvent e) {
        this.heatMapUpdating = true;
        boolean override_revalidate_heatmap = EnrichmentMapManager.getInstance().isOverrideHeatmapRevalidation();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        if (network != null && e != null && (e.getSource() == network.getDefaultEdgeTable() || e.getSource() == network.getDefaultNodeTable()) && this.initialize(network) && !override_revalidate_heatmap) {
            HashMap<CyNetworkView, AutoAnnotationParameters> annotations;
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
            this.Edges.clear();
            this.Edges.addAll(selectedEdges);
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
            this.Nodes.clear();
            this.Nodes.addAll(selectedNodes);
            UpdateHeatMapTask updateHeatmap = new UpdateHeatMapTask(this.map, this.Nodes, this.Edges, this.edgeOverlapPanel, this.nodeOverlapPanel, this.cytoPanelSouth, this.applicationManager);
            Observer observer = new Observer();
            this.syncTaskManager.execute(new TaskIterator(new Task[]{updateHeatmap}), (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            if (AutoAnnotationManager.getInstance().getAnnotationPanel() != null && !AutoAnnotationManager.getInstance().isClusterTableUpdating() && e.getSource() == network.getDefaultNodeTable() && (annotations = AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters()).containsKey(view)) {
                AnnotationSet currentAnnotation = annotations.get(view).getSelectedAnnotationSet();
                TableModel clusterTableModel = currentAnnotation.getClusterTable().getModel();
                ListSelectionModel clusterListSelectionModel = currentAnnotation.getClusterTable().getSelectionModel();
                clusterListSelectionModel.setValueIsAdjusting(true);
                TreeMap<Integer, Cluster> clusters = currentAnnotation.getClusterMap();
                block3: for (Cluster cluster : clusters.values()) {
                    boolean select = true;
                    boolean unselectCluster = false;
                    for (CyNode node : cluster.getNodes()) {
                        if (!selectedNodes.contains(node) && cluster.isSelected()) {
                            unselectCluster = true;
                            break;
                        }
                        if (selectedNodes.contains(node)) continue;
                        select = false;
                        break;
                    }
                    if (select && cluster.isSelected()) {
                        select = false;
                    }
                    if (select) {
                        currentAnnotation.setManualSelection(true);
                        for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                            if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                            clusterListSelectionModel.addSelectionInterval(rowIndex, rowIndex);
                            break;
                        }
                    }
                    if (!unselectCluster) continue;
                    currentAnnotation.setManualSelection(true);
                    for (int rowIndex = 0; rowIndex < clusterTableModel.getRowCount(); ++rowIndex) {
                        if (!cluster.equals(clusterTableModel.getValueAt(rowIndex, 0))) continue;
                        clusterListSelectionModel.removeSelectionInterval(rowIndex, rowIndex);
                        continue block3;
                    }
                }
                clusterListSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.heatMapUpdating = false;
    }
}

