/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.util.FastMath;

public class Precision {
    public static final double EPSILON = Double.longBitsToDouble(4368491638549381120L);
    public static final double SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);

    public static boolean equals(double x, double y, double eps) {
        return Precision.equals(x, y, 1) || FastMath.abs(y - x) <= eps;
    }

    public static boolean equals(double x, double y, int maxUlps) {
        long xInt = Double.doubleToLongBits(x);
        long yInt = Double.doubleToLongBits(y);
        if (xInt < 0L) {
            xInt = Long.MIN_VALUE - xInt;
        }
        if (yInt < 0L) {
            yInt = Long.MIN_VALUE - yInt;
        }
        boolean isEqual = FastMath.abs(xInt - yInt) <= (long)maxUlps;
        return isEqual && !Double.isNaN(x) && !Double.isNaN(y);
    }
}

