/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapBuildProperties;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.BuildPostAnalysisActionListener;
import org.baderlab.csplugins.enrichmentmap.actions.ShowAboutPanelAction;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.util.SwingUtil;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisKnownSignaturePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisSignatureDiscoveryPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisInputPanel
extends JPanel {
    private final CyApplicationManager cyApplicationManager;
    private final CySwingApplication application;
    private final OpenBrowser browser;
    private final FileUtil fileUtil;
    private final CyServiceRegistrar registrar;
    private final CySessionManager sessionManager;
    private final StreamUtil streamUtil;
    private final DialogTaskManager dialogTaskManager;
    private final SynchronousTaskManager syncTaskManager;
    private final CyEventHelper eventHelper;
    private final EquationCompiler equationCompiler;
    private final VisualMappingManager visualMappingManager;
    private final VisualStyleFactory visualStyleFactory;
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;
    private JRadioButton knownSignature;
    private JRadioButton signatureDiscovery;
    private JPanel userInputPanel;
    private PostAnalysisSignatureDiscoveryPanel signatureDiscoveryPanel;
    private PostAnalysisKnownSignaturePanel knownSignaturePanel;
    private PostAnalysisParameters sigDiscoveryPaParams;
    private PostAnalysisParameters knownSigPaParams;

    public PostAnalysisInputPanel(CyApplicationManager cyApplicationManager, CySwingApplication application, OpenBrowser browser, FileUtil fileUtil, CySessionManager sessionManager, StreamUtil streamUtil, CyServiceRegistrar registrar, DialogTaskManager dialog, SynchronousTaskManager syncTaskManager, CyEventHelper eventHelper, EquationCompiler equationCompiler, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.browser = browser;
        this.fileUtil = fileUtil;
        this.registrar = registrar;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.dialogTaskManager = dialog;
        this.syncTaskManager = syncTaskManager;
        this.eventHelper = eventHelper;
        this.equationCompiler = equationCompiler;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.knownSignaturePanel = new PostAnalysisKnownSignaturePanel(this, cyApplicationManager, application, streamUtil, syncTaskManager);
        this.signatureDiscoveryPanel = new PostAnalysisSignatureDiscoveryPanel(this, cyApplicationManager, application, streamUtil, dialog, fileUtil);
        this.userInputPanel = new JPanel(new BorderLayout());
        this.userInputPanel.add((Component)this.knownSignaturePanel, "Center");
        this.setLayout(new BorderLayout());
        JPanel analysisTypePanel = this.createAnalysisTypePanel();
        this.add((Component)analysisTypePanel, "North");
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.userInputPanel);
        advancedOptionsContainer.add((Component)scrollPane, "Center");
        this.add((Component)advancedOptionsContainer, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)bottomPanel, "South");
    }

    private void flipPanels(JPanel toRemove, JPanel toAdd) {
        this.userInputPanel.remove(toRemove);
        this.userInputPanel.add((Component)toAdd, "Center");
        this.userInputPanel.revalidate();
        this.userInputPanel.repaint();
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.browser.openURL(EnrichmentMapBuildProperties.USER_MANUAL_URL);
            }
        });
        JButton about = new JButton("About");
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("inMenuBar", "true");
        serviceProperties.put("preferredMenu", "Apps.EnrichmentMap");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction(serviceProperties, this.cyApplicationManager, null, this.application, this.browser)));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Post Analysis Type"));
        this.knownSignature = new JRadioButton("Known Signature");
        this.knownSignature.setSelected(true);
        this.knownSignature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.flipPanels(PostAnalysisInputPanel.this.signatureDiscoveryPanel, PostAnalysisInputPanel.this.knownSignaturePanel);
            }
        });
        this.signatureDiscovery = new JRadioButton("Signature Discovery");
        this.signatureDiscovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.flipPanels(PostAnalysisInputPanel.this.knownSignaturePanel, PostAnalysisInputPanel.this.signatureDiscoveryPanel);
            }
        });
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.knownSignature);
        analysisOptions.add(this.signatureDiscovery);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.knownSignature, c);
        panel.add(this.knownSignature);
        c.gridy = 1;
        gridbag.setConstraints(this.signatureDiscovery, c);
        panel.add(this.signatureDiscovery);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.resetPanel();
            }
        });
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.close();
            }
        });
        JButton importButton = new JButton();
        importButton.setText("Run");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean okToRun = PostAnalysisInputPanel.this.beforeRun();
                if (okToRun) {
                    BuildPostAnalysisActionListener action = new BuildPostAnalysisActionListener(PostAnalysisInputPanel.this, PostAnalysisInputPanel.this.sessionManager, PostAnalysisInputPanel.this.streamUtil, PostAnalysisInputPanel.this.application, PostAnalysisInputPanel.this.cyApplicationManager, PostAnalysisInputPanel.this.dialogTaskManager, PostAnalysisInputPanel.this.eventHelper, PostAnalysisInputPanel.this.equationCompiler, PostAnalysisInputPanel.this.visualMappingManager, PostAnalysisInputPanel.this.visualStyleFactory, PostAnalysisInputPanel.this.vmfFactoryContinuous, PostAnalysisInputPanel.this.vmfFactoryDiscrete, PostAnalysisInputPanel.this.vmfFactoryPassthrough);
                    action.runPostAnalysis();
                }
            }
        });
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    protected File chooseGMTFile(JFormattedTextField textField) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        List<FileChooserFilter> all_filters = Arrays.asList(filter);
        File file = this.fileUtil.getFile(SwingUtil.getWindowInstance(this), "Import Signature GMT File", 0, all_filters);
        if (file != null) {
            String absolutePath = file.getAbsolutePath();
            textField.setForeground(PostAnalysisInputPanel.checkFile(absolutePath));
            textField.setText(absolutePath);
            textField.setValue(absolutePath);
            textField.setToolTipText(absolutePath);
            textField.setCaretPosition(textField.getText().length());
        }
        return file;
    }

    protected static boolean validateAndSetFilterValue(JFormattedTextField source, FilterParameters filterParams, StringBuilder message) {
        Number value = (Number)source.getValue();
        boolean valid = false;
        FilterParameters.FilterType type = filterParams.getType();
        switch (type) {
            case HYPERGEOM: {
                if (value != null && value.doubleValue() >= 0.0 && (double)value.intValue() <= 1.0) {
                    valid = true;
                    break;
                }
                message.append("The value must be greater than or equal 0.0 and less than or equal to 1.0");
                break;
            }
            case MANN_WHIT: {
                if (value != null && value.doubleValue() >= 0.0 && (double)value.intValue() <= 1.0) {
                    valid = true;
                    break;
                }
                message.append("The value must be greater than or equal 0.0 and less than or equal to 1.0");
                break;
            }
            case PERCENT: 
            case SPECIFIC: {
                if (value != null && value.intValue() >= 0 && value.intValue() <= 100) {
                    valid = true;
                    break;
                }
                message.append("The value must be greater than or equal 0 and less than or equal to 100.");
                break;
            }
            case NUMBER: {
                if (value != null && value.intValue() >= 0) {
                    valid = true;
                    break;
                }
                message.append("The value must be greater than or equal 0.");
                break;
            }
            default: {
                valid = true;
            }
        }
        if (valid) {
            filterParams.setValue(type, value.doubleValue());
        } else {
            source.setValue(type.defaultValue);
        }
        return valid;
    }

    public void close() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    protected static Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void resetPanel() {
        if (this.knownSigPaParams != null) {
            this.knownSignaturePanel.resetPanel();
        }
        if (this.sigDiscoveryPaParams != null) {
            this.signatureDiscoveryPanel.resetPanel();
        }
    }

    public void initialize(EnrichmentMap currentMap) {
        this.resetPanel();
        if (currentMap != null) {
            this.knownSigPaParams = new PostAnalysisParameters();
            this.knownSigPaParams.setSignatureHub(false);
            this.sigDiscoveryPaParams = new PostAnalysisParameters();
            this.sigDiscoveryPaParams.setSignatureHub(true);
            this.knownSignaturePanel.initialize(currentMap, this.knownSigPaParams);
            this.signatureDiscoveryPanel.initialize(currentMap, this.sigDiscoveryPaParams);
            this.knownSignature.setToolTipText(currentMap.getName());
        }
    }

    public PostAnalysisParameters getPaParams() {
        return this.knownSignature.isSelected() ? this.knownSigPaParams : this.sigDiscoveryPaParams;
    }

    public void setAvSigCount(int avSigCount) {
        if (this.signatureDiscovery.isSelected()) {
            this.signatureDiscoveryPanel.setAvSigCount(avSigCount);
        }
    }

    public boolean beforeRun() {
        if (this.knownSignature.isSelected()) {
            return this.knownSignaturePanel.beforeRun();
        }
        return true;
    }
}

