/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ParseGSEAEnrichmentResults
extends AbstractTask {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public ParseGSEAEnrichmentResults(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
    }

    public void parse() throws IOException {
        if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName1);
        }
        if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName2);
        }
    }

    public void readFile(String EnrichmentResultFileName) throws IOException {
        InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        this.parseGSEAFile(lines);
    }

    public void parseGSEAFile(String[] lines) {
        this.dataset.getMap().getParams().setFDR(true);
        int currentProgress = 0;
        int maxValue = lines.length;
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            int size = 0;
            double ES = 0.0;
            double NES = 0.0;
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            double FWERqvalue = 1.0;
            int rankAtMax = -1;
            double scoreAtMax = DefaultScoreAtMax;
            String Name = tokens[0].toUpperCase().trim();
            if (!tokens[3].equalsIgnoreCase("")) {
                size = Integer.parseInt(tokens[3]);
            }
            if (!tokens[4].equalsIgnoreCase("")) {
                ES = Double.parseDouble(tokens[4]);
            }
            if (!tokens[5].equalsIgnoreCase("")) {
                NES = Double.parseDouble(tokens[5]);
            }
            if (!tokens[6].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[6]);
            }
            if (!tokens[7].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[7]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                FWERqvalue = Double.parseDouble(tokens[8]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                rankAtMax = Integer.parseInt(tokens[9]);
            }
            GSEAResult result = new GSEAResult(Name, size, ES, NES, pvalue, FDRqvalue, FWERqvalue, rankAtMax, scoreAtMax);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Enrichment Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            this.results.put(Name, result);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Parsing GSEA Enrichment Result file");
        this.parse();
    }
}

