/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class ParseGREATEnrichmentResults
extends AbstractTask
implements ObservableTask {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public ParseGREATEnrichmentResults(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
    }

    public void parse() throws IOException {
        if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName1);
        }
        if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName2);
        }
    }

    public void readFile(String EnrichmentResultFileName) throws IOException {
        InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        this.parseGreatFile(lines);
    }

    public void parseGreatFile(String[] lines) {
        int length;
        int k;
        boolean hasBackground = false;
        EnrichmentMapParameters params = this.dataset.getMap().getParams();
        String filterType = this.dataset.getMap().getParams().getGreat_Filter();
        HashMap<String, GeneSet> genesets = this.dataset.getSetofgenesets().getGenesets();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        HashMap<Integer, String> key2gene = this.dataset.getMap().getHashkey2gene();
        int currentProgress = 0;
        int maxValue = lines.length;
        this.dataset.getMap().getParams().setFDR(true);
        String line = lines[k];
        String[] tokens = line.split("\t");
        for (k = 0; !(k >= lines.length || (length = (tokens = (line = lines[k]).split("\t")).length) == 24 && tokens[3].equalsIgnoreCase("BinomRank")); ++k) {
            if (length != 20 || !tokens[3].equalsIgnoreCase("Rank")) continue;
            hasBackground = true;
            break;
        }
        for (int i = k + 1; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            if (!hasBackground && tokens.length != 24 || hasBackground && tokens.length != 20) continue;
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[1].trim() + "-" + tokens[2].trim();
            String description = tokens[2].trim();
            GeneSet gs = genesets.containsKey(name) ? genesets.get(name) : new GeneSet(name, description);
            String[] gene_tokens = !hasBackground ? tokens[23].split(",") : tokens[18].split(",");
            for (int j = 0; j < gene_tokens.length; ++j) {
                String gene = gene_tokens[j].toUpperCase();
                if (genes.containsKey(gene)) {
                    gs.addGene(genes.get(gene));
                    continue;
                }
                if (gene.equalsIgnoreCase("")) continue;
                int value = this.dataset.getMap().getNumberOfGenes();
                genes.put(gene, value);
                key2gene.put(value, gene);
                this.dataset.getMap().setNumberOfGenes(value + 1);
                gs.addGene(genes.get(gene));
            }
            genesets.put(name, gs);
            double hyper_pvalue = 1.0;
            double hyper_fdr = 1.0;
            double binom_pvalue = 1.0;
            double binom_fdr = 1.0;
            if (!hasBackground) {
                if (!tokens[4].equalsIgnoreCase("")) {
                    binom_pvalue = Double.parseDouble(tokens[4]);
                }
                if (!tokens[6].equalsIgnoreCase("")) {
                    binom_fdr = Double.parseDouble(tokens[6]);
                }
                if (!tokens[13].equalsIgnoreCase("")) {
                    hyper_pvalue = Double.parseDouble(tokens[13]);
                }
                if (!tokens[15].equalsIgnoreCase("")) {
                    hyper_fdr = Double.parseDouble(tokens[15]);
                }
            } else {
                if (!tokens[4].equalsIgnoreCase("")) {
                    hyper_pvalue = Double.parseDouble(tokens[4]);
                }
                if (!tokens[6].equalsIgnoreCase("")) {
                    hyper_fdr = Double.parseDouble(tokens[6]);
                }
            }
            if (filterType.equalsIgnoreCase("HYPER")) {
                pvalue = hyper_pvalue;
                FDRqvalue = hyper_fdr;
            } else if (filterType.equalsIgnoreCase("BINOM")) {
                pvalue = binom_pvalue;
                FDRqvalue = binom_fdr;
            } else if (filterType.equalsIgnoreCase("BOTH")) {
                pvalue = hyper_pvalue >= binom_pvalue ? hyper_pvalue : binom_pvalue;
                FDRqvalue = hyper_fdr >= binom_fdr ? hyper_fdr : binom_fdr;
            } else if (filterType.equalsIgnoreCase("EITHER")) {
                pvalue = hyper_pvalue >= binom_pvalue ? binom_pvalue : hyper_pvalue;
                FDRqvalue = hyper_fdr >= binom_fdr ? binom_fdr : hyper_fdr;
            } else {
                System.out.println("Invalid attribute setting for GREAT p-value specification");
            }
            if (pvalue < params.getPvalue_min()) {
                params.setPvalue_min(pvalue);
            }
            if (FDRqvalue < params.getQvalue_min()) {
                params.setQvalue_min(FDRqvalue);
            }
            if (!hasBackground && !tokens[19].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[19]);
            } else if (hasBackground && !tokens[15].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[15]);
            }
            GenericResult result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Great Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Parsing GSEA Enrichment Result file");
        this.parse();
    }

    public <R> R getResults(Class<? extends R> arg0) {
        return null;
    }
}

