/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

public abstract class AbstractStepInterpolator
implements StepInterpolator {
    protected double h;
    protected double[] currentState;
    protected double interpolatedTime;
    protected double[] interpolatedState;
    protected double[] interpolatedDerivatives;
    protected double[] interpolatedPrimaryState;
    protected double[] interpolatedPrimaryDerivatives;
    protected double[][] interpolatedSecondaryState;
    protected double[][] interpolatedSecondaryDerivatives;
    private double globalPreviousTime;
    private double globalCurrentTime;
    private double softPreviousTime;
    private double softCurrentTime;
    private boolean finalized;
    private boolean forward;
    private boolean dirtyState;
    private EquationsMapper primaryMapper;
    private EquationsMapper[] secondaryMappers;

    private void allocateInterpolatedArrays(int dimension) {
        if (dimension < 0) {
            this.interpolatedState = null;
            this.interpolatedDerivatives = null;
            this.interpolatedPrimaryState = null;
            this.interpolatedPrimaryDerivatives = null;
            this.interpolatedSecondaryState = null;
            this.interpolatedSecondaryDerivatives = null;
        } else {
            this.interpolatedState = new double[dimension];
            this.interpolatedDerivatives = new double[dimension];
            this.interpolatedPrimaryState = new double[this.primaryMapper.getDimension()];
            this.interpolatedPrimaryDerivatives = new double[this.primaryMapper.getDimension()];
            if (this.secondaryMappers == null) {
                this.interpolatedSecondaryState = null;
                this.interpolatedSecondaryDerivatives = null;
            } else {
                this.interpolatedSecondaryState = new double[this.secondaryMappers.length][];
                this.interpolatedSecondaryDerivatives = new double[this.secondaryMappers.length][];
                for (int i = 0; i < this.secondaryMappers.length; ++i) {
                    this.interpolatedSecondaryState[i] = new double[this.secondaryMappers[i].getDimension()];
                    this.interpolatedSecondaryDerivatives[i] = new double[this.secondaryMappers[i].getDimension()];
                }
            }
        }
    }

    public void setInterpolatedTime(double time) {
        this.interpolatedTime = time;
        this.dirtyState = true;
    }

    public final void finalizeStep() throws MaxCountExceededException {
        if (!this.finalized) {
            this.doFinalize();
            this.finalized = true;
        }
    }

    protected void doFinalize() throws MaxCountExceededException {
    }

    protected void writeBaseExternal(ObjectOutput out) throws IOException {
        if (this.currentState == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.currentState.length);
        }
        out.writeDouble(this.globalPreviousTime);
        out.writeDouble(this.globalCurrentTime);
        out.writeDouble(this.softPreviousTime);
        out.writeDouble(this.softCurrentTime);
        out.writeDouble(this.h);
        out.writeBoolean(this.forward);
        out.writeObject(this.primaryMapper);
        out.write(this.secondaryMappers.length);
        for (EquationsMapper mapper : this.secondaryMappers) {
            out.writeObject(mapper);
        }
        if (this.currentState != null) {
            for (int i = 0; i < this.currentState.length; ++i) {
                out.writeDouble(this.currentState[i]);
            }
        }
        out.writeDouble(this.interpolatedTime);
        try {
            this.finalizeStep();
        }
        catch (MaxCountExceededException mcee) {
            IOException ioe = new IOException(mcee.getLocalizedMessage());
            ioe.initCause(mcee);
            throw ioe;
        }
    }

    protected double readBaseExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int dimension = in.readInt();
        this.globalPreviousTime = in.readDouble();
        this.globalCurrentTime = in.readDouble();
        this.softPreviousTime = in.readDouble();
        this.softCurrentTime = in.readDouble();
        this.h = in.readDouble();
        this.forward = in.readBoolean();
        this.primaryMapper = (EquationsMapper)in.readObject();
        this.secondaryMappers = new EquationsMapper[in.read()];
        for (i = 0; i < this.secondaryMappers.length; ++i) {
            this.secondaryMappers[i] = (EquationsMapper)in.readObject();
        }
        this.dirtyState = true;
        if (dimension < 0) {
            this.currentState = null;
        } else {
            this.currentState = new double[dimension];
            for (i = 0; i < this.currentState.length; ++i) {
                this.currentState[i] = in.readDouble();
            }
        }
        this.interpolatedTime = Double.NaN;
        this.allocateInterpolatedArrays(dimension);
        this.finalized = true;
        return in.readDouble();
    }
}

