/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat;

import cern.jet.math.Constants;
import cern.jet.math.Polynomial;

public class Gamma
extends Constants {
    public static double logGamma(double d) throws ArithmeticException {
        double[] dArray = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] dArray2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] dArray3 = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (d < -34.0) {
            double d2 = -d;
            double d3 = Gamma.logGamma(d2);
            double d4 = Math.floor(d2);
            if (d4 == d2) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double d5 = d2 - d4;
            if (d5 > 0.5) {
                d5 = (d4 += 1.0) - d2;
            }
            if ((d5 = d2 * Math.sin(Math.PI * d5)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            d5 = 1.1447298858494002 - Math.log(d5) - d3;
            return d5;
        }
        if (d < 13.0) {
            double d6 = 1.0;
            while (d >= 3.0) {
                d6 *= (d -= 1.0);
            }
            while (d < 2.0) {
                if (d == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                d6 /= d;
                d += 1.0;
            }
            if (d6 < 0.0) {
                d6 = -d6;
            }
            if (d == 2.0) {
                return Math.log(d6);
            }
            double d7 = (d -= 2.0) * Polynomial.polevl(d, dArray2, 5) / Polynomial.p1evl(d, dArray3, 6);
            return Math.log(d6) + d7;
        }
        if (d > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double d8 = (d - 0.5) * Math.log(d) - d + 0.9189385332046728;
        if (d > 1.0E8) {
            return d8;
        }
        double d9 = 1.0 / (d * d);
        d8 = d >= 1000.0 ? (d8 += ((7.936507936507937E-4 * d9 - 0.002777777777777778) * d9 + 0.08333333333333333) / d) : (d8 += Polynomial.polevl(d9, dArray, 4) / d);
        return d8;
    }
}

