/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.LoadSignatureSetsActionListener;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisWeightPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisSignatureDiscoveryPanel
extends JPanel {
    private final PostAnalysisInputPanel parentPanel;
    private final CyApplicationManager cyApplicationManager;
    private final CySwingApplication application;
    private final StreamUtil streamUtil;
    private final DialogTaskManager dialog;
    private final FileUtil fileUtil;
    private PostAnalysisParameters paParams;
    private EnrichmentMap map;
    private JFormattedTextField signatureDiscoveryGMTFileNameTextField;
    private PostAnalysisWeightPanel weightPanel;
    private JLabel avail_sig_sets_counter_label;
    private JList<String> avail_sig_sets_field;
    private CollapsiblePanel signature_genesets;
    private JPanel signaturePanel;
    private JList<String> selected_sig_sets_field;
    private JLabel selected_sig_sets_counter_label;
    private DefaultListModel<String> avail_sig_sets;
    private DefaultListModel<String> selected_sig_sets;
    private JFormattedTextField filterTextField;
    private JComboBox<FilterParameters.FilterType> filterTypeCombo;

    public PostAnalysisSignatureDiscoveryPanel(PostAnalysisInputPanel parentPanel, CyApplicationManager cyApplicationManager, CySwingApplication application, StreamUtil streamUtil, DialogTaskManager dialog, FileUtil fileUtil) {
        this.parentPanel = parentPanel;
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.streamUtil = streamUtil;
        this.dialog = dialog;
        this.fileUtil = fileUtil;
        this.createSignatureDiscoveryOptionsPanel();
    }

    private void createSignatureDiscoveryOptionsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        CollapsiblePanel gmtPanel = this.createSignatureDiscoveryGMTPanel();
        gmtPanel.setCollapsed(false);
        this.signature_genesets = new CollapsiblePanel("Signature Genesets");
        this.signature_genesets.setLayout(new BorderLayout());
        this.signature_genesets.setCollapsed(false);
        this.signaturePanel = new JPanel();
        this.signaturePanel.setLayout(new BoxLayout(this.signaturePanel, 1));
        this.signaturePanel.setAlignmentX(0.0f);
        JPanel availableLabel = new JPanel(new FlowLayout());
        availableLabel.add(new JLabel("Available Signature-Genesets:"));
        this.avail_sig_sets_counter_label = new JLabel("(0)");
        availableLabel.add(this.avail_sig_sets_counter_label);
        this.signaturePanel.add(availableLabel);
        this.avail_sig_sets_field = new JList();
        JScrollPane avail_sig_sets_scroll = new JScrollPane(this.avail_sig_sets_field, 22, 30);
        avail_sig_sets_scroll.setPreferredSize(new Dimension(250, 200));
        avail_sig_sets_scroll.setMinimumSize(new Dimension(250, 150));
        avail_sig_sets_scroll.setMaximumSize(new Dimension(290, 300));
        this.signaturePanel.add(avail_sig_sets_scroll);
        ImageIcon[] icons = this.createArrowIcons();
        JPanel selectButtonPanel = new JPanel();
        selectButtonPanel.add(new JPanel());
        selectButtonPanel.setLayout(new BoxLayout(selectButtonPanel, 0));
        JButton selectButton = new JButton(icons[1]);
        selectButton.getSize().width = 30;
        selectButtonPanel.add(selectButton);
        selectButtonPanel.add(new JPanel());
        JButton unselectButton = new JButton(icons[2]);
        unselectButton.getSize().width = 30;
        selectButtonPanel.add(unselectButton);
        selectButtonPanel.add(new JPanel());
        this.signaturePanel.add(selectButtonPanel);
        JPanel selectedLabel = new JPanel();
        selectedLabel.add(new JLabel("Selected Signature-Genesets:"));
        this.selected_sig_sets_counter_label = new JLabel("(0)");
        selectedLabel.add(this.selected_sig_sets_counter_label);
        this.signaturePanel.add(selectedLabel);
        this.selected_sig_sets_field = new JList();
        JScrollPane selected_sig_sets_scroll = new JScrollPane(this.selected_sig_sets_field, 22, 30);
        selected_sig_sets_scroll.setPreferredSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMinimumSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMaximumSize(new Dimension(290, 200));
        this.signaturePanel.add(selected_sig_sets_scroll);
        JPanel clearButtonPanel = new JPanel();
        clearButtonPanel.setLayout(new FlowLayout());
        JButton clearButton = new JButton("Clear Signature Genesets");
        clearButtonPanel.add(clearButton);
        this.signaturePanel.add(clearButtonPanel);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostAnalysisSignatureDiscoveryPanel.this.paParams.setSignatureGenesets(new SetOfGeneSets());
                PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.clear();
                PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets_field.clearSelection();
                PostAnalysisSignatureDiscoveryPanel.this.setAvSigCount(0);
                PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.clear();
                PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets_field.clearSelection();
                PostAnalysisSignatureDiscoveryPanel.this.setSelSigCount(0);
            }
        });
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.addElement(PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.get(selected[i - 1]));
                    PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.remove(selected[i - 1]);
                }
                PostAnalysisSignatureDiscoveryPanel.this.setSelSigCount(PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.size());
                PostAnalysisSignatureDiscoveryPanel.this.setAvSigCount(PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.size());
            }
        });
        unselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.addElement(PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.get(selected[i - 1]));
                    PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.remove(selected[i - 1]);
                }
                ArrayList<String> setNamesArray = Collections.list(PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.elements());
                Collections.sort(setNamesArray);
                PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.removeAllElements();
                for (String name : setNamesArray) {
                    PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.addElement(name);
                }
                PostAnalysisSignatureDiscoveryPanel.this.setAvSigCount(PostAnalysisSignatureDiscoveryPanel.this.avail_sig_sets.size());
                PostAnalysisSignatureDiscoveryPanel.this.setSelSigCount(PostAnalysisSignatureDiscoveryPanel.this.selected_sig_sets.size());
            }
        });
        this.signature_genesets.getContentPane().add((Component)this.signaturePanel, "North");
        this.weightPanel = new PostAnalysisWeightPanel(this.application);
        this.weightPanel.setCollapsed(false);
        this.add(gmtPanel);
        this.add(this.signature_genesets);
        this.add(this.weightPanel);
    }

    private CollapsiblePanel createSignatureDiscoveryGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene-Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel SigGMTLabel = new JLabel("SigGMT:"){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        SigGMTLabel.setToolTipText("File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...");
        JButton selectSigGMTFileButton = new JButton();
        this.signatureDiscoveryGMTFileNameTextField = new JFormattedTextField();
        this.signatureDiscoveryGMTFileNameTextField.setColumns(15);
        final Color textFieldForeground = this.signatureDiscoveryGMTFileNameTextField.getForeground();
        this.signatureDiscoveryGMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.signatureDiscoveryGMTFileNameTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PostAnalysisSignatureDiscoveryPanel.this.signatureDiscoveryGMTFileNameTextField.setForeground(textFieldForeground);
            }
        });
        selectSigGMTFileButton.setText("...");
        selectSigGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectSigGMTFileButton.setActionCommand("Signature Discovery");
        selectSigGMTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisSignatureDiscoveryPanel.this.parentPanel.chooseGMTFile(PostAnalysisSignatureDiscoveryPanel.this.signatureDiscoveryGMTFileNameTextField);
            }
        });
        JPanel SigGMTPanel = new JPanel();
        SigGMTPanel.setLayout(new BorderLayout());
        SigGMTPanel.add((Component)SigGMTLabel, "West");
        SigGMTPanel.add((Component)this.signatureDiscoveryGMTFileNameTextField, "Center");
        SigGMTPanel.add((Component)selectSigGMTFileButton, "East");
        panel.add(SigGMTPanel);
        CollapsiblePanel filterPanel = this.createFilterPanel();
        panel.add(filterPanel);
        JButton loadButton = new JButton();
        loadButton.setText("Load Gene-Sets");
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filePath = (String)PostAnalysisSignatureDiscoveryPanel.this.signatureDiscoveryGMTFileNameTextField.getValue();
                if (filePath == null || PostAnalysisInputPanel.checkFile(filePath).equals(Color.RED)) {
                    String message = "SigGMT file name not valid.\n";
                    PostAnalysisSignatureDiscoveryPanel.this.signatureDiscoveryGMTFileNameTextField.setForeground(Color.RED);
                    JOptionPane.showMessageDialog(PostAnalysisSignatureDiscoveryPanel.this.application.getJFrame(), message, "Post Analysis Known Signature", 2);
                    return;
                }
                PostAnalysisSignatureDiscoveryPanel.this.paParams.setSignatureGMTFileName(filePath);
                LoadSignatureSetsActionListener action = new LoadSignatureSetsActionListener(PostAnalysisSignatureDiscoveryPanel.this.parentPanel, PostAnalysisSignatureDiscoveryPanel.this.application, PostAnalysisSignatureDiscoveryPanel.this.cyApplicationManager, (TaskManager<?, ?>)PostAnalysisSignatureDiscoveryPanel.this.dialog, PostAnalysisSignatureDiscoveryPanel.this.streamUtil);
                action.actionPerformed(null);
            }
        });
        loadButton.setAlignmentX(0.5f);
        panel.add(loadButton);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createFilterPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Filter");
        collapsiblePanel.setCollapsed(false);
        this.filterTextField = new JFormattedTextField();
        this.filterTextField.setColumns(4);
        this.filterTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                StringBuilder message = new StringBuilder("The value you have entered is invalid.\n");
                boolean valid = PostAnalysisInputPanel.validateAndSetFilterValue(PostAnalysisSignatureDiscoveryPanel.this.filterTextField, PostAnalysisSignatureDiscoveryPanel.this.paParams.getFilterParameters(), message);
                if (!valid) {
                    JOptionPane.showMessageDialog(PostAnalysisSignatureDiscoveryPanel.this.application.getJFrame(), message.toString(), "Parameter out of bounds", 2);
                }
            }
        });
        this.filterTypeCombo = new JComboBox();
        this.filterTypeCombo.addItem(FilterParameters.FilterType.NO_FILTER);
        this.filterTypeCombo.addItem(FilterParameters.FilterType.MANN_WHIT);
        this.filterTypeCombo.addItem(FilterParameters.FilterType.HYPERGEOM);
        this.filterTypeCombo.addItem(FilterParameters.FilterType.NUMBER);
        this.filterTypeCombo.addItem(FilterParameters.FilterType.PERCENT);
        this.filterTypeCombo.addItem(FilterParameters.FilterType.SPECIFIC);
        this.filterTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterParameters.FilterType filterType = (FilterParameters.FilterType)((Object)PostAnalysisSignatureDiscoveryPanel.this.filterTypeCombo.getSelectedItem());
                FilterParameters filterParams = PostAnalysisSignatureDiscoveryPanel.this.paParams.getFilterParameters();
                filterParams.setType(filterType);
                PostAnalysisSignatureDiscoveryPanel.this.filterTextField.setValue(filterParams.getValue(filterType));
                PostAnalysisSignatureDiscoveryPanel.this.filterTextField.setEnabled(filterType != FilterParameters.FilterType.NO_FILTER);
            }
        });
        JPanel filterTypePanel = new JPanel(new BorderLayout());
        filterTypePanel.add(this.filterTypeCombo, "Center");
        filterTypePanel.add((Component)this.filterTextField, "East");
        collapsiblePanel.getContentPane().add(filterTypePanel);
        return collapsiblePanel;
    }

    void resetPanel() {
        this.paParams.setSignatureGenesets(new SetOfGeneSets());
        this.signatureDiscoveryGMTFileNameTextField.setText("");
        this.signatureDiscoveryGMTFileNameTextField.setValue("");
        this.signatureDiscoveryGMTFileNameTextField.setToolTipText(null);
        this.paParams.getSignatureSetNames().clear();
        this.avail_sig_sets.clear();
        this.avail_sig_sets_field.clearSelection();
        this.setAvSigCount(0);
        this.paParams.getSelectedSignatureSetNames().clear();
        this.selected_sig_sets.clear();
        this.selected_sig_sets_field.clearSelection();
        this.setSelSigCount(0);
        this.paParams.getFilterParameters().setType(FilterParameters.FilterType.NO_FILTER);
        this.filterTypeCombo.setSelectedItem((Object)FilterParameters.FilterType.NO_FILTER);
        this.weightPanel.resetPanel();
    }

    void initialize(EnrichmentMap currentMap, PostAnalysisParameters paParams) {
        this.map = currentMap;
        this.paParams = paParams;
        this.weightPanel.initialize(currentMap, paParams);
        FilterParameters filterParams = paParams.getFilterParameters();
        this.filterTypeCombo.setSelectedItem((Object)filterParams.getType());
        this.filterTextField.setValue(filterParams.getValue(filterParams.getType()));
        this.avail_sig_sets = paParams.getSignatureSetNames();
        this.selected_sig_sets = paParams.getSelectedSignatureSetNames();
        this.avail_sig_sets_field.setModel(this.avail_sig_sets);
        this.selected_sig_sets_field.setModel(this.selected_sig_sets);
    }

    private ImageIcon[] createArrowIcons() {
        ImageIcon[] iconArrow = new ImageIcon[4];
        URL iconURL = this.getClass().getResource("arrow_up.gif");
        if (iconURL != null) {
            iconArrow[2] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_down.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_left.gif")) != null) {
            iconArrow[3] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_right.gif")) != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    public void setAvSigCount(int avSigCount) {
        this.avail_sig_sets_counter_label.setText("(" + Integer.toString(avSigCount) + ")");
    }

    public void setSelSigCount(int num) {
        this.selected_sig_sets_counter_label.setText("(" + Integer.toString(num) + ")");
    }
}

