/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.csplugins.brainlib.AvgLinkHierarchicalClustering;
import org.baderlab.csplugins.brainlib.DistanceMatrix;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.CosineDistance;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EuclideanDistance;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.model.PearsonCorrelation;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class HeatMapHierarchicalClusterTask
extends AbstractTask
implements ObservableTask {
    private int numConditions = 0;
    private int numConditions2 = 0;
    private HashMap<Integer, GeneExpression> currentExpressionSet;
    private HashMap<Integer, GeneExpression> currentExpressionSet2;
    private HeatMapPanel heatmapPanel;
    private EnrichmentMap map;
    private EnrichmentMapParameters params;
    private HeatMapParameters hmParams;
    private Ranking ranks = null;
    private boolean shownPearsonErrorMsg = false;
    private TaskMonitor taskMonitor;

    public HeatMapHierarchicalClusterTask(int numConditions, int numConditions2, HeatMapPanel heatmapPanel, EnrichmentMap map) {
        this.numConditions = numConditions;
        this.numConditions2 = numConditions2;
        this.heatmapPanel = heatmapPanel;
        this.currentExpressionSet = this.heatmapPanel.getCurrentExpressionSet();
        this.currentExpressionSet2 = this.heatmapPanel.getCurrentExpressionSet2();
        this.map = map;
        this.params = map.getParams();
        this.hmParams = this.params.getHmParams();
    }

    private void calculateRanksByClustering() throws Exception {
        int numdatacolumns = 0;
        int numdatacolumns2 = 0;
        int set1_size = 0;
        int set2_size = 0;
        if (this.currentExpressionSet != null) {
            set1_size = this.currentExpressionSet.keySet().size();
        }
        if (this.currentExpressionSet2 != null) {
            set2_size = this.currentExpressionSet2.keySet().size();
        }
        boolean cluster = true;
        if (this.numConditions > 0) {
            numdatacolumns = this.numConditions - 2;
        }
        if (this.numConditions2 > 0) {
            numdatacolumns2 = this.numConditions2 - 2;
        }
        if ((set1_size > 1 || set2_size > 1) && numdatacolumns + numdatacolumns2 > 1) {
            if (cluster) {
                try {
                    Double[] z;
                    Double[] dummyexpression2;
                    Double[] dummyexpression1;
                    Double[] y;
                    this.taskMonitor.setProgress(0.0);
                    this.taskMonitor.setStatusMessage("Preparing data to cluster");
                    this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
                    ArrayList<Double[]> clustering_expressionset = new ArrayList<Double[]>();
                    ArrayList<Integer> labels = new ArrayList<Integer>();
                    int j = 0;
                    if (set1_size == set2_size && set1_size != 0) {
                        for (Integer key : this.currentExpressionSet.keySet()) {
                            Double[] z2;
                            Double[] x = this.currentExpressionSet.get(key).getExpression();
                            if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && this.currentExpressionSet2.containsKey(key) && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                                y = this.currentExpressionSet2.get(key).getExpression();
                                z2 = new Double[x.length + y.length];
                                System.arraycopy(x, 0, z2, 0, x.length);
                                System.arraycopy(y, 0, z2, x.length, y.length);
                            } else {
                                z2 = x;
                            }
                            clustering_expressionset.add(j, z2);
                            labels.add(j, key);
                            this.taskMonitor.setProgress((double)((int)((double)(++j) / (double)this.currentExpressionSet.size() * 100.0)));
                        }
                    } else if (set1_size > 0 && set2_size > 0) {
                        Double[] z3;
                        int k;
                        dummyexpression1 = new Double[numdatacolumns];
                        dummyexpression2 = new Double[numdatacolumns2];
                        for (k = 0; k < numdatacolumns; ++k) {
                            dummyexpression1[k] = 0.0;
                        }
                        for (k = 0; k < numdatacolumns2; ++k) {
                            dummyexpression2[k] = 0.0;
                        }
                        int total = numdatacolumns + numdatacolumns2;
                        for (Integer key : this.currentExpressionSet.keySet()) {
                            Double[] x = this.currentExpressionSet.get(key).getExpression();
                            if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && this.currentExpressionSet2.containsKey(key) && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                                Double[] y2 = this.currentExpressionSet2.get(key).getExpression();
                                z3 = new Double[x.length + y2.length];
                                System.arraycopy(x, 0, z3, 0, x.length);
                                System.arraycopy(y2, 0, z3, x.length, y2.length);
                            } else {
                                z3 = new Double[x.length + dummyexpression2.length];
                                System.arraycopy(x, 0, z3, 0, x.length);
                                System.arraycopy(dummyexpression2, 0, z3, x.length, dummyexpression2.length);
                            }
                            clustering_expressionset.add(j, z3);
                            labels.add(j, key);
                            this.taskMonitor.setProgress((double)((int)((double)(++j) / (double)total * 100.0)));
                        }
                        for (Integer key : this.currentExpressionSet2.keySet()) {
                            Double[] y3 = this.currentExpressionSet2.get(key).getExpression();
                            if (this.currentExpressionSet.containsKey(key)) {
                                Double[] x = this.currentExpressionSet.get(key).getExpression();
                                z3 = new Double[x.length + y3.length];
                                System.arraycopy(x, 0, z3, 0, x.length);
                                System.arraycopy(y3, 0, z3, x.length, y3.length);
                            } else {
                                z3 = new Double[y3.length + dummyexpression1.length];
                                System.arraycopy(dummyexpression1, 0, z3, 0, dummyexpression1.length);
                                System.arraycopy(y3, 0, z3, dummyexpression1.length, y3.length);
                            }
                            clustering_expressionset.add(j, z3);
                            labels.add(j, key);
                            this.taskMonitor.setProgress((double)((int)((double)(++j + numdatacolumns / total) * 100.0)));
                        }
                    } else if (set1_size > 0 && set2_size == 0) {
                        int k;
                        dummyexpression1 = new Double[numdatacolumns];
                        dummyexpression2 = new Double[numdatacolumns2];
                        for (k = 0; k < numdatacolumns; ++k) {
                            dummyexpression1[k] = 0.0;
                        }
                        for (k = 0; k < numdatacolumns2; ++k) {
                            dummyexpression2[k] = 0.0;
                        }
                        for (Integer key : this.currentExpressionSet.keySet()) {
                            Double[] x = this.currentExpressionSet.get(key).getExpression();
                            if (this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null && this.currentExpressionSet2.containsKey(key) && !this.map.getDataset("Dataset 1").getExpressionSets().getFilename().equalsIgnoreCase(this.map.getDataset("Dataset 2").getExpressionSets().getFilename())) {
                                Double[] y4 = this.currentExpressionSet2.get(key).getExpression();
                                z = new Double[x.length + y4.length];
                                System.arraycopy(x, 0, z, 0, x.length);
                                System.arraycopy(y4, 0, z, x.length, y4.length);
                            } else {
                                z = new Double[x.length + dummyexpression2.length];
                                System.arraycopy(x, 0, z, 0, x.length);
                                System.arraycopy(dummyexpression2, 0, z, x.length, dummyexpression2.length);
                            }
                            clustering_expressionset.add(j, z);
                            labels.add(j, key);
                            this.taskMonitor.setProgress((double)((int)((double)(++j) / (double)this.currentExpressionSet.size() * 100.0)));
                        }
                    } else if (set2_size > 0 && set1_size == 0) {
                        int k;
                        dummyexpression1 = new Double[numdatacolumns];
                        dummyexpression2 = new Double[numdatacolumns2];
                        for (k = 0; k < numdatacolumns; ++k) {
                            dummyexpression1[k] = 0.0;
                        }
                        for (k = 0; k < numdatacolumns2; ++k) {
                            dummyexpression2[k] = 0.0;
                        }
                        for (Integer key : this.currentExpressionSet2.keySet()) {
                            y = this.currentExpressionSet2.get(key).getExpression();
                            if (this.currentExpressionSet.containsKey(key)) {
                                Double[] x = this.currentExpressionSet.get(key).getExpression();
                                z = new Double[x.length + y.length];
                                System.arraycopy(x, 0, z, 0, x.length);
                                System.arraycopy(y, 0, z, x.length, y.length);
                            } else {
                                z = new Double[y.length + dummyexpression1.length];
                                System.arraycopy(dummyexpression1, 0, z, 0, dummyexpression1.length);
                                System.arraycopy(y, 0, z, dummyexpression1.length, y.length);
                            }
                            clustering_expressionset.add(j, z);
                            labels.add(j, key);
                            this.taskMonitor.setProgress((double)((int)((double)(++j) / (double)this.currentExpressionSet2.size() * 100.0)));
                        }
                    }
                    this.taskMonitor.setProgress(0.0);
                    this.taskMonitor.setStatusMessage("Calculating Distance");
                    DistanceMatrix distanceMatrix = set1_size == set2_size ? new DistanceMatrix(this.currentExpressionSet.keySet().size()) : (set1_size == 0 ? new DistanceMatrix(this.currentExpressionSet2.keySet().size()) : (set2_size == 0 ? new DistanceMatrix(this.currentExpressionSet.keySet().size()) : new DistanceMatrix(this.currentExpressionSet2.keySet().size() + this.currentExpressionSet.keySet().size())));
                    if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.pearson_correlation)) {
                        try {
                            distanceMatrix.calcDistances(clustering_expressionset, new PearsonCorrelation());
                        }
                        catch (RuntimeException e) {
                            try {
                                if (!this.shownPearsonErrorMsg) {
                                    this.shownPearsonErrorMsg = true;
                                }
                                distanceMatrix.calcDistances(clustering_expressionset, new CosineDistance());
                            }
                            catch (RuntimeException ex) {
                                distanceMatrix.calcDistances(clustering_expressionset, new EuclideanDistance());
                            }
                        }
                    } else if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.cosine)) {
                        distanceMatrix.calcDistances(clustering_expressionset, new CosineDistance());
                    } else if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.euclidean)) {
                        distanceMatrix.calcDistances(clustering_expressionset, new EuclideanDistance());
                    }
                    distanceMatrix.setLabels(labels);
                    AvgLinkHierarchicalClustering cluster_result = new AvgLinkHierarchicalClustering(distanceMatrix);
                    if (set1_size + set2_size > 1000) {
                        cluster_result.setOptimalLeafOrdering(false);
                    } else {
                        cluster_result.setOptimalLeafOrdering(true);
                    }
                    cluster_result.run();
                    this.taskMonitor.setStatusMessage("Caculating Ranks");
                    this.taskMonitor.setProgress(0.0);
                    int[] order = cluster_result.getLeafOrder();
                    this.ranks = new Ranking();
                    for (int i = 0; i < order.length; ++i) {
                        Integer label = (Integer)labels.get(order[i]);
                        GeneExpression exp = this.currentExpressionSet.containsKey(label) ? this.currentExpressionSet.get(label) : (this.currentExpressionSet2.containsKey(label) ? this.currentExpressionSet2.get(label) : null);
                        Rank temp = new Rank(exp.getName(), 0.0, i);
                        this.ranks.addRank(label, temp);
                        this.taskMonitor.setProgress((double)((int)((double)i / (double)order.length * 100.0)));
                    }
                }
                catch (OutOfMemoryError e) {
                    throw new Exception("Unable to complete clustering of genes due to insufficient memory.", e);
                }
            }
            if (cluster && this.params.isTwoDistinctExpressionSets()) {
                cluster = false;
                this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            }
        }
        if (this.currentExpressionSet.keySet().size() == 1 || numdatacolumns + numdatacolumns2 <= 1 || !cluster) {
            this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            this.ranks = new Ranking();
            for (Integer key : this.currentExpressionSet.keySet()) {
                Rank temp = new Rank(this.currentExpressionSet.get(key).getName(), 0.0, 0);
                this.ranks.addRank(key, temp);
            }
        }
        this.heatmapPanel.setRanks(this.ranks);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setStatusMessage("Clustering the expression set");
        this.taskMonitor.setTitle("Clustering the expression set");
        this.calculateRanksByClustering();
    }

    public <R> R getResults(Class<? extends R> arg0) {
        return null;
    }
}

