/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CreateClustersTask
extends AbstractTask {
    private AnnotationSet annotationSet;
    private AutoAnnotationParameters params;
    private TaskMonitor taskMonitor;

    public CreateClustersTask(AnnotationSet annotationSet, AutoAnnotationParameters params) {
        this.annotationSet = annotationSet;
        this.params = params;
    }

    private void makeClusters() {
        List nodes = this.params.getNetwork().getNodeList();
        Class columnType = this.params.getNetwork().getDefaultNodeTable().getColumn(this.params.getClusterColumnName()).getType();
        for (CyNode node : nodes) {
            TreeMap<Integer, Cluster> clusterMap = this.annotationSet.getClusterMap();
            View nodeView = this.params.getNetworkView().getNodeView(node);
            double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double[] coordinates = new double[]{x, y};
            double nodeRadius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
            if (columnType == Integer.class) {
                Integer clusterNumber = (Integer)this.params.getNetwork().getRow((CyIdentifiable)node).get(this.params.getClusterColumnName(), Integer.class);
                if (clusterNumber == null) continue;
                this.addNodeToCluster(clusterNumber, node, coordinates, nodeRadius, clusterMap, this.annotationSet);
                continue;
            }
            if (columnType != List.class) continue;
            List clusterNumbers = new ArrayList();
            clusterNumbers = (List)this.params.getNetwork().getRow((CyIdentifiable)node).get(this.params.getClusterColumnName(), List.class);
            for (int i = 0; i < clusterNumbers.size(); ++i) {
                int clusterNumber = (Integer)clusterNumbers.get(i);
                this.addNodeToCluster(clusterNumber, node, coordinates, nodeRadius, clusterMap, this.annotationSet);
            }
        }
        this.annotationSet.setUseGroups(this.params.isGroups());
        for (Cluster cluster : this.annotationSet.getClusterMap().values()) {
            AutoAnnotationUtils.updateNodeCentralities(cluster);
        }
    }

    private void addNodeToCluster(Integer clusterNumber, CyNode node, double[] coordinates, double nodeRadius, TreeMap<Integer, Cluster> clusterMap, AnnotationSet annotationSet) {
        Cluster cluster;
        if (!clusterMap.keySet().contains(clusterNumber)) {
            cluster = new Cluster(clusterNumber, annotationSet);
            annotationSet.addCluster(cluster);
        } else {
            cluster = clusterMap.get(clusterNumber);
        }
        cluster.addNodeCoordinates(node, coordinates);
        cluster.addNodeRadius(node, nodeRadius);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setStatusMessage("creating clusters");
        this.makeClusters();
    }
}

