/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import java.util.ArrayList;

public class ObjectArrayList
extends AbstractList {
    protected Object[] elements;
    protected int size;

    public ObjectArrayList() {
        this(10);
    }

    public ObjectArrayList(Object[] objectArray) {
        this.elements(objectArray);
    }

    public ObjectArrayList(int n) {
        this(new Object[n]);
        this.size = 0;
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            System.arraycopy(this.elements, n, this.elements, n + n2, this.size - n);
            this.size += n2;
        }
    }

    public Object clone() {
        ObjectArrayList objectArrayList = (ObjectArrayList)super.clone();
        objectArrayList.elements = (Object[])this.elements.clone();
        return objectArrayList;
    }

    public Object[] elements() {
        return this.elements;
    }

    public ObjectArrayList elements(Object[] objectArray) {
        this.elements = objectArray;
        this.size = objectArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof ObjectArrayList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ObjectArrayList objectArrayList = (ObjectArrayList)object;
        if (this.elements == objectArrayList.elements()) {
            return true;
        }
        if (this.size != objectArrayList.size()) {
            return false;
        }
        Object[] objectArray = objectArrayList.elements();
        Object[] objectArray2 = this.elements;
        if (!bl) {
            int n = this.size;
            while (--n >= 0) {
                if (objectArray2[n] == objectArray[n]) continue;
                return false;
            }
        } else {
            int n = this.size;
            while (--n >= 0) {
                if (objectArray2[n] != null ? objectArray2[n].equals(objectArray[n]) : objectArray[n] == null) continue;
                return false;
            }
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, Object object) {
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, object);
        }
    }

    public int indexOf(Object object, boolean bl) {
        return this.indexOfFromTo(object, 0, this.size - 1, bl);
    }

    public int indexOfFromTo(Object object, int n, int n2, boolean bl) {
        if (this.size == 0) {
            return -1;
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = this.elements;
        if (bl && object != null) {
            for (int i = n; i <= n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                if (object != objectArray[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public ObjectArrayList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ObjectArrayList(0);
        }
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        Object[] objectArray = new Object[n2 - n + 1];
        System.arraycopy(this.elements, n, objectArray, 0, n2 - n + 1);
        return new ObjectArrayList(objectArray);
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        ObjectArrayList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 >= 0) {
            System.arraycopy(this.elements, n2 + 1, this.elements, n, n4);
            this.fillFromToWith(n + n4, this.size - 1, null);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.size -= n3;
        }
    }

    public void setQuick(int n, Object object) {
        this.elements[n] = object;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        Object[] objectArray = this.elements;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

