/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractBooleanList;

public class BooleanArrayList
extends AbstractBooleanList {
    protected boolean[] elements;

    public BooleanArrayList() {
        this(10);
    }

    public BooleanArrayList(boolean[] blArray) {
        this.elements(blArray);
    }

    public BooleanArrayList(int n) {
        this(new boolean[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        BooleanArrayList booleanArrayList = new BooleanArrayList((boolean[])this.elements.clone());
        booleanArrayList.setSizeRaw(this.size);
        return booleanArrayList;
    }

    public boolean[] elements() {
        return this.elements;
    }

    public AbstractBooleanList elements(boolean[] blArray) {
        this.elements = blArray;
        this.size = blArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)object;
        if (this.size() != booleanArrayList.size()) {
            return false;
        }
        boolean[] blArray = this.elements();
        boolean[] blArray2 = booleanArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (blArray[n] == blArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public boolean getQuick(int n) {
        return this.elements[n];
    }

    public AbstractBooleanList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new BooleanArrayList(0);
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        boolean[] blArray = new boolean[n2 - n + 1];
        System.arraycopy(this.elements, n, blArray, 0, n2 - n + 1);
        return new BooleanArrayList(blArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractBooleanList abstractBooleanList, int n3) {
        if (!(abstractBooleanList instanceof BooleanArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractBooleanList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            BooleanArrayList.checkRangeFromTo(n, n2, this.size());
            BooleanArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractBooleanList.size());
            System.arraycopy(((BooleanArrayList)abstractBooleanList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, boolean bl) {
        this.elements[n] = bl;
    }
}

