/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;

public abstract class AbstractDoubleList
extends AbstractList {
    protected int size;

    protected AbstractDoubleList() {
    }

    public void addAllOfFromTo(AbstractDoubleList abstractDoubleList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractDoubleList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractDoubleList abstractDoubleList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractDoubleList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public double[] elements() {
        double[] dArray = new double[this.size];
        int n = this.size;
        while (--n >= 0) {
            dArray[n] = this.getQuick(n);
        }
        return dArray;
    }

    public AbstractDoubleList elements(double[] dArray) {
        this.clear();
        this.addAllOfFromTo(new DoubleArrayList(dArray), 0, dArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractDoubleList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractDoubleList abstractDoubleList = (AbstractDoubleList)object;
        if (this.size() != abstractDoubleList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractDoubleList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public double get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract double getQuick(int var1);

    public AbstractDoubleList partFromTo(int n, int n2) {
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        DoubleArrayList doubleArrayList = new DoubleArrayList(n3);
        doubleArrayList.addAllOfFromTo(this, n, n2);
        return doubleArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractDoubleList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractDoubleList abstractDoubleList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractDoubleList.checkRangeFromTo(n, n2, this.size());
            AbstractDoubleList.checkRangeFromTo(n3, n3 + n4 - 1, abstractDoubleList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractDoubleList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractDoubleList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, double var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

