/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.SliderBarPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.property.CyProperty;
import org.cytoscape.session.CySessionManager;

public class EnrichmentMapParameters {
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private CyApplicationManager applicationManager;
    private String attributePrefix = null;
    private long networkID = 0L;
    private String GMTDirName = null;
    private String GCTDirName = null;
    private String GSEAResultsDirName = null;
    private int lowerlimit = 1;
    private int upperlimit = 1;
    private boolean BulkEM = false;
    private boolean sessions = true;
    private HashMap<String, DataSetFiles> files = new HashMap();
    private boolean Data = false;
    private boolean Data2 = false;
    private boolean twoDatasets = false;
    private boolean FDR = false;
    private boolean EMgmt = false;
    private boolean twoDistinctExpressionSets = false;
    private String method = "GSEA";
    private String similarityMetric;
    private String enrichment_edge_type;
    private double pvalue;
    private double pvalue_min = 1.0;
    private double qvalue;
    private double qvalue_min = 1.0;
    private double similarityCutOff;
    private double combinedConstant;
    private SliderBarPanel pvalueSlider;
    private SliderBarPanel qvalueSlider;
    private SliderBarPanel similaritySlider;
    private ArrayList<CyNode> selectedNodes;
    private ArrayList<CyEdge> selectedEdges;
    private HeatMapParameters hmParams;
    private Set<CyProperty<?>> cyto_prop;
    private double defaultJaccardCutOff;
    private double defaultOverlapCutOff;
    private String defaultSimilarityMetric;
    private Boolean disable_heatmap_autofocus;
    private String defaultSortMethod;
    private String defaultDistanceMetric;
    private String Great_Filter = "HYPER";
    HashMap<String, String> props;

    public EnrichmentMapParameters() {
        this.initializeDefaultParameters();
        if (this.defaultSimilarityMetric.equalsIgnoreCase("OVERLAP")) {
            this.similarityCutOff = this.defaultOverlapCutOff;
            this.similarityMetric = "OVERLAP";
        } else if (this.defaultSimilarityMetric.equalsIgnoreCase("JACCARD")) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = "JACCARD";
        } else if (this.defaultSimilarityMetric.equalsIgnoreCase("COMBINED")) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = "COMBINED";
        }
        this.enrichment_edge_type = "Geneset_Overlap";
        this.setFDR(false);
        this.setData(false);
        this.setData2(false);
        this.setTwoDatasets(false);
        this.setTwoDistinctExpressionSets(false);
        this.selectedNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        this.files.put("Dataset 1", new DataSetFiles());
    }

    public void initSliders() {
        this.pvalueSlider = new SliderBarPanel(this.pvalue_min == 1.0 || this.pvalue_min >= this.pvalue ? 0.0 : this.pvalue_min, this.pvalue, "P-value Cutoff", this, "pvalue_dataset1", "pvalue_dataset2", ParametersPanel.summaryPanelWidth, false, this.pvalue, this.applicationManager);
        this.qvalueSlider = new SliderBarPanel(this.qvalue_min == 1.0 || this.qvalue_min >= this.qvalue ? 0.0 : this.qvalue_min, this.qvalue, "Q-value Cutoff", this, "fdr_qvalue_dataset1", "fdr_qvalue_dataset2", ParametersPanel.summaryPanelWidth, false, this.qvalue, this.applicationManager);
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, "similarity_coefficient", "similarity_coefficient", ParametersPanel.summaryPanelWidth, true, this.similarityCutOff, this.applicationManager);
    }

    public EnrichmentMapParameters(CySessionManager sessionManager, StreamUtil streamUtil, CyApplicationManager applicationManager) {
        this();
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.applicationManager = applicationManager;
    }

    public void initializeDefaultParameters() {
        this.defaultJaccardCutOff = 0.25;
        this.defaultOverlapCutOff = 0.5;
        this.defaultSimilarityMetric = "OVERLAP";
        this.defaultSortMethod = HeatMapParameters.sort_hierarchical_cluster;
        this.defaultDistanceMetric = HeatMapParameters.pearson_correlation;
        this.pvalue = 0.005;
        this.qvalue = 0.1;
        this.combinedConstant = 0.5;
        this.disable_heatmap_autofocus = false;
        if (this.sessionManager != null) {
            this.cyto_prop = this.sessionManager.getCurrentSession().getProperties();
            for (CyProperty<?> prop : this.cyto_prop) {
                CyProperty<?> defaultOverlapCutOff_prop;
                if (prop.getName() == null) continue;
                if (prop.getName().equals("EnrichmentMap.default_jaccard")) {
                    CyProperty<?> defaultJaccardCutOff_prop = prop;
                    this.defaultJaccardCutOff = Double.valueOf(((Properties)defaultJaccardCutOff_prop.getProperties()).getProperty("EnrichmentMap.default_jaccard"));
                }
                if (prop.getName().equals("EnrichmentMap.default_overlap")) {
                    defaultOverlapCutOff_prop = prop;
                    this.defaultOverlapCutOff = Double.valueOf(((Properties)defaultOverlapCutOff_prop.getProperties()).getProperty("EnrichmentMap.default_overlap"));
                }
                if (prop.getName().equals("EnrichmentMap.default_overlap")) {
                    defaultOverlapCutOff_prop = prop;
                    this.defaultOverlapCutOff = Double.valueOf(((Properties)defaultOverlapCutOff_prop.getProperties()).getProperty("EnrichmentMap.default_overlap"));
                }
                if (prop.getName().equals("EnrichmentMap.default_pvalue")) {
                    CyProperty<?> defaultPvalue_prop = prop;
                    this.pvalue = Double.valueOf(((Properties)defaultPvalue_prop.getProperties()).getProperty("EnrichmentMap.default_pvalue"));
                }
                if (prop.getName().equals("EnrichmentMap.default_qvalue")) {
                    CyProperty<?> defaultQvalue_prop = prop;
                    this.qvalue = Double.valueOf(((Properties)defaultQvalue_prop.getProperties()).getProperty("EnrichmentMap.default_qvalue"));
                }
                if (prop.getName().equals("EnrichmentMap.default_combinedConstant")) {
                    CyProperty<?> defaultCombinedConstant_prop = prop;
                    this.combinedConstant = Double.valueOf(((Properties)defaultCombinedConstant_prop.getProperties()).getProperty("EnrichmentMap.default_combinedConstant"));
                }
                if (prop.getName().equals("EnrichmentMap.default_similarity_metric")) {
                    CyProperty<?> defaultSimilarityMetric_prop = prop;
                    this.defaultSimilarityMetric = ((Properties)defaultSimilarityMetric_prop.getProperties()).getProperty("EnrichmentMap.default_similarity_metric");
                }
                if (prop.getName().equals("EnrichmentMap.default_sort_method")) {
                    CyProperty<?> defaultSortMethod_prop = prop;
                    this.defaultSortMethod = ((Properties)defaultSortMethod_prop.getProperties()).getProperty("EnrichmentMap.default_sort_method");
                }
                if (prop.getName().equals("EnrichmentMap.default_distance_metric")) {
                    CyProperty<?> defaultDistanceMetric_prop = prop;
                    this.defaultDistanceMetric = ((Properties)defaultDistanceMetric_prop.getProperties()).getProperty("EnrichmentMap.default_distance_metric");
                }
                if (!prop.getName().equals("EnrichmentMap.disable_heatmap_autofocus")) continue;
                CyProperty<?> disable_heatmap_autofocus_prop = prop;
                this.disable_heatmap_autofocus = Boolean.valueOf(((Properties)disable_heatmap_autofocus_prop.getProperties()).getProperty("EnrichmentMap.disable_heatmap_autofocus"));
            }
        }
    }

    public EnrichmentMapParameters(String propFile, CySessionManager sessionManager, StreamUtil streamUtil, CyApplicationManager applicationManager) {
        this(sessionManager, streamUtil, applicationManager);
        this.props = new HashMap();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            this.props.put(tokens[0], tokens[1]);
        }
        this.attributePrefix = this.props.get("attributePrefix");
        this.enrichment_edge_type = this.props.containsKey("enrichment_edge_type") ? this.props.get("enrichment_edge_type") : "pp";
        if (this.props.get("twoDatasets").equalsIgnoreCase("true")) {
            this.twoDatasets = true;
        }
        if (this.props.get("jaccard").equalsIgnoreCase("false")) {
            this.similarityMetric = "JACCARD";
        } else if (this.props.get("jaccard").equalsIgnoreCase("true")) {
            this.similarityMetric = "OVERLAP";
        } else if (this.props.get("jaccard").equalsIgnoreCase("JACCARD")) {
            this.similarityMetric = "JACCARD";
        } else if (this.props.get("jaccard").equalsIgnoreCase("OVERLAP")) {
            this.similarityMetric = "OVERLAP";
        } else if (this.props.get("jaccard").equalsIgnoreCase("COMBINED")) {
            this.similarityMetric = "COMBINED";
        }
        if (this.props.get("CombinedConstant") != null) {
            this.setCombinedConstant(Double.parseDouble(this.props.get("CombinedConstant")));
        } else {
            this.setCombinedConstant(0.5);
        }
        if (this.props.get("GSEA") != null) {
            this.method = this.props.get("GSEA").equalsIgnoreCase("false") ? "generic" : "GSEA";
        }
        if (this.props.get("Data").equalsIgnoreCase("true")) {
            this.Data = true;
        }
        if (this.props.get("Data2").equalsIgnoreCase("true")) {
            this.Data2 = true;
        }
        if (this.props.get("FDR").equalsIgnoreCase("true")) {
            this.FDR = true;
        }
        if (this.props.get("method") != null) {
            this.method = this.props.get("method");
        }
        this.setPvalue(Double.parseDouble(this.props.get("pvalue")));
        this.setQvalue(Double.parseDouble(this.props.get("qvalue")));
        String cutoff = this.props.get("jaccardCutOff") != null ? this.props.get("jaccardCutOff") : this.props.get("similarityCutOff");
        if (cutoff != null) {
            this.similarityCutOff = Double.parseDouble(cutoff);
        }
        if (!this.props.containsKey("Version")) {
            this.reconstruct_ver1(this.props);
        } else if (Double.parseDouble(this.props.get("Version")) >= 2.0) {
            this.reconstruct_ver2(this.props);
        }
        this.pvalueSlider = new SliderBarPanel(this.pvalue_min == 1.0 ? 0.0 : this.pvalue_min, this.pvalue, "P-value Cutoff", this, "pvalue_dataset1", "pvalue_dataset2", ParametersPanel.summaryPanelWidth, false, this.pvalue, applicationManager);
        this.qvalueSlider = new SliderBarPanel(this.qvalue_min == 1.0 ? 0.0 : this.qvalue_min, this.qvalue, "Q-value Cutoff", this, "fdr_qvalue_dataset1", "fdr_qvalue_dataset2", ParametersPanel.summaryPanelWidth, false, this.qvalue, applicationManager);
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, "similarity_coefficient", "similarity_coefficient", ParametersPanel.summaryPanelWidth, true, this.similarityCutOff, applicationManager);
    }

    private void reconstruct_ver1(HashMap<String, String> props) {
        DataSetFiles files1 = new DataSetFiles();
        files1.setGMTFileName(this.checkForNull(props, "GMTFileName"));
        if (props.get("expressionFileName1") != null) {
            files1.setExpressionFileName(this.checkForNull(props, "expressionFileName1"));
        } else {
            files1.setExpressionFileName(this.checkForNull(props, "GCTFileName1"));
        }
        files1.setEnrichmentFileName1(this.checkForNull(props, "enerichmentDataset1FileName1"));
        files1.setEnrichmentFileName2(this.checkForNull(props, "enrichmentDataset1FileName2"));
        files1.setGseaHtmlReportFile(this.checkForNull(props, "gseaHtmlReportFileDataset1"));
        files1.setPhenotype1(this.checkForNull(props, "dataset1Phenotype1"));
        files1.setPhenotype2(this.checkForNull(props, "dataset1Phenotype2"));
        files1.setRankedFile(this.checkForNull(props, "rankFile1"));
        files1.setClassFile(this.checkForNull(props, "classFile1"));
        this.files.put("Dataset 1", files1);
        if (this.twoDatasets) {
            DataSetFiles files2 = new DataSetFiles();
            if (this.Data2) {
                if (props.get("expressionFileName2") != null) {
                    files2.setExpressionFileName(this.checkForNull(props, "expressionFileName2"));
                } else {
                    files2.setExpressionFileName(this.checkForNull(props, "GCTFileName2"));
                }
            }
            files2.setEnrichmentFileName1(this.checkForNull(props, "enerichmentDataset2FileName1"));
            files2.setEnrichmentFileName2(this.checkForNull(props, "enrichmentDataset2FileName2"));
            files2.setRankedFile(this.checkForNull(props, "rankFile2"));
            files2.setGseaHtmlReportFile(this.checkForNull(props, "gseaHtmlReportFileDataset2"));
            files2.setClassFile(this.checkForNull(props, "classFile2"));
            files2.setPhenotype1(this.checkForNull(props, "dataset2Phenotype1"));
            files2.setPhenotype2(this.checkForNull(props, "dataset2Phenotype2"));
            if (!this.files.containsKey("Dataset 2")) {
                this.files.put("Dataset 2", files2);
            }
        }
    }

    private String checkForNull(HashMap<String, String> props, String key) {
        if (props.get(key) != null) {
            if (props.get(key).equalsIgnoreCase("null")) {
                return null;
            }
            return props.get(key);
        }
        return null;
    }

    private void reconstruct_ver2(HashMap<String, String> props) {
        if (props.containsKey("Datasets")) {
            String list_ds = props.get("Datasets");
            String list_db_replaced = list_ds.replaceAll("\\[", "");
            list_db_replaced = list_db_replaced.replaceAll("\\]", "");
            String[] datasets = list_db_replaced.split(",");
            for (int i = 0; i < datasets.length; ++i) {
                String current_ds = datasets[i].trim();
                DataSetFiles new_dsf = new DataSetFiles();
                String temp = current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName";
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName")) {
                    new_dsf.setGMTFileName(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%expressionFileName")) {
                    new_dsf.setExpressionFileName(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%expressionFileName"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName1")) {
                    new_dsf.setEnrichmentFileName1(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName1"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName2")) {
                    new_dsf.setEnrichmentFileName2(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName2"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%gseaHtmlReportFileDataset")) {
                    new_dsf.setGseaHtmlReportFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%gseaHtmlReportFileDataset"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%classFile")) {
                    new_dsf.setClassFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%classFile"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%RankedFile")) {
                    new_dsf.setRankedFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%RankedFile"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%Phenotype1")) {
                    new_dsf.setPhenotype1(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%Phenotype1"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%Phenotype2")) {
                    new_dsf.setPhenotype2(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%Phenotype2"));
                }
                this.files.put(current_ds, new_dsf);
            }
        }
    }

    public void copy(EnrichmentMapParameters copy) {
        for (String ds : copy.getFiles().keySet()) {
            DataSetFiles new_ds = new DataSetFiles();
            new_ds.copy(copy.getFiles().get(ds));
            this.files.put(ds, new_ds);
        }
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = copy.getPvalueSlider();
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = copy.getQvalueSlider();
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.similaritySlider = copy.getSimilaritySlider();
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.method = copy.getMethod();
        this.FDR = copy.isFDR();
        this.similarityMetric = copy.getSimilarityMetric();
        this.combinedConstant = copy.getCombinedConstant();
        this.twoDistinctExpressionSets = copy.isTwoDistinctExpressionSets();
        this.selectedEdges = copy.getSelectedEdges();
        this.selectedNodes = copy.getSelectedNodes();
        this.hmParams = copy.getHmParams();
        this.enrichment_edge_type = copy.getEnrichment_edge_type();
        this.GMTDirName = copy.getGMTDirName();
        this.GCTDirName = copy.getGCTDirName();
        this.GSEAResultsDirName = copy.getGSEAResultsDirName();
        this.upperlimit = copy.getUpperlimit();
        this.lowerlimit = copy.getLowerlimit();
        this.EMgmt = copy.isEMgmt();
        this.attributePrefix = copy.getAttributePrefix();
    }

    protected static boolean checkFile(String filename) {
        File tempfile;
        return filename == null || (tempfile = new File(filename)).canRead();
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("enrichment_edge_type\t" + this.enrichment_edge_type + "\n");
        paramVariables.append("attributePrefix\t" + this.attributePrefix + "\n");
        paramVariables.append("method\t" + this.method + "\n");
        paramVariables.append("twoDatasets\t" + this.twoDatasets + "\n");
        paramVariables.append("jaccard\t" + this.similarityMetric + "\n");
        paramVariables.append("CombinedConstant" + this.combinedConstant + "\n");
        paramVariables.append("Data\t" + this.Data + "\n");
        paramVariables.append("Data2\t" + this.Data2 + "\n");
        paramVariables.append("FDR\t" + this.FDR + "\n");
        paramVariables.append("pvalue\t" + this.pvalue + "\n");
        paramVariables.append("qvalue\t" + this.qvalue + "\n");
        paramVariables.append("similarityCutOff\t" + this.similarityCutOff + "\n");
        for (String ds : this.files.keySet()) {
            paramVariables.append(this.files.get(ds).toString(ds));
        }
        return paramVariables.toString();
    }

    public String printHashmap(HashMap map) {
        StringBuffer result = new StringBuffer();
        if (map != null) {
            for (Object key : map.keySet()) {
                result.append(key.toString() + "\t" + map.get(key).toString() + "\n");
            }
            return result.toString();
        }
        return null;
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        String[] tokens;
        String line;
        int i;
        HashMap<Object, Object> newMap;
        boolean incrementRank = false;
        String[] lines = fileInput.split("\n");
        if (type == 1) {
            newMap = new HashMap<Object, Object>();
        } else if (type == 2) {
            newMap = new HashMap();
        } else if (type == 3) {
            newMap = new HashMap();
        } else if (type == 4) {
            newMap = new HashMap();
        } else if (type == 5) {
            newMap = new HashMap();
        } else if (type == 6) {
            newMap = new HashMap();
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                tokens = line.split("\t");
                if (Integer.parseInt(tokens[3]) >= 0) continue;
                incrementRank = true;
            }
        } else {
            newMap = type == 7 ? new HashMap() : new HashMap();
        }
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            if (type == 1 && tokens.length >= 3) {
                newMap.put(tokens[0], new GeneSet(tokens));
            }
            if (type == 2) {
                if (tokens.length > 1) {
                    newMap.put(tokens[0], Integer.parseInt(tokens[1]));
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 3) {
                newMap.put(tokens[0], new GSEAResult(tokens));
            }
            if (type == 4 && tokens.length > 3) {
                newMap.put(tokens[0], new GenericResult(tokens));
            }
            if (type == 5) {
                if (tokens.length > 1) {
                    newMap.put(Integer.parseInt(tokens[0]), tokens[1]);
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 6) {
                if (incrementRank) {
                    Integer newRank = Integer.parseInt(tokens[3]) + 1;
                    tokens[3] = newRank.toString();
                }
                newMap.put(Integer.parseInt(tokens[0]), new Rank(tokens));
            }
            if (type != 7) continue;
            newMap.put(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
        }
        return newMap;
    }

    public String getSimilarityMetric() {
        return this.similarityMetric;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix() {
        Set networks = this.sessionManager.getCurrentSession().getNetworks();
        if (networks == null || networks.isEmpty()) {
            this.attributePrefix = "EM1_";
        } else {
            int num_networks = 1;
            int max_prefix = 0;
            EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
            for (CyNetwork current_network : networks) {
                Long networkId = current_network.getSUID();
                if (!manager.isEnrichmentMap(networkId)) continue;
                ++num_networks;
                EnrichmentMap tmpMap = manager.getMap(networkId);
                String tmpPrefix = tmpMap.getParams().getAttributePrefix();
                tmpPrefix = tmpPrefix.replace("EM", "");
                int tmpNum = Integer.parseInt(tmpPrefix = tmpPrefix.replace("_", ""));
                if (tmpNum <= max_prefix) continue;
                max_prefix = tmpNum;
            }
            this.attributePrefix = "EM" + (max_prefix + 1) + "_";
        }
    }

    public void setSimilarityMetric(String similarityMetric) {
        this.similarityMetric = similarityMetric;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public double getPvalue_min() {
        return this.pvalue_min;
    }

    public void setPvalue_min(double pvalue_min) {
        this.pvalue_min = pvalue_min;
    }

    public double getQvalue_min() {
        return this.qvalue_min;
    }

    public void setQvalue_min(double qvalue_min) {
        this.qvalue_min = qvalue_min;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setQvalue(double qvalue) {
        this.qvalue = qvalue;
    }

    public double getSimilarityCutOff() {
        return this.similarityCutOff;
    }

    public void setSimilarityCutOff(double similarityCutOff) {
        this.similarityCutOff = similarityCutOff;
    }

    public String getGreat_Filter() {
        return this.Great_Filter;
    }

    public void setGreat_Filter(String great_Filter) {
        this.Great_Filter = great_Filter;
    }

    public boolean isTwoDatasets() {
        return this.twoDatasets;
    }

    public void setTwoDatasets(boolean twoDatasets) {
        this.twoDatasets = twoDatasets;
    }

    public boolean isData() {
        return this.Data;
    }

    public void setData(boolean data) {
        this.Data = data;
    }

    public boolean isData2() {
        return this.Data2;
    }

    public void setData2(boolean data2) {
        this.Data2 = data2;
    }

    public boolean isFDR() {
        return this.FDR;
    }

    public void setFDR(boolean FDR) {
        this.FDR = FDR;
    }

    public SliderBarPanel getPvalueSlider() {
        return this.pvalueSlider;
    }

    public SliderBarPanel getQvalueSlider() {
        return this.qvalueSlider;
    }

    public SliderBarPanel getSimilaritySlider() {
        return this.similaritySlider;
    }

    public ArrayList<CyNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public ArrayList<CyEdge> getSelectedEdges() {
        return this.selectedEdges;
    }

    public HeatMapParameters getHmParams() {
        return this.hmParams;
    }

    public void setHmParams(HeatMapParameters hmParams) {
        this.hmParams = hmParams;
    }

    public double getDefaultJaccardCutOff() {
        return this.defaultJaccardCutOff;
    }

    public double getDefaultOverlapCutOff() {
        return this.defaultOverlapCutOff;
    }

    public boolean isDisableHeatmapAutofocus() {
        return this.disable_heatmap_autofocus;
    }

    public void setDisableHeatmapAutofocus(boolean disable_heatmap_autofocus) {
        this.disable_heatmap_autofocus = disable_heatmap_autofocus;
    }

    public String getDefaultSortMethod() {
        return this.defaultSortMethod;
    }

    public void setDefaultSortMethod(String defaultSortMethod) {
        this.defaultSortMethod = defaultSortMethod;
    }

    public String getEnrichment_edge_type() {
        return this.enrichment_edge_type;
    }

    public String getDefaultDistanceMetric() {
        return this.defaultDistanceMetric;
    }

    public void setDefaultDistanceMetric(String defaultDistanceMetric) {
        this.defaultDistanceMetric = defaultDistanceMetric;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isTwoDistinctExpressionSets() {
        return this.twoDistinctExpressionSets;
    }

    public String getGMTDirName() {
        return this.GMTDirName;
    }

    public void setTwoDistinctExpressionSets(boolean twoDistinctExpressionSets) {
        this.twoDistinctExpressionSets = twoDistinctExpressionSets;
    }

    public void setGMTDirName(String GMTDirName) {
        this.GMTDirName = GMTDirName;
    }

    public String getGCTDirName() {
        return this.GCTDirName;
    }

    public void setGCTDirName(String GCTDirName) {
        this.GCTDirName = GCTDirName;
    }

    public int getLowerlimit() {
        return this.lowerlimit;
    }

    public void setLowerlimit(int lowerlimit) {
        this.lowerlimit = lowerlimit;
    }

    public int getUpperlimit() {
        return this.upperlimit;
    }

    public void setUpperlimit(int upperlimit) {
        this.upperlimit = upperlimit;
    }

    public String getGSEAResultsDirName() {
        return this.GSEAResultsDirName;
    }

    public void setGSEAResultsDirName(String GSEAResultsDirName) {
        this.GSEAResultsDirName = GSEAResultsDirName;
    }

    public double getCombinedConstant() {
        return this.combinedConstant;
    }

    public void setCombinedConstant(double combinedConstant) {
        this.combinedConstant = combinedConstant;
    }

    public boolean isEMgmt() {
        return this.EMgmt;
    }

    public void setEMgmt(boolean flag) {
        this.EMgmt = flag;
    }

    public HashMap<String, String> getProps() {
        return this.props;
    }

    public HashMap<String, DataSetFiles> getFiles() {
        return this.files;
    }

    public void addFiles(String name, DataSetFiles files) {
        this.files.put(name, files);
    }

    public void setSessions(boolean sessions) {
        this.sessions = sessions;
    }

    public long getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(long networkID) {
        this.networkID = networkID;
    }
}

