/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.util.SwingUtil;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisPanel
extends JPanel
implements CytoPanelComponent {
    private final CyApplicationManager cyApplicationManager;
    private final CySwingApplication application;
    private final OpenBrowser browser;
    private final FileUtil fileUtil;
    private final CyServiceRegistrar registrar;
    private final CySessionManager sessionManager;
    private final StreamUtil streamUtil;
    private final DialogTaskManager dialog;
    private final SynchronousTaskManager syncTaskManager;
    private final CyEventHelper eventHelper;
    private final EquationCompiler equationCompiler;
    private final VisualMappingManager visualMappingManager;
    private final VisualStyleFactory visualStyleFactory;
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;
    private WeakHashMap<EnrichmentMap, PostAnalysisInputPanel> panels = new WeakHashMap();
    private PostAnalysisInputPanel currentPanel;

    public PostAnalysisPanel(CyApplicationManager cyApplicationManager, CySwingApplication application, OpenBrowser browser, FileUtil fileUtil, CySessionManager sessionManager, StreamUtil streamUtil, CyServiceRegistrar registrar, DialogTaskManager dialog, SynchronousTaskManager syncTaskManager, CyEventHelper eventHelper, EquationCompiler equationCompiler, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.browser = browser;
        this.fileUtil = fileUtil;
        this.registrar = registrar;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.dialog = dialog;
        this.syncTaskManager = syncTaskManager;
        this.eventHelper = eventHelper;
        this.equationCompiler = equationCompiler;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.setLayout(new BorderLayout());
    }

    public void showPanelFor(EnrichmentMap currentMap) {
        PostAnalysisInputPanel panel;
        if (currentMap == null) {
            if (!this.currentPanel.isEnabled()) {
                return;
            }
            panel = this.newPostAnalysisInputPanel();
            SwingUtil.recursiveEnable(panel, false);
        } else {
            panel = this.panels.get(currentMap);
            if (panel == null) {
                panel = this.newPostAnalysisInputPanel();
                panel.initialize(currentMap);
                this.panels.put(currentMap, panel);
            }
        }
        this.removeAll();
        this.currentPanel = panel;
        this.add((Component)this.currentPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void removeEnrichmentMap(EnrichmentMap map) {
        this.panels.remove(map);
    }

    private PostAnalysisInputPanel newPostAnalysisInputPanel() {
        return new PostAnalysisInputPanel(this.cyApplicationManager, this.application, this.browser, this.fileUtil, this.sessionManager, this.streamUtil, this.registrar, this.dialog, this.syncTaskManager, this.eventHelper, this.equationCompiler, this.visualMappingManager, this.visualStyleFactory, this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough);
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Post Analysis Input Panel";
    }
}

