/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateEnrichmentMapNetworkTask;
import org.baderlab.csplugins.enrichmentmap.task.Hypergeometric;
import org.baderlab.csplugins.enrichmentmap.util.NetworkUtil;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class BuildDiseaseSignatureTask
extends AbstractTask
implements ObservableTask {
    private final CyApplicationManager applicationManager;
    private final CyEventHelper eventHelper;
    private final PostAnalysisParameters paParams;
    private final EnrichmentMap map;
    private final String interaction;
    private Map<String, GeneSet> EnrichmentGenesets;
    private Map<String, GeneSet> SignatureGenesets;
    private Map<String, GeneSet> SelectedSignatureGenesets;
    private Set<Integer> EnrichmentGenes;
    private Set<Integer> SignatureGenes;
    private Ranking ranks;
    private Map<String, GenesetSimilarity> geneset_similarities;
    private BuildDiseaseSignatureTaskResult.Builder taskResult = new BuildDiseaseSignatureTaskResult.Builder();

    public BuildDiseaseSignatureTask(EnrichmentMap map, PostAnalysisParameters paParams, CySessionManager manager, StreamUtil streamUtil, CyApplicationManager applicationManager, CyEventHelper eventHelper, CySwingApplication swingApplication) {
        this.map = map;
        this.applicationManager = applicationManager;
        this.eventHelper = eventHelper;
        HashMap<String, DataSet> data_sets = this.map.getDatasets();
        DataSet dataset = data_sets.get(paParams.getSignature_dataSet());
        this.ranks = new Ranking();
        if (dataset != null) {
            this.ranks = dataset.getExpressionSets().getRanks().get(paParams.getSignature_rankFile());
        }
        this.paParams = new PostAnalysisParameters(paParams);
        this.EnrichmentGenesets = map.getEnrichmentGenesets();
        this.SignatureGenesets = this.paParams.getSignatureGenesets().getGenesets();
        this.geneset_similarities = map.getGenesetSimilarity() == null ? new HashMap<String, GenesetSimilarity>() : map.getGenesetSimilarity();
        this.SelectedSignatureGenesets = new HashMap<String, GeneSet>();
        for (int i = 0; i < paParams.getSelectedSignatureSetNames().getSize(); ++i) {
            String geneset = paParams.getSelectedSignatureSetNames().get(i);
            this.SelectedSignatureGenesets.put(geneset.toString(), this.SignatureGenesets.get(geneset));
        }
        this.EnrichmentGenes = new HashSet<Integer>();
        for (GeneSet geneSet : this.EnrichmentGenesets.values()) {
            this.EnrichmentGenes.addAll(geneSet.getGenes());
        }
        this.SignatureGenes = new HashSet<Integer>();
        for (GeneSet geneSet : this.SignatureGenesets.values()) {
            this.SignatureGenes.addAll(geneSet.getGenes());
        }
        this.interaction = this.getInteraction();
    }

    private String getInteraction() {
        if (this.map.getParams().isTwoDatasets()) {
            if ("Dataset 1".equals(this.paParams.getSignature_dataSet())) {
                return "sig_set1";
            }
            if ("Dataset 2".equals(this.paParams.getSignature_dataSet())) {
                return "sig_set2";
            }
        }
        return "sig";
    }

    public void buildDiseaseSignature(TaskMonitor taskMonitor) {
        int maxValue = this.SelectedSignatureGenesets.size() * this.EnrichmentGenesets.size();
        int currentProgress = 0;
        double currentNodeY_offset = this.paParams.getCurrentNodePlacementY_Offset();
        double currentNodeY_increment = 150.0;
        try {
            CyNetwork current_network = this.applicationManager.getCurrentNetwork();
            CyNetworkView current_view = this.applicationManager.getCurrentNetworkView();
            this.taskResult.setNetwork(current_network);
            this.taskResult.setNetworkView(current_view);
            String prefix = this.paParams.getAttributePrefix();
            if (prefix == null) {
                prefix = "EM1_";
                this.paParams.setAttributePrefix(prefix);
            }
            CyTable cyEdgeAttrs = this.createEdgeAttributes(current_network, "", prefix);
            CyTable cyNodeAttrs = this.createNodeAttributes(current_network, "", prefix);
            Map<String, CyNode> nodesMap = this.createNodeMap(current_network, cyNodeAttrs, prefix);
            HashSet<Integer> geneUniverse = new HashSet<Integer>();
            geneUniverse.addAll(this.EnrichmentGenes);
            HashMap<String, String> duplicateGenesets = new HashMap<String, String>();
            for (String hub_name : this.SelectedSignatureGenesets.keySet()) {
                GeneSet sigGeneSet = this.SelectedSignatureGenesets.get(hub_name);
                if (this.EnrichmentGenesets.containsKey(hub_name)) {
                    duplicateGenesets.put(hub_name, "PA_" + hub_name);
                    hub_name = "PA_" + hub_name;
                }
                HashSet<Integer> sigGenes = sigGeneSet.getGenes();
                HashSet<Integer> sigGenesInUniverse = new HashSet<Integer>(sigGenes);
                sigGenesInUniverse.retainAll(geneUniverse);
                EnrichmentMapManager.getInstance().getMap(current_network.getSUID()).getSignatureGenesets().put(hub_name, sigGeneSet);
                for (String geneset_name : this.EnrichmentGenesets.keySet()) {
                    int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                    if (taskMonitor != null) {
                        taskMonitor.setProgress((double)percentComplete);
                        taskMonitor.setStatusMessage("Computing Geneset similarity " + currentProgress + " of " + maxValue);
                        taskMonitor.setTitle("Post Analysis");
                    }
                    ++currentProgress;
                    if (this.cancelled) {
                        throw new InterruptedException();
                    }
                    String similarity_key1 = hub_name + " (" + this.interaction + ") " + geneset_name;
                    if (hub_name.equalsIgnoreCase(geneset_name) || !nodesMap.containsKey(geneset_name) || ((String)cyNodeAttrs.getRow((Object)nodesMap.get(geneset_name).getSUID()).get(prefix + "GS_Type", String.class)).equalsIgnoreCase("SIG")) continue;
                    GeneSet enrGeneset = this.EnrichmentGenesets.get(geneset_name);
                    HashSet<Integer> enrGenes = enrGeneset.getGenes();
                    enrGenes.retainAll(geneUniverse);
                    HashSet<Integer> union = new HashSet<Integer>(sigGenes);
                    union.addAll(enrGenes);
                    HashSet<Integer> intersection = new HashSet<Integer>(sigGenesInUniverse);
                    intersection.retainAll(enrGenes);
                    if (intersection.size() <= 0) continue;
                    double coeffecient = ComputeSimilarityTask.computeSimilarityCoeffecient(this.map.getParams(), intersection, union, sigGenes, enrGenes);
                    GenesetSimilarity comparison = new GenesetSimilarity(hub_name, geneset_name, coeffecient, this.interaction, intersection);
                    switch (this.paParams.getRankTestParameters().getType()) {
                        case HYPERGEOM: {
                            int universeSize1 = this.paParams.getUniverseSize();
                            this.hypergeometric(universeSize1, sigGenesInUniverse, enrGenes, intersection, comparison);
                            break;
                        }
                        case MANN_WHIT: {
                            this.mannWhitney(intersection, comparison);
                        }
                        default: {
                            int universeSize2 = this.map.getNumberOfGenes();
                            this.hypergeometric(universeSize2, sigGenesInUniverse, enrGenes, intersection, comparison);
                        }
                    }
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
                boolean created = this.createHubNode(hub_name, current_network, current_view, currentNodeY_offset, prefix, cyEdgeAttrs, cyNodeAttrs, geneUniverse, sigGeneSet);
                if (!created) continue;
                currentNodeY_offset += currentNodeY_increment;
            }
            for (String original_hub_name : duplicateGenesets.keySet()) {
                GeneSet geneset = this.SelectedSignatureGenesets.remove(original_hub_name);
                this.SelectedSignatureGenesets.put((String)duplicateGenesets.get(original_hub_name), geneset);
            }
            duplicateGenesets.clear();
            this.paParams.setCurrentNodePlacementY_Offset(currentNodeY_offset);
            for (String edge_name : this.geneset_similarities.keySet()) {
                if (this.cancelled) {
                    throw new InterruptedException();
                }
                if (!this.geneset_similarities.get(edge_name).getInteractionType().equals(this.interaction) || !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset1_Name()) && !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset2_Name())) continue;
                boolean passed_cutoff = this.passesCutoff(edge_name);
                this.createEdge(edge_name, current_network, current_view, prefix, cyEdgeAttrs, cyNodeAttrs, passed_cutoff);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean passesCutoff(String edge_name) {
        GenesetSimilarity similarity = this.geneset_similarities.get(edge_name);
        FilterParameters filterParams = this.paParams.getRankTestParameters();
        switch (filterParams.getType()) {
            case HYPERGEOM: {
                return similarity.getHypergeom_pvalue() <= filterParams.getValue(FilterParameters.FilterType.HYPERGEOM);
            }
            case MANN_WHIT: {
                return !similarity.isMannWhitMissingRanks() && similarity.getMann_Whit_pValue() <= filterParams.getValue(FilterParameters.FilterType.MANN_WHIT);
            }
            case NUMBER: {
                return (double)similarity.getSizeOfOverlap() >= filterParams.getValue(FilterParameters.FilterType.NUMBER);
            }
            case PERCENT: {
                String geneset_name = similarity.getGeneset2_Name();
                GeneSet enrGeneset = this.EnrichmentGenesets.get(geneset_name);
                int enrGenesetSize = enrGeneset.getGenes().size();
                double relative_per = (double)similarity.getSizeOfOverlap() / (double)enrGenesetSize;
                return relative_per >= filterParams.getValue(FilterParameters.FilterType.PERCENT) / 100.0;
            }
            case SPECIFIC: {
                String hub_name = similarity.getGeneset1_Name();
                GeneSet sigGeneSet = this.SelectedSignatureGenesets.get(hub_name);
                int sigGeneSetSize = sigGeneSet.getGenes().size();
                double relative_per2 = (double)similarity.getSizeOfOverlap() / (double)sigGeneSetSize;
                return relative_per2 >= filterParams.getValue(FilterParameters.FilterType.SPECIFIC) / 100.0;
            }
        }
        return false;
    }

    private boolean createHubNode(String hub_name, CyNetwork current_network, CyNetworkView current_view, double currentNodeY_offset, String prefix, CyTable cyEdgeAttrs, CyTable cyNodeAttrs, Set<Integer> geneUniverse, GeneSet sigGeneSet) {
        boolean created = false;
        CyNode hub_node = NetworkUtil.getNodeWithValue(current_network, cyNodeAttrs, "name", hub_name);
        if (hub_node == null) {
            hub_node = current_network.addNode();
            this.taskResult.addNewNode(hub_node);
            created = true;
        }
        current_network.getRow((CyIdentifiable)hub_node).set("name", (Object)hub_name);
        this.eventHelper.flushPayloadEvents();
        View hubNodeView = current_view.getNodeView(hub_node);
        double hubNodeY = (Double)hubNodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        if (created) {
            hubNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)(hubNodeY + currentNodeY_offset));
        }
        String formatted_label = CreateEnrichmentMapNetworkTask.formatLabel(hub_name);
        CyRow current_row = cyNodeAttrs.getRow((Object)hub_node.getSUID());
        current_row.set(prefix + "Formatted_name", (Object)formatted_label);
        if (this.map.getHashkey2gene() != null) {
            ArrayList<String> gene_list = new ArrayList<String>();
            for (Integer current : sigGeneSet.getGenes()) {
                String gene = this.map.getGeneFromHashKey(current);
                if (gene_list == null || gene == null) continue;
                gene_list.add(gene);
            }
            Collections.sort(gene_list);
            ArrayList<String> enr_gene_list = new ArrayList<String>();
            HashSet<Integer> enr_genes_hash = sigGeneSet.getGenes();
            enr_genes_hash.retainAll(geneUniverse);
            for (Integer current : enr_genes_hash) {
                String gene = this.map.getGeneFromHashKey(current);
                if (enr_gene_list == null || gene == null) continue;
                enr_gene_list.add(gene);
            }
            Collections.sort(enr_gene_list);
            current_row.set(prefix + "Genes", gene_list);
            current_row.set(prefix + "Enrichment_Genes", enr_gene_list);
            current_row.set(prefix + "GS_DESCR", (Object)sigGeneSet.getDescription());
            current_row.set(prefix + "GS_Type", (Object)"SIG");
            current_row.set(prefix + "Name", (Object)sigGeneSet.getName());
            current_row.set(prefix + "gs_size_signature", (Object)sigGeneSet.getGenes().size());
        }
        sigGeneSet.getGenes().retainAll(this.map.getDataset("Dataset 1").getDatasetGenes());
        this.map.getDataset("Dataset 1").getGenesetsOfInterest().getGenesets().put(hub_name, sigGeneSet);
        return created;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createEdge(String edge_name, CyNetwork current_network, CyNetworkView current_view, String prefix, CyTable cyEdgeAttrs, CyTable cyNodeAttrs, boolean passed_cutoff) {
        CyEdge edge = NetworkUtil.getEdgeWithValue(current_network, cyEdgeAttrs, "name", edge_name);
        GenesetSimilarity genesetSimilarity = this.geneset_similarities.get(edge_name);
        if (edge == null) {
            if (!passed_cutoff) return;
            CyNode hub_node = NetworkUtil.getNodeWithValue(current_network, cyNodeAttrs, "name", genesetSimilarity.getGeneset1_Name());
            CyNode gene_set = NetworkUtil.getNodeWithValue(current_network, cyNodeAttrs, "name", genesetSimilarity.getGeneset2_Name());
            if (hub_node == null || gene_set == null) {
                return;
            }
            edge = current_network.addEdge(hub_node, gene_set, false);
            this.taskResult.addNewEdge(edge);
        } else if (!passed_cutoff) {
            this.taskResult.addExistingEdgeFailsCutoff(edge);
        }
        if (passed_cutoff) {
            this.taskResult.incrementPassedCutoffCount();
        }
        CyRow current_edgerow = cyEdgeAttrs.getRow((Object)edge.getSUID());
        current_edgerow.set("name", (Object)edge_name);
        current_edgerow.set("interaction", (Object)this.interaction);
        if (this.map.getHashkey2gene() != null) {
            ArrayList<String> gene_list = new ArrayList<String>();
            Set<Integer> genes_hash = genesetSimilarity.getOverlapping_genes();
            for (Integer current : genes_hash) {
                String gene = this.map.getGeneFromHashKey(current);
                if (gene == null) continue;
                gene_list.add(gene);
            }
            Collections.sort(gene_list);
            current_edgerow.set(prefix + "Overlap_genes", gene_list);
        }
        current_edgerow.set(prefix + "Overlap_size", (Object)genesetSimilarity.getSizeOfOverlap());
        current_edgerow.set(prefix + "similarity_coefficient", (Object)genesetSimilarity.getSimilarity_coeffecient());
        current_edgerow.set(prefix + "Overlap_Hypergeom_pVal", (Object)genesetSimilarity.getHypergeom_pvalue());
        current_edgerow.set(prefix + "ENRICHMENT_SET", (Object)4);
        if (passed_cutoff) {
            current_edgerow.set(prefix + "Overlap_cutoff", (Object)this.paParams.getRankTestParameters().getType().display);
        }
        switch (this.paParams.getRankTestParameters().getType()) {
            case MANN_WHIT: {
                current_edgerow.set(prefix + "Overlap_Mann_Whit_pVal", (Object)genesetSimilarity.getMann_Whit_pValue());
                current_edgerow.set(prefix + "Overlap_Mann_Whit_cutoff", (Object)this.paParams.getRankTestParameters().getValue(FilterParameters.FilterType.MANN_WHIT));
            }
        }
        current_edgerow.set(prefix + "Overlap_Hypergeom_pVal", (Object)genesetSimilarity.getHypergeom_pvalue());
        current_edgerow.set(prefix + "HyperGeom_N_Universe", (Object)genesetSimilarity.getHypergeom_N());
        current_edgerow.set(prefix + "HyperGeom_n_Sig_Universe", (Object)genesetSimilarity.getHypergeom_n());
        current_edgerow.set(prefix + "m_Enr_Genes", (Object)genesetSimilarity.getHypergeom_m());
        current_edgerow.set(prefix + "k_Intersection", (Object)genesetSimilarity.getHypergeom_k());
        current_edgerow.set(prefix + "Overlap_Hypergeom_cutoff", (Object)this.paParams.getRankTestParameters().getValue(FilterParameters.FilterType.HYPERGEOM));
    }

    private void hypergeometric(int universeSize, Set<Integer> sigGenesInUniverse, Set<Integer> enrGenes, Set<Integer> intersection, GenesetSimilarity comparison) {
        int N = universeSize;
        int n = sigGenesInUniverse.size();
        int m = enrGenes.size();
        int k = intersection.size();
        double hyperPval = k > 0 ? Hypergeometric.hyperGeomPvalue_sum(N, n, m, k, 0) : 1.0;
        comparison.setHypergeom_pvalue(hyperPval);
        comparison.setHypergeom_N(N);
        comparison.setHypergeom_n(n);
        comparison.setHypergeom_m(m);
        comparison.setHypergeom_k(k);
    }

    private void mannWhitney(Set<Integer> intersection, GenesetSimilarity comparison) {
        Map<Integer, Double> gene2score = this.ranks.getGene2Score();
        if (gene2score == null || gene2score.isEmpty()) {
            comparison.setMann_Whit_pValue(1.5);
            comparison.setMannWhitMissingRanks(true);
        } else {
            Integer[] overlap_gene_ids = intersection.toArray(new Integer[intersection.size()]);
            double[] overlap_gene_scores = new double[overlap_gene_ids.length];
            int j = 0;
            for (Integer gene_id : overlap_gene_ids) {
                Double score = gene2score.get(gene_id);
                if (score == null) continue;
                overlap_gene_scores[j++] = score;
            }
            overlap_gene_scores = Arrays.copyOf(overlap_gene_scores, j);
            double[] scores = this.ranks.getScores();
            if (scores.length == 0 || overlap_gene_scores.length == 0) {
                comparison.setMann_Whit_pValue(1.5);
                comparison.setMannWhitMissingRanks(true);
            } else {
                MannWhitneyUTest mann_whit = new MannWhitneyUTest();
                double mannPval = mann_whit.mannWhitneyUTest(overlap_gene_scores, scores);
                comparison.setMann_Whit_pValue(mannPval);
            }
        }
    }

    private Map<String, CyNode> createNodeMap(CyNetwork current_network, CyTable cyNodeAttrs, String prefix) {
        HashMap<String, CyNode> nodesMap = new HashMap<String, CyNode>();
        for (CyNode aNode : current_network.getNodeList()) {
            nodesMap.put((String)cyNodeAttrs.getRow((Object)aNode.getSUID()).get(prefix + "Name", String.class), aNode);
        }
        return nodesMap;
    }

    private CyTable createNodeAttributes(CyNetwork network, String name, String prefix) {
        CyTable nodeTable = network.getDefaultNodeTable();
        if (nodeTable.getColumn(prefix + "Enrichment_Genes") == null) {
            nodeTable.createListColumn(prefix + "Enrichment_Genes", String.class, false);
        }
        if (nodeTable.getColumn(prefix + "gs_size_signature") == null) {
            nodeTable.createColumn(prefix + "gs_size_signature", Integer.class, false);
        }
        return nodeTable;
    }

    private CyTable createEdgeAttributes(CyNetwork network, String name, String prefix) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        if (edgeTable.getColumn(prefix + "Overlap_Hypergeom_pVal") == null) {
            edgeTable.createColumn(prefix + "Overlap_Hypergeom_pVal", Double.class, false);
        }
        if (edgeTable.getColumn(prefix + "HyperGeom_N_Universe") == null) {
            edgeTable.createColumn(prefix + "HyperGeom_N_Universe", Integer.class, false);
        }
        if (edgeTable.getColumn(prefix + "HyperGeom_n_Sig_Universe") == null) {
            edgeTable.createColumn(prefix + "HyperGeom_n_Sig_Universe", Integer.class, false);
        }
        if (edgeTable.getColumn(prefix + "m_Enr_Genes") == null) {
            edgeTable.createColumn(prefix + "m_Enr_Genes", Integer.class, false);
        }
        if (edgeTable.getColumn(prefix + "k_Intersection") == null) {
            edgeTable.createColumn(prefix + "k_Intersection", Integer.class, false);
        }
        if (edgeTable.getColumn(prefix + "Overlap_Hypergeom_cutoff") == null) {
            edgeTable.createColumn(prefix + "Overlap_Hypergeom_cutoff", Double.class, false);
        }
        if (edgeTable.getColumn(prefix + "Overlap_Mann_Whit_pVal") == null) {
            edgeTable.createColumn(prefix + "Overlap_Mann_Whit_pVal", Double.class, false);
        }
        if (edgeTable.getColumn(prefix + "Overlap_Mann_Whit_cutoff") == null) {
            edgeTable.createColumn(prefix + "Overlap_Mann_Whit_cutoff", Double.class, false);
        }
        if (edgeTable.getColumn(prefix + "Overlap_cutoff") == null) {
            edgeTable.createColumn(prefix + "Overlap_cutoff", String.class, false);
        }
        return edgeTable;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Generating Signature Hubs");
        this.buildDiseaseSignature(taskMonitor);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (BuildDiseaseSignatureTaskResult.class.equals(type)) {
            this.taskResult.setCancelled(this.cancelled);
            return type.cast(this.taskResult.build());
        }
        return null;
    }
}

