/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap.task;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class UpdateHeatMapTask
extends AbstractTask {
    private HeatMapParameters hmParams;
    private CyApplicationManager applicationManager;
    private EnrichmentMap map;
    private List<CyNode> Nodes;
    private List<CyEdge> Edges;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private final CytoPanel cytoPanelSouth;
    private static final ThreadLocal<Boolean> isCurrentlyFocusing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public UpdateHeatMapTask(EnrichmentMap map, List<CyNode> nodes, List<CyEdge> edges, HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel, CytoPanel cytoPanelSouth, CyApplicationManager applicationManager) {
        this.map = map;
        this.hmParams = map.getParams().getHmParams();
        this.Nodes = nodes;
        this.Edges = edges;
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.cytoPanelSouth = cytoPanelSouth;
        this.applicationManager = applicationManager;
    }

    public void createEdgesData() {
        if (this.map.getParams().isData()) {
            this.setEdgeExpressionSet();
            this.edgeOverlapPanel.updatePanel(this.map);
            this.focusPanel(this.edgeOverlapPanel);
            this.edgeOverlapPanel.revalidate();
        }
    }

    private void createNodesData() {
        if (this.map.getParams().isData()) {
            this.setNodeExpressionSet();
            this.nodeOverlapPanel.updatePanel(this.map);
            this.focusPanel(this.nodeOverlapPanel);
            this.nodeOverlapPanel.revalidate();
        }
    }

    public void clearPanels() {
        if (this.map.getParams().isData()) {
            this.nodeOverlapPanel.clearPanel();
            this.edgeOverlapPanel.clearPanel();
            this.focusPanel(this.nodeOverlapPanel);
            this.focusPanel(this.edgeOverlapPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focusPanel(HeatMapPanel panel) {
        if (!this.map.getParams().isDisableHeatmapAutofocus() && !isCurrentlyFocusing.get().booleanValue()) {
            isCurrentlyFocusing.set(true);
            try {
                int index;
                if (this.cytoPanelSouth.getState() == CytoPanelState.HIDE) {
                    this.cytoPanelSouth.setState(CytoPanelState.DOCK);
                }
                if ((index = this.cytoPanelSouth.indexOfComponent((Component)panel)) != -1) {
                    this.cytoPanelSouth.setSelectedIndex(index);
                }
            }
            finally {
                isCurrentlyFocusing.set(false);
            }
        }
    }

    private void setNodeExpressionSet() {
        Object[] nodes = this.map.getParams().getSelectedNodes().toArray();
        HashMap<String, GeneSet> genesets = this.map.getAllGenesetsOfInterest();
        HashMap<String, GeneSet> genesets_set1 = this.map.getDatasets().containsKey("Dataset 1") ? this.map.getDataset("Dataset 1").getSetofgenesets().getGenesets() : null;
        HashMap<String, GeneSet> genesets_set2 = this.map.getDatasets().containsKey("Dataset 2") ? this.map.getDataset("Dataset 2").getSetofgenesets().getGenesets() : null;
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (nodes.length > 0) {
            HashSet<Integer> union = new HashSet<Integer>();
            for (Object node1 : nodes) {
                CyNode current_node = (CyNode)node1;
                String nodename = (String)network.getRow((CyIdentifiable)current_node).get("name", String.class);
                GeneSet current_geneset = genesets.get(nodename);
                HashSet<Integer> additional_set = null;
                if (this.map.getParams().isTwoDistinctExpressionSets()) {
                    GeneSet current_geneset_set1 = genesets_set1.get(nodename);
                    GeneSet current_geneset_set2 = genesets_set2.get(nodename);
                    if (current_geneset_set1 != null && current_geneset.equals(current_geneset_set1) && current_geneset_set2 != null) {
                        additional_set = current_geneset_set2.getGenes();
                    }
                    if (current_geneset_set2 != null && current_geneset.equals(current_geneset_set2) && current_geneset_set1 != null) {
                        additional_set = current_geneset_set1.getGenes();
                    }
                }
                if (current_geneset == null) continue;
                HashSet<Integer> current_set = current_geneset.getGenes();
                if (union == null) {
                    union = new HashSet<Integer>(current_set);
                } else {
                    union.addAll(current_set);
                }
                if (additional_set == null) continue;
                union.addAll(additional_set);
            }
            HashSet<Integer> genes = union;
            this.nodeOverlapPanel.setCurrentExpressionSet(this.map.getDataset("Dataset 1").getExpressionSets().getExpressionMatrix(genes));
            if (this.map.getParams().isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null) {
                this.nodeOverlapPanel.setCurrentExpressionSet2(this.map.getDataset("Dataset 2").getExpressionSets().getExpressionMatrix(genes));
            }
        } else {
            this.nodeOverlapPanel.setCurrentExpressionSet(null);
            this.nodeOverlapPanel.setCurrentExpressionSet2(null);
        }
    }

    private void setEdgeExpressionSet() {
        Object[] edges = this.map.getParams().getSelectedEdges().toArray();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (edges.length > 0) {
            HashSet<Integer> intersect = null;
            for (int i = 0; i < edges.length; ++i) {
                CyEdge current_edge = (CyEdge)edges[i];
                String edgename = (String)network.getRow((CyIdentifiable)current_edge).get("name", String.class);
                GenesetSimilarity similarity = this.map.getGenesetSimilarity().get(edgename);
                if (similarity == null) continue;
                Set<Integer> current_set = similarity.getOverlapping_genes();
                if (intersect == null) {
                    intersect = new HashSet<Integer>(current_set);
                } else {
                    intersect.retainAll(current_set);
                }
                if (intersect.size() < 1) break;
            }
            this.edgeOverlapPanel.setCurrentExpressionSet(this.map.getDataset("Dataset 1").getExpressionSets().getExpressionMatrix(intersect));
            if (this.map.getParams().isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null) {
                this.edgeOverlapPanel.setCurrentExpressionSet2(this.map.getDataset("Dataset 2").getExpressionSets().getExpressionMatrix(intersect));
            }
        } else {
            this.edgeOverlapPanel.setCurrentExpressionSet(null);
            this.edgeOverlapPanel.setCurrentExpressionSet2(null);
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.Edges.size() > 0) {
            this.createEdgesData();
        }
        if (this.Nodes.size() > 0) {
            this.createNodesData();
        }
        if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
            this.clearPanels();
        }
    }
}

