/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class HeatMapParameters {
    private ColorGradientRange range;
    private ColorGradientTheme theme;
    Sort sort;
    public Transformation transformation;
    private String sortbycolumnName;
    private boolean sortbycolumn_event_triggered = false;
    private int sortIndex = -1;
    private String rankFileIndex = "none";
    private boolean[] ascending;
    private boolean showValues = false;
    private double minExpression;
    private double maxExpression;
    private double closestToZeroExpression;
    private double minExpression_rownorm;
    private double maxExpression_rownorm;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    public static String sort_hierarchical_cluster = "Hierarchical Cluster";
    public static String sort_rank = "Ranks";
    public static String sort_column = "Columns";
    public static String sort_none = "No Sort";
    public static String pearson_correlation = "Pearson Correlation";
    public static String cosine = "Cosine Distance";
    public static String euclidean = "Euclidean Distance";
    public static String asis = "Data As Is";
    public static String rownorm = "Row Normalize Data";
    public static String logtrans = "Log Transform Data";

    public HeatMapParameters(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.sort = Sort.DEFAULT;
        this.transformation = Transformation.ASIS;
    }

    public void initColorGradients(GeneExpressionMatrix expression) {
        this.minExpression = expression.getMinExpression();
        this.maxExpression = expression.getMaxExpression();
        this.closestToZeroExpression = expression.getClosesttoZero();
        this.minExpression_rownorm = expression.getMinExpression(expression.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm = expression.getMaxExpression(expression.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        double median = 0.0;
        if (this.minExpression >= 0.0) {
            this.range = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient() {
        double max;
        double min;
        switch (this.transformation) {
            case ROWNORM: {
                min = this.minExpression_rownorm;
                max = this.maxExpression_rownorm;
                if (min != 0.0 || max == 0.0) {
                    // empty if block
                }
                max = Math.max(Math.abs(min), max);
                break;
            }
            case LOGTRANSFORM: {
                if (this.minExpression <= 0.0 && this.maxExpression <= 0.0) {
                    min = 0.0;
                    max = 0.0;
                    break;
                }
                if (this.minExpression <= 0.0) {
                    min = Math.min(Math.log(this.closestToZeroExpression), Math.log1p(this.maxExpression));
                    max = Math.max(Math.log(this.closestToZeroExpression), Math.log1p(this.maxExpression));
                    break;
                }
                if (this.maxExpression <= 0.0) {
                    min = 0.0;
                    max = Math.log1p(this.minExpression);
                    break;
                }
                min = Math.log1p(this.minExpression);
                max = Math.log1p(this.maxExpression);
                max = Math.max(Math.abs(min), max);
                break;
            }
            default: {
                min = this.minExpression;
                max = Math.max(Math.abs(this.minExpression), this.maxExpression);
            }
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public HeatMapPanel getEdgeOverlapPanel() {
        return this.edgeOverlapPanel;
    }

    public HeatMapPanel getNodeOverlapPanel() {
        return this.nodeOverlapPanel;
    }

    public ColorGradientRange getRange() {
        return this.range;
    }

    public ColorGradientTheme getTheme() {
        return this.theme;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public boolean isSortbycolumn_event_triggered() {
        return this.sortbycolumn_event_triggered;
    }

    public void setSortbycolumn_event_triggered(boolean sortbycolumn_event_triggered) {
        this.sortbycolumn_event_triggered = sortbycolumn_event_triggered;
    }

    public String getSortbycolumnName() {
        return this.sortbycolumnName;
    }

    public void setSortbycolumnName(String sortbycolumnName) {
        this.sortbycolumnName = sortbycolumnName;
    }

    public String getRankFileIndex() {
        return this.rankFileIndex;
    }

    public void setRankFileIndex(String rankFileIndex) {
        this.rankFileIndex = rankFileIndex;
    }

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending(int index) {
        if (index == -1) {
            return true;
        }
        return this.ascending[index];
    }

    public void flipAscending(int index) {
        this.ascending[index] = !this.ascending[index];
    }

    public void changeAscendingValue(int index) {
        if (index != -1) {
            this.ascending[index] = !this.ascending[index];
        }
    }

    public boolean isShowValues() {
        return this.showValues;
    }

    public void setShowValues(boolean showvalues) {
        this.showValues = showvalues;
    }

    public static final class Sort
    extends Enum<Sort> {
        public static final /* enum */ Sort RANK = new Sort();
        public static final /* enum */ Sort COLUMN = new Sort();
        public static final /* enum */ Sort CLUSTER = new Sort();
        public static final /* enum */ Sort NONE = new Sort();
        public static final /* enum */ Sort DEFAULT = new Sort();
        private static final /* synthetic */ Sort[] $VALUES;

        public static Sort[] values() {
            return (Sort[])$VALUES.clone();
        }

        static {
            $VALUES = new Sort[]{RANK, COLUMN, CLUSTER, NONE, DEFAULT};
        }
    }

    public static final class Transformation
    extends Enum<Transformation> {
        public static final /* enum */ Transformation ROWNORM = new Transformation();
        public static final /* enum */ Transformation ASIS = new Transformation();
        public static final /* enum */ Transformation LOGTRANSFORM = new Transformation();
        private static final /* synthetic */ Transformation[] $VALUES;

        public static Transformation[] values() {
            return (Transformation[])$VALUES.clone();
        }

        static {
            $VALUES = new Transformation[]{ROWNORM, ASIS, LOGTRANSFORM};
        }
    }
}

