/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.LongArrayList;
import java.util.ArrayList;

public abstract class AbstractLongList
extends AbstractList {
    protected int size;

    protected AbstractLongList() {
    }

    public void addAllOfFromTo(AbstractLongList abstractLongList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractLongList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractLongList abstractLongList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractLongList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public long[] elements() {
        long[] lArray = new long[this.size];
        int n = this.size;
        while (--n >= 0) {
            lArray[n] = this.getQuick(n);
        }
        return lArray;
    }

    public AbstractLongList elements(long[] lArray) {
        this.clear();
        this.addAllOfFromTo(new LongArrayList(lArray), 0, lArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractLongList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractLongList abstractLongList = (AbstractLongList)object;
        if (this.size() != abstractLongList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractLongList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public long get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract long getQuick(int var1);

    public AbstractLongList partFromTo(int n, int n2) {
        AbstractLongList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        LongArrayList longArrayList = new LongArrayList(n3);
        longArrayList.addAllOfFromTo(this, n, n2);
        return longArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractLongList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractLongList abstractLongList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractLongList.checkRangeFromTo(n, n2, this.size());
            AbstractLongList.checkRangeFromTo(n3, n3 + n4 - 1, abstractLongList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractLongList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractLongList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, long var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Long(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

