/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ParseGenericEnrichmentResults
extends AbstractTask {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public ParseGenericEnrichmentResults(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
    }

    public void parse() throws IOException {
        if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName1);
        }
        if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName2);
        }
    }

    public void readFile(String EnrichmentResultFileName) throws IOException {
        InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        this.parseGenericFile(lines);
    }

    public void parseGenericFile(String[] lines) {
        HashMap<String, GeneSet> genesets = this.dataset.getMap().getAllGenesets();
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = false;
        boolean ignore_phenotype = false;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        for (int i = 1; i < lines.length; ++i) {
            GenericResult result;
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[0].toUpperCase().trim();
            if (genesets.containsKey(name)) {
                GeneSet current_set = genesets.get(name);
                gs_size = current_set.getGenes().size();
            }
            String description = tokens[1].toUpperCase();
            if (!tokens[2].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[2]);
            }
            if (length > 3) {
                if (!tokens[3].equalsIgnoreCase("")) {
                    FDRqvalue = Double.parseDouble(tokens[3]);
                    FDR = true;
                }
                if (length > 4 && !ignore_phenotype) {
                    if (!tokens[4].equalsIgnoreCase("")) {
                        if (tokens[4].equalsIgnoreCase(this.upPhenotype)) {
                            NES = 1.0;
                        } else if (tokens[4].equalsIgnoreCase(this.downPhenotype)) {
                            NES = -1.0;
                        } else {
                            try {
                                NES = Double.parseDouble(tokens[4]);
                            }
                            catch (NumberFormatException nfe) {
                                throw new IllegalThreadStateException(tokens[4] + " is not a valid phenotype.  Phenotype specified in generic enrichment results file must have the same phenotype as specified in advanced options or must be a positive or negative number.");
                            }
                        }
                    }
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue, NES);
                } else {
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
                }
            } else {
                result = new GenericResult(name, description, pvalue, gs_size);
            }
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Generic Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
        if (FDR) {
            this.dataset.getMap().getParams().setFDR(FDR);
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Enrichment Result file");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Parsing GSEA Enrichment Result file");
        this.parse();
    }
}

