/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate;

import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.CySession;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAnnotationParameters {
    private CyNetworkView networkView;
    private long networkViewID;
    private String selectedAnnotationSetName;
    private HashMap<String, AnnotationSet> annotationSets = new HashMap();

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public void setNetworkView(CyNetworkView networkView) {
        this.networkView = networkView;
        this.networkViewID = networkView.getSUID();
    }

    public AnnotationSet getSelectedAnnotationSet() {
        return this.annotationSets.get(this.selectedAnnotationSetName);
    }

    public void setSelectedAnnotationSet(AnnotationSet selectedAnnotationSet) {
        this.selectedAnnotationSetName = selectedAnnotationSet.getName();
        selectedAnnotationSet.setSelected(true);
        for (AnnotationSet annotationSet : this.annotationSets.values()) {
            if (annotationSet.equals(selectedAnnotationSet)) continue;
            annotationSet.setSelected(false);
        }
    }

    public void setSelectedAnnotationSetName(String selectedAnnotationSetName) {
        this.selectedAnnotationSetName = selectedAnnotationSetName;
    }

    public HashMap<String, AnnotationSet> getAnnotationSets() {
        return this.annotationSets;
    }

    public void addAnnotationSet(AnnotationSet annotationSet) {
        this.annotationSets.put(annotationSet.getName(), annotationSet);
    }

    public void removeAnnotationSet(AnnotationSet annotationSet) {
        this.annotationSets.remove(annotationSet.getName());
    }

    public String nextAnnotationSetName(String algorithm, String clusterColumnName) {
        String originalAnnotationSetName = null;
        originalAnnotationSetName = algorithm != null ? algorithm + " Annotation Set" : clusterColumnName + " Column Annotation Set";
        String annotationSetName = originalAnnotationSetName;
        int suffix = 2;
        while (this.annotationSets.keySet().contains(annotationSetName)) {
            annotationSetName = originalAnnotationSetName + " " + suffix;
            ++suffix;
        }
        return annotationSetName;
    }

    public String nextClusterColumnName(String clusterMakerColumnName, CyTable nodeTable) {
        String originalClusterColumnName;
        String clusterColumnName = originalClusterColumnName = clusterMakerColumnName;
        int suffix = 2;
        while (nodeTable.getColumn(clusterColumnName) != null) {
            clusterColumnName = originalClusterColumnName + suffix;
            ++suffix;
        }
        return clusterColumnName;
    }

    public void load(String fullText, CySession session) {
        String[] fileLines = fullText.split("\n");
        CyNetworkView view = (CyNetworkView)session.getObject(Long.valueOf(Long.parseLong(fileLines[0])), CyNetworkView.class);
        this.setNetworkView(view);
        try {
            for (Annotation annotation : AutoAnnotationManager.getInstance().getAnnotationManager().getAnnotations(view)) {
                annotation.removeAnnotation();
            }
        }
        catch (Exception e) {
            System.out.println("There are no annotations in this view");
        }
        this.setSelectedAnnotationSetName(fileLines[1]);
        ArrayList<String> annotationSetLines = new ArrayList<String>();
        for (int lineNumber = 2; lineNumber < fileLines.length; ++lineNumber) {
            String line = fileLines[lineNumber];
            if (!line.equals("End of annotation set")) {
                annotationSetLines.add(line);
                continue;
            }
            AnnotationSet annotationSet = new AnnotationSet();
            annotationSet.setView(this.networkView);
            annotationSet.load(annotationSetLines, session);
            this.addAnnotationSet(annotationSet);
            annotationSetLines = new ArrayList();
        }
    }

    public String toSessionString() {
        String sessionString = "";
        sessionString = sessionString + this.networkViewID + "\n";
        sessionString = sessionString + this.selectedAnnotationSetName + "\n";
        for (AnnotationSet annotationSet : this.annotationSets.values()) {
            sessionString = sessionString + annotationSet.toSessionString();
        }
        return sessionString;
    }
}

