/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfo;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfoNumberComparator;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAnnotationUtils {
    private static int min_size = 50;
    private static Color fillColor = Color.getHSBColor(0.19f, 1.25f, 0.95f);

    public static void selectCluster(Cluster selectedCluster, CommandExecutorTaskFactory executor, SynchronousTaskManager<?> syncTaskManager) {
        if (!selectedCluster.isSelected()) {
            CyNetwork network = (CyNetwork)selectedCluster.getParent().getView().getModel();
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            autoAnnotationManager.flushPayloadEvents();
            boolean heatMapUpdating = true;
            while (heatMapUpdating) {
                heatMapUpdating = autoAnnotationManager.isHeatMapUpdating();
            }
            selectedCluster.setSelected(true);
            if (selectedCluster.isCollapsed()) {
                network.getRow((CyIdentifiable)selectedCluster.getGroupNode()).set("selected", (Object)true);
            } else {
                for (CyNode node : selectedCluster.getNodes()) {
                    network.getRow((CyIdentifiable)node).set("selected", (Object)true);
                }
            }
            ArrayList<String> commands = new ArrayList<String>();
            String command = "wordcloud select cloudName=\"" + selectedCluster.getCloudName() + "\"";
            commands.add(command);
            TaskIterator task = executor.createTaskIterator(commands, null);
            syncTaskManager.execute(task);
            selectedCluster.getEllipse().setBorderColor((Paint)Color.YELLOW);
            selectedCluster.getEllipse().setBorderWidth((double)(3 * selectedCluster.getParent().getEllipseWidth()));
            selectedCluster.getTextAnnotation().setTextColor(Color.YELLOW);
        }
    }

    public static void deselectCluster(Cluster deselectedCluster) {
        if (deselectedCluster.isSelected()) {
            CyNetwork network = (CyNetwork)deselectedCluster.getParent().getView().getModel();
            int ellipseBorderWidth = deselectedCluster.getParent().getEllipseWidth();
            deselectedCluster.setSelected(false);
            if (deselectedCluster.isCollapsed()) {
                network.getRow((CyIdentifiable)deselectedCluster.getGroupNode()).set("selected", (Object)false);
            } else {
                for (CyNode node : deselectedCluster.getNodes()) {
                    network.getRow((CyIdentifiable)node).set("selected", (Object)false);
                }
            }
            deselectedCluster.getEllipse().setBorderColor((Paint)Color.DARK_GRAY);
            deselectedCluster.getEllipse().setBorderWidth((double)ellipseBorderWidth);
            deselectedCluster.getTextAnnotation().setTextColor(Color.BLACK);
            deselectedCluster.getParent().updateCoordinates();
            if (deselectedCluster.coordinatesChanged()) {
                deselectedCluster.erase();
                AutoAnnotationUtils.drawCluster(deselectedCluster);
                deselectedCluster.setCoordinatesChanged(false);
            }
        }
    }

    public static void destroyCluster(Cluster clusterToDestroy, CommandExecutorTaskFactory executor, SynchronousTaskManager<?> syncTaskManager) {
        AutoAnnotationUtils.destroyCloud(clusterToDestroy, executor, syncTaskManager);
        clusterToDestroy.erase();
        clusterToDestroy.getParent().getClusterMap().remove(clusterToDestroy.getClusterNumber());
    }

    public static void destroyCloud(Cluster clusterToDestroy, CommandExecutorTaskFactory executor, SynchronousTaskManager<?> syncTaskManager) {
        ArrayList<String> commands = new ArrayList<String>();
        String command = "wordcloud delete cloudName=\"" + clusterToDestroy.getCloudName() + "\"";
        commands.add(command);
        TaskIterator task = executor.createTaskIterator(commands, null);
        syncTaskManager.execute(task);
    }

    public static void drawEllipse(Cluster cluster) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        AnnotationSet parent = cluster.getParent();
        CyNetworkView view = parent.getView();
        String shapeType = parent.getShapeType();
        int ellipseBorderWidth = parent.getEllipseWidth();
        boolean showEllipses = parent.isShowEllipses();
        int ellipseOpacity = parent.getEllipseOpacity();
        AnnotationFactory<ShapeAnnotation> shapeFactory = autoAnnotationManager.getShapeFactory();
        AnnotationManager annotationManager = autoAnnotationManager.getAnnotationManager();
        double zoom = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        double[] bounds = cluster.getBounds();
        double xmin = bounds[0];
        double xmax = bounds[1];
        double ymin = bounds[2];
        double ymax = bounds[3];
        double centreX = (xmin + xmax) / 2.0;
        double centreY = (ymin + ymax) / 2.0;
        double width = xmax - xmin;
        width = width > (double)min_size ? width : (double)min_size;
        double height = ymax - ymin;
        height = height > (double)min_size ? height : (double)min_size;
        HashMap<CyNode, double[]> nodesToCoordinates = cluster.getNodesToCoordinates();
        HashMap<CyNode, Double> nodesToRadii = cluster.getNodesToRadii();
        if (shapeType.equals("ELLIPSE")) {
            while (AutoAnnotationUtils.nodesOutOfCluster(nodesToCoordinates, nodesToRadii, width, height, centreX, centreY, ellipseBorderWidth)) {
                width *= 1.1;
                height *= 1.1;
            }
            width += 40.0;
            height += 40.0;
        } else {
            width += 50.0;
            height += 50.0;
        }
        Integer xPos = (int)Math.round(centreX - width / 2.0);
        Integer yPos = (int)Math.round(centreY - height / 2.0);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x", String.valueOf(xPos));
        arguments.put("y", String.valueOf(yPos));
        arguments.put("zoom", String.valueOf(zoom));
        arguments.put("canvas", "background");
        arguments.put("shapeType", shapeType);
        ShapeAnnotation ellipse = (ShapeAnnotation)shapeFactory.createAnnotation(ShapeAnnotation.class, view, arguments);
        ellipse.setSize(width * zoom, height * zoom);
        ellipse.setBorderWidth((double)ellipseBorderWidth);
        ellipse.setBorderColor((Paint)Color.DARK_GRAY);
        ellipse.setFillColor((Paint)fillColor);
        ellipse.setFillOpacity((double)ellipseOpacity);
        cluster.setEllipse(ellipse);
        if (showEllipses) {
            annotationManager.addAnnotation((Annotation)ellipse);
        }
    }

    private static boolean nodesOutOfCluster(HashMap<CyNode, double[]> nodesToCoordinates, HashMap<CyNode, Double> nodesToRadii, double width, double height, double centreX, double centreY, int ellipseWidth) {
        double semimajor_axis = width / 2.0;
        double semiminor_axis = height / 2.0;
        for (CyNode node : nodesToCoordinates.keySet()) {
            double[] coordinates = nodesToCoordinates.get(node);
            double nodeSize = nodesToRadii.get(node);
            if (!(Math.pow((coordinates[0] - centreX - (double)ellipseWidth) / semimajor_axis, 2.0) + Math.pow(nodeSize / semimajor_axis, 2.0) + Math.pow((coordinates[1] - centreY - (double)ellipseWidth) / semiminor_axis, 2.0) + Math.pow(nodeSize / semiminor_axis, 2.0) >= 1.0)) continue;
            return true;
        }
        return false;
    }

    public static void drawTextLabel(Cluster cluster) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        AnnotationSet parent = cluster.getParent();
        CyNetworkView view = parent.getView();
        boolean constantFontSize = parent.isConstantFontSize();
        int fontSize = parent.getFontSize();
        double[] labelPosition = parent.getLabelPosition();
        boolean showLabel = parent.isShowLabel();
        AnnotationFactory<TextAnnotation> textFactory = autoAnnotationManager.getTextFactory();
        AnnotationManager annotationManager = autoAnnotationManager.getAnnotationManager();
        double zoom = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        String labelText = cluster.getLabel();
        Map ellipseArgs = cluster.getEllipse().getArgMap();
        double xPos = Double.parseDouble((String)ellipseArgs.get("x"));
        double yPos = Double.parseDouble((String)ellipseArgs.get("y"));
        double width = Double.parseDouble((String)ellipseArgs.get("width"));
        double height = Double.parseDouble((String)ellipseArgs.get("height"));
        Integer labelFontSize = null;
        labelFontSize = constantFontSize ? Integer.valueOf(fontSize) : Integer.valueOf((int)Math.round(5.0 * Math.pow(cluster.getSize(), 0.4)));
        double labelWidth = 2.3;
        double labelHeight = 4.8;
        if (labelText != null && labelFontSize != null) {
            labelWidth = 2.3 * (double)labelFontSize.intValue() * (double)labelText.length();
            labelHeight = 4.8 * (double)labelFontSize.intValue();
        }
        double xOffset = labelPosition[0];
        double yOffset = labelPosition[1];
        xPos = yOffset == 0.5 && xOffset != 0.5 ? (double)((int)Math.round(xPos + width / zoom * xOffset + labelWidth * (xOffset - 1.0))) : (double)((int)Math.round(xPos + width / zoom * xOffset - labelWidth * xOffset));
        yPos = (int)Math.round(yPos + height / zoom * yOffset - labelHeight * (1.0 - yOffset) - 10.0 + yOffset * 20.0);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x", String.valueOf(xPos));
        arguments.put("y", String.valueOf(yPos));
        arguments.put("zoom", String.valueOf(zoom));
        arguments.put("canvas", "foreground");
        TextAnnotation textAnnotation = (TextAnnotation)textFactory.createAnnotation(TextAnnotation.class, view, arguments);
        if (textAnnotation != null && labelText != null) {
            textAnnotation.setText(labelText);
            textAnnotation.setFontSize(5.0 * zoom * (double)labelFontSize.intValue());
            cluster.setTextAnnotation(textAnnotation);
            if (showLabel) {
                annotationManager.addAnnotation((Annotation)textAnnotation);
            }
        }
    }

    public static void drawCluster(Cluster cluster) {
        AutoAnnotationUtils.drawEllipse(cluster);
        AutoAnnotationUtils.drawTextLabel(cluster);
    }

    public static void updateClusterLabel(Cluster cluster, CyTable clusterSetTable) {
        AnnotationSet parent = cluster.getParent();
        CyNetwork network = (CyNetwork)parent.getView().getModel();
        String nameColumnName = parent.getNameColumnName();
        double sameClusterBonus = parent.getSameClusterBonus();
        double centralityBonus = parent.getCentralityBonus();
        String mostCentralNodeLabel = cluster.getMostCentralNodeLabel();
        if (cluster.getSize() == 1) {
            String oldLabel = cluster.getLabel();
            String newLabel = (String)network.getRow((CyIdentifiable)cluster.getNodesToCoordinates().keySet().iterator().next()).get(nameColumnName, String.class);
            if (!newLabel.equals(oldLabel)) {
                cluster.setLabel(newLabel);
            }
        } else {
            CyRow clusterRow = clusterSetTable.getRow((Object)cluster.getCloudName());
            List wordList = (List)clusterRow.get("WC_Word", List.class);
            List sizeList = (List)clusterRow.get("WC_FontSize", List.class);
            List clusterList = (List)clusterRow.get("WC_Cluster", List.class);
            List numberList = (List)clusterRow.get("WC_Number", List.class);
            ArrayList<WordInfo> wordInfos = new ArrayList<WordInfo>();
            for (int i = 0; i < wordList.size(); ++i) {
                wordInfos.add(new WordInfo((String)wordList.get(i), Integer.parseInt((String)sizeList.get(i)), Integer.parseInt((String)clusterList.get(i)), Integer.parseInt((String)numberList.get(i))));
            }
            AnnotationSet annotationSet = cluster.getParent();
            if (wordInfos.size() != cluster.getWordInfos().size()) {
                cluster.setWordInfos(wordInfos);
                cluster.setLabel(AutoAnnotationUtils.makeLabel(wordInfos, mostCentralNodeLabel, sameClusterBonus, centralityBonus, annotationSet.getWordSizeThresholds(), annotationSet.getMaxWords()));
            } else {
                for (int infoIndex = 0; infoIndex < cluster.getWordInfos().size(); ++infoIndex) {
                    if (wordInfos.get(infoIndex).equals(cluster.getWordInfos().get(infoIndex))) continue;
                    cluster.setWordInfos(wordInfos);
                    cluster.setLabel(AutoAnnotationUtils.makeLabel(wordInfos, mostCentralNodeLabel, sameClusterBonus, centralityBonus, annotationSet.getWordSizeThresholds(), annotationSet.getMaxWords()));
                    if (cluster.getTextAnnotation() != null) {
                        cluster.getTextAnnotation().setText(cluster.getLabel());
                    }
                    return;
                }
            }
        }
    }

    public static void updateFontSizes() {
        for (CyNetworkView view : AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters().keySet()) {
            AutoAnnotationParameters params = AutoAnnotationManager.getInstance().getNetworkViewToAutoAnnotationParameters().get(view);
            for (AnnotationSet annotationSet : params.getAnnotationSets().values()) {
                for (Cluster cluster : annotationSet.getClusterMap().values()) {
                    cluster.eraseText();
                    AutoAnnotationUtils.drawTextLabel(cluster);
                    if (annotationSet.isSelected() && annotationSet.isShowLabel()) continue;
                    cluster.eraseText();
                }
            }
        }
    }

    public static String makeLabel(ArrayList<WordInfo> wordInfos, String mostCentralNodeLabel, double sameClusterBonus, double centralityBonus, List<Integer> wordSizeThresholds, int maxWords) {
        ArrayList<WordInfo> wordInfosCopy = new ArrayList<WordInfo>();
        for (WordInfo wordInfo : wordInfos) {
            wordInfosCopy.add(wordInfo.clone());
        }
        if (wordInfosCopy.size() == 0) {
            return "";
        }
        Collections.sort(wordInfosCopy);
        WordInfo biggestWord = (WordInfo)wordInfosCopy.get(0);
        ArrayList<WordInfo> label = new ArrayList<WordInfo>();
        label.add(biggestWord);
        int numWords = 1;
        WordInfo nextWord = biggestWord;
        wordInfosCopy.remove(0);
        for (WordInfo word : wordInfosCopy) {
            if (!mostCentralNodeLabel.toLowerCase().contains(word.getWord())) continue;
            word.setSize(word.getSize() + centralityBonus);
        }
        while (numWords < maxWords && wordInfosCopy.size() > 0) {
            for (WordInfo word : wordInfosCopy) {
                if (word.getCluster() != nextWord.getCluster()) continue;
                word.setSize(word.getSize() + sameClusterBonus);
            }
            Collections.sort(wordInfosCopy);
            double wordSizeThreshold = nextWord.getSize() * (double)wordSizeThresholds.get(numWords - 1).intValue() / 100.0;
            nextWord = (WordInfo)wordInfosCopy.get(0);
            wordInfosCopy.remove(0);
            if (!(nextWord.getSize() > wordSizeThreshold)) break;
            label.add(nextWord);
            ++numWords;
        }
        Collections.sort(label, WordInfoNumberComparator.getInstance());
        return AutoAnnotationUtils.join(label, " ");
    }

    private static String join(List<WordInfo> stringList, String separator) {
        String joined = "";
        for (int index = 0; index < stringList.size(); ++index) {
            joined = index == 0 ? joined + stringList.get(index).getWord() : joined + separator + stringList.get(index).getWord();
        }
        return joined;
    }

    public static void updateNodeCentralities(Cluster cluster) {
        String edgeAttribute;
        CyNetwork network = (CyNetwork)cluster.getParent().getView().getModel();
        try {
            edgeAttribute = EnrichmentMapManager.getInstance().getCyNetworkList().get(network.getSUID()).getParams().getAttributePrefix() + EnrichmentMapVisualStyle.SIMILARITY_COEFFICIENT;
        }
        catch (NullPointerException e) {
            edgeAttribute = "--None--";
        }
        Set<CyNode> nodeSet = cluster.getNodes();
        HashMap<CyNode, Double> nodeCentralities = new HashMap<CyNode, Double>();
        for (CyNode node : nodeSet) {
            double clusterWeightedDegreeSum = 0.0;
            for (CyEdge edge : network.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
                if ((edge.getSource() == node || !nodeSet.contains(edge.getSource())) && (edge.getTarget() == node || !nodeSet.contains(edge.getTarget()))) continue;
                try {
                    clusterWeightedDegreeSum += ((Double)network.getRow((CyIdentifiable)edge).get(edgeAttribute, Double.class)).doubleValue();
                }
                catch (Exception e) {
                    clusterWeightedDegreeSum += 1.0;
                }
            }
            nodeCentralities.put(node, clusterWeightedDegreeSum);
        }
        cluster.setNodesToCentralities(nodeCentralities);
    }
}

