/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.HashMap;
import java.util.TreeSet;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.parsers.DetermineEnrichmentResultFileReader;
import org.baderlab.csplugins.enrichmentmap.parsers.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.RanksFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.task.BuildEnrichmentMapDummyTask;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateDummyExpressionTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateEnrichmentMapNetworkTask;
import org.baderlab.csplugins.enrichmentmap.task.FilterGenesetsByDatasetGenes;
import org.baderlab.csplugins.enrichmentmap.task.InitializeGenesetsOfInterestTask;
import org.baderlab.csplugins.enrichmentmap.task.VisualizeEnrichmentMapTask;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;

public class EnrichmentMapBuildMapTaskFactory
implements TaskFactory {
    private EnrichmentMap map;
    private CyApplicationManager applicationManager;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager networkViewManager;
    private CyNetworkViewFactory networkViewFactory;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private VisualMappingManager visualMappingManager;
    private VisualStyleFactory visualStyleFactory;
    private VisualMappingFunctionFactory vmfFactoryContinuous;
    private VisualMappingFunctionFactory vmfFactoryDiscrete;
    private VisualMappingFunctionFactory vmfFactoryPassthrough;
    private StreamUtil streamUtil;
    private DialogTaskManager dialog;
    private CyLayoutAlgorithmManager layoutManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;

    public EnrichmentMapBuildMapTaskFactory(EnrichmentMap map, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyNetworkViewFactory networkViewFactory, CyNetworkFactory networkFactory, CyTableFactory tableFactory, CyTableManager tableManager, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough, DialogTaskManager dialog, StreamUtil streamUtil, CyLayoutAlgorithmManager layoutManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable) {
        this.map = map;
        this.applicationManager = applicationManager;
        this.networkManager = networkManager;
        this.networkViewManager = networkViewManager;
        this.networkViewFactory = networkViewFactory;
        this.networkFactory = networkFactory;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.dialog = dialog;
        this.streamUtil = streamUtil;
        this.layoutManager = layoutManager;
        this.mapTableToNetworkTable = mapTableToNetworkTable;
    }

    public TaskIterator createTaskIterator() {
        BuildEnrichmentMapDummyTask dummyTaskToSetTitle = new BuildEnrichmentMapDummyTask();
        TaskIterator currentTasks = new TaskIterator(8, new Task[]{dummyTaskToSetTitle});
        HashMap<String, DataSet> datasets = this.map.getDatasets();
        TreeSet<String> dataset_names = new TreeSet<String>(datasets.keySet());
        for (String dataset_name : dataset_names) {
            RanksFileReaderTask ranking1;
            DataSet dataset = datasets.get(dataset_name);
            if (dataset.getSetofgenesets().getFilename() != null && !dataset.getSetofgenesets().getFilename().isEmpty()) {
                GMTFileReaderTask gmtFileTask = new GMTFileReaderTask(dataset, this.streamUtil);
                currentTasks.append((Task)gmtFileTask);
            }
            DetermineEnrichmentResultFileReader enrichmentResultsFilesTask = new DetermineEnrichmentResultFileReader(dataset, this.streamUtil);
            currentTasks.append(enrichmentResultsFilesTask.getParsers());
            if (dataset.getDatasetFiles().getExpressionFileName() == null || dataset.getDatasetFiles().getExpressionFileName().isEmpty()) {
                CreateDummyExpressionTask dummyExpressionTask = new CreateDummyExpressionTask(dataset);
                currentTasks.append((Task)dummyExpressionTask);
            } else {
                ExpressionFileReaderTask expressionFileTask = new ExpressionFileReaderTask(dataset, this.streamUtil);
                currentTasks.append((Task)expressionFileTask);
            }
            if (dataset.getMap().getParams().getMethod().equalsIgnoreCase("GSEA")) {
                if (dataset.getExpressionSets().getRanksByName("GSEARanking") == null) continue;
                ranking1 = new RanksFileReaderTask(dataset.getExpressionSets().getRanksByName("GSEARanking").getFilename(), dataset, "GSEARanking", false, this.streamUtil);
                currentTasks.append((Task)ranking1);
                continue;
            }
            if (dataset.getExpressionSets().getRanksByName("Dataset 1") != null) {
                ranking1 = new RanksFileReaderTask(dataset.getExpressionSets().getRanksByName("Dataset 1").getFilename(), dataset, "Dataset 1", false, this.streamUtil);
                currentTasks.append((Task)ranking1);
            }
            if (dataset.getExpressionSets().getRanksByName("Dataset 2") == null) continue;
            ranking1 = new RanksFileReaderTask(dataset.getExpressionSets().getRanksByName("Dataset 2").getFilename(), dataset, "Dataset 2", false, this.streamUtil);
            currentTasks.append((Task)ranking1);
        }
        FilterGenesetsByDatasetGenes filter = new FilterGenesetsByDatasetGenes(this.map);
        currentTasks.append((Task)filter);
        InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(this.map);
        currentTasks.append((Task)genesets_init);
        ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.map);
        currentTasks.append((Task)similarities);
        CreateEnrichmentMapNetworkTask create_map = new CreateEnrichmentMapNetworkTask(this.map, this.networkFactory, this.applicationManager, this.networkManager, this.tableFactory, this.tableManager, this.mapTableToNetworkTable);
        currentTasks.append((Task)create_map);
        VisualizeEnrichmentMapTask map_viz = new VisualizeEnrichmentMapTask(this.map, this.networkFactory, this.networkManager, this.networkViewManager, this.networkViewFactory, this.visualMappingManager, this.visualStyleFactory, this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough, this.layoutManager);
        currentTasks.append((Task)map_viz);
        return currentTasks;
    }

    public boolean isReady() {
        return this.map != null && !this.map.getDatasets().isEmpty();
    }
}

