/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.HashMap;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class BuildGMTEnrichmentMapTask
extends AbstractTask {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private DataSet dataset;

    public BuildGMTEnrichmentMapTask(DataSet dataset) {
        this.dataset = dataset;
    }

    public void buildEnrichmentMap() {
        this.dataset.getMap().getParams().setMethod("generic");
        this.dataset.setGenesetsOfInterest(this.dataset.getSetofgenesets());
        HashMap<String, GeneSet> current_sets = this.dataset.getSetofgenesets().getGenesets();
        SetOfEnrichmentResults setofenrichments = new SetOfEnrichmentResults();
        HashMap<String, EnrichmentResult> currentEnrichments = setofenrichments.getEnrichments();
        Iterator<String> i = current_sets.keySet().iterator();
        while (i.hasNext()) {
            String geneset1_name = i.next().toString();
            GeneSet current = current_sets.get(geneset1_name);
            GenericResult temp_result = new GenericResult(current.getName(), current.getDescription(), 0.01, current.getGenes().size());
            currentEnrichments.put(current.getName(), temp_result);
        }
        this.dataset.setEnrichments(setofenrichments);
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Computing geneset similarities");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Computing geneset similarities");
        this.buildEnrichmentMap();
    }
}

