/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.Insets;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.OpenBrowser;

public class AboutPanel
extends JDialog {
    private static final long serialVersionUID = 7233557042420194604L;
    private CySwingApplication application;
    private OpenBrowser browser;

    public AboutPanel(CySwingApplication application, OpenBrowser browser) {
        super(application.getJFrame(), "About Enrichment Map", false);
        this.application = application;
        this.browser = browser;
        this.setResizable(false);
        String pluginUrl = EnrichmentMapUtils.pluginUrl;
        String pluginVersion = EnrichmentMapUtils.pluginVersion;
        String pluginReleaseSuffix = EnrichmentMapUtils.pluginReleaseSuffix;
        JEditorPane editorPane = new JEditorPane();
        editorPane.setMargin(new Insets(10, 10, 10, 10));
        editorPane.setEditable(false);
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.addHyperlinkListener(new HyperlinkAction(editorPane));
        URL logoURL = this.getClass().getResource("enrichmentmap_logo.png");
        if (!pluginReleaseSuffix.contentEquals("")) {
            pluginReleaseSuffix = " (" + pluginReleaseSuffix + ")";
        }
        editorPane.setText("<html><body><table border='0'><tr><td width='125'></td><td width='200'><p align=center><b>Enrichment Map v" + pluginVersion + pluginReleaseSuffix + "</b><BR>" + "A Cytoscape App<BR>" + "<BR></p>" + "</td>" + "<td width='125'><div align='right'><img height='77' width='125' src=\"" + logoURL.toString() + "\" ></div></td>" + "</tr></table>" + "<p align=center>Enrichment Map is a network-based method to visualize<BR>" + "and interpret gene-set enrichment results.<BR>" + "<BR>" + "by Gary Bader, Daniele Merico, Ruth Isserlin and Oliver Stueker<BR>" + "(<a href='http://www.baderlab.org/'>Bader Lab</a>, University of Toronto)<BR>" + "<BR>" + "App Homepage:<BR>" + "<a href='" + pluginUrl + "'>" + pluginUrl + "</a><BR>" + "<BR>" + "If you use this app in your research, please cite:<BR>" + "Merico D, Isserlin R, Stueker O, Emili A, Bader GD<BR>" + "Enrichment Map: A Network-Based Method for <BR>" + "Gene-Set Enrichment Visualization and Interpretation<BR>" + "<i>PLoS One. 2010 Nov 15;5(11)</i><BR>" + "<BR>" + "<font size='-1'>" + EnrichmentMapUtils.buildId + "</font>" + "</p></body></html>");
        this.setContentPane(editorPane);
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        JEditorPane pane;

        public HyperlinkAction(JEditorPane pane) {
            this.pane = pane;
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                AboutPanel.this.browser.openURL(event.getURL().toString());
            }
        }
    }
}

