/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.task.UpdateHeatMapTask;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class EnrichmentMapActionListener
implements RowsSetListener {
    private EnrichmentMap map;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private List<CyNode> Nodes;
    private List<CyEdge> Edges;
    private CyApplicationManager applicationManager;
    private SynchronousTaskManager syncTaskManager;
    private final CytoPanel cytoPanelSouth;
    private FileUtil fileUtil;
    private StreamUtil streamUtil;

    public EnrichmentMapActionListener(HeatMapPanel heatMapPanel_node, HeatMapPanel heatMapPanel_edge, CyApplicationManager applicationManager, CySwingApplication application, FileUtil fileUtil, StreamUtil streamUtil, SynchronousTaskManager syncTaskManager) {
        this.applicationManager = applicationManager;
        this.fileUtil = fileUtil;
        this.streamUtil = streamUtil;
        this.syncTaskManager = syncTaskManager;
        this.edgeOverlapPanel = heatMapPanel_edge;
        this.nodeOverlapPanel = heatMapPanel_node;
        this.cytoPanelSouth = application.getCytoPanel(CytoPanelName.SOUTH);
    }

    private boolean initialize(CyNetwork network) {
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        this.map = manager.getMap(network.getSUID());
        if (this.map != null) {
            if (this.map.getParams().isData() && this.map.getParams().getHmParams() == null) {
                HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel);
                hmParams.initColorGradients(this.map.getDataset("Dataset 1").getExpressionSets());
                this.map.getParams().setHmParams(hmParams);
            }
            this.Nodes = this.map.getParams().getSelectedNodes();
            this.Edges = this.map.getParams().getSelectedEdges();
            return true;
        }
        return false;
    }

    public void handleEvent(RowsSetEvent e) {
        boolean override_revalidate_heatmap = EnrichmentMapUtils.isOverrideHeatmapRevalidation();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network != null && e != null && (e.getSource() == network.getDefaultEdgeTable() || e.getSource() == network.getDefaultNodeTable()) && this.initialize(network) && !override_revalidate_heatmap) {
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
            this.Edges.clear();
            this.Edges.addAll(selectedEdges);
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
            this.Nodes.clear();
            this.Nodes.addAll(selectedNodes);
            UpdateHeatMapTask updateHeatmap = new UpdateHeatMapTask(this.map, this.Nodes, this.Edges, this.edgeOverlapPanel, this.nodeOverlapPanel, this.cytoPanelSouth, this.applicationManager);
            this.syncTaskManager.execute(new TaskIterator(new Task[]{updateHeatmap}));
        }
    }
}

