/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.LoadDataSetTask;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class LoadInputDataTaskFactory
implements TaskFactory {
    private TaskIterator loadIterator;
    private EnrichmentMap map;
    private StreamUtil streamUtil;

    public LoadInputDataTaskFactory(EnrichmentMap map, StreamUtil streamUtil) {
        this.map = map;
        this.streamUtil = streamUtil;
    }

    public void load() {
        DataSet dataset = this.map.getDataset("Dataset 1");
        EnrichmentMapParameters params = this.map.getParams();
        LoadDataSetTask loaddata = new LoadDataSetTask(dataset, this.streamUtil);
        this.loadIterator.append(loaddata.getIterator());
        if (this.map.getParams().isTwoDatasets() && this.map.getDatasets().containsKey("Dataset 2")) {
            DataSet dataset2 = this.map.getDataset("Dataset 2");
            LoadDataSetTask loaddataset2 = new LoadDataSetTask(dataset2, this.streamUtil);
            this.loadIterator.append(loaddataset2.getIterator());
            params.setData2(true);
            if (!dataset.getDatasetGenes().containsAll(dataset2.getDatasetGenes()) || !dataset2.getDatasetGenes().containsAll(dataset.getDatasetGenes())) {
                params.setTwoDistinctExpressionSets(true);
            }
        }
    }

    public TaskIterator createTaskIterator() {
        this.loadIterator = new TaskIterator(new Task[0]);
        this.load();
        return this.loadIterator;
    }

    public boolean isReady() {
        return true;
    }
}

