/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.util.HashMap;
import java.util.Properties;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.EnrichmentMapInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.service.util.CyServiceRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapManager
implements SetCurrentNetworkListener,
NetworkAboutToBeDestroyedListener {
    private static EnrichmentMapManager manager = null;
    private HashMap<Long, EnrichmentMap> cyNetworkList = new HashMap();
    private HashMap<Long, PostAnalysisParameters> cyNetworkListPostAnalysis = new HashMap();
    private ParametersPanel parameterPanel;
    private HeatMapPanel nodesOverlapPanel;
    private HeatMapPanel edgesOverlapPanel;
    private EnrichmentMapInputPanel inputWindow;
    private PostAnalysisInputPanel analysisWindow;
    private CyServiceRegistrar registrar;

    public static EnrichmentMapManager getInstance() {
        if (manager == null) {
            manager = new EnrichmentMapManager();
        }
        return manager;
    }

    public void initialize(ParametersPanel parameterPanel, HeatMapPanel nodesOverlapPanel, HeatMapPanel edgesOverlapPanel, CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.parameterPanel = parameterPanel;
        this.nodesOverlapPanel = nodesOverlapPanel;
        this.edgesOverlapPanel = edgesOverlapPanel;
    }

    public void registerServices() {
        if (this.nodesOverlapPanel != null) {
            this.registrar.registerService((Object)this.nodesOverlapPanel, CytoPanelComponent.class, new Properties());
        }
        if (this.edgesOverlapPanel != null) {
            this.registrar.registerService((Object)this.edgesOverlapPanel, CytoPanelComponent.class, new Properties());
        }
        if (this.parameterPanel != null) {
            this.registrar.registerService((Object)this.parameterPanel, CytoPanelComponent.class, new Properties());
        }
    }

    private EnrichmentMapManager() {
    }

    public void registerNetwork(CyNetwork cyNetwork, EnrichmentMap map) {
        if (!this.cyNetworkList.containsKey(cyNetwork.getSUID())) {
            this.cyNetworkList.put(cyNetwork.getSUID(), map);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, PostAnalysisParameters paParams) {
        if (!this.cyNetworkListPostAnalysis.containsKey(cyNetwork.getSUID())) {
            this.cyNetworkListPostAnalysis.put(cyNetwork.getSUID(), paParams);
        }
    }

    public ParametersPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public HeatMapPanel getNodesOverlapPanel() {
        return this.nodesOverlapPanel;
    }

    public HeatMapPanel getEdgesOverlapPanel() {
        return this.edgesOverlapPanel;
    }

    public HashMap<Long, EnrichmentMap> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public EnrichmentMap getMap(Long id) {
        if (this.cyNetworkList.containsKey(id)) {
            return this.cyNetworkList.get(id);
        }
        return null;
    }

    public EnrichmentMapInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(EnrichmentMapInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public PostAnalysisInputPanel getAnalysisWindow() {
        return this.analysisWindow;
    }

    public void setAnalysisWindow(PostAnalysisInputPanel analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    public boolean isEnrichmentMap(Long networkID) {
        return this.cyNetworkList.containsKey(networkID);
    }

    public void handleEvent(SetCurrentNetworkEvent event) {
        long networkId = event.getNetwork().getSUID();
        if (networkId > 0L && this.cyNetworkList.containsKey(networkId)) {
            this.nodesOverlapPanel.clearPanel();
            this.edgesOverlapPanel.clearPanel();
            EnrichmentMap currentNetwork = this.cyNetworkList.get(networkId);
            this.parameterPanel.updatePanel(currentNetwork);
            if (this.inputWindow != null) {
                this.inputWindow.updateContents(currentNetwork.getParams());
            }
            if (this.analysisWindow != null) {
                this.analysisWindow.updateContents(currentNetwork.getParams());
            }
            this.nodesOverlapPanel.updatePanel(currentNetwork);
            this.edgesOverlapPanel.updatePanel(currentNetwork);
            this.nodesOverlapPanel.revalidate();
            this.edgesOverlapPanel.revalidate();
        }
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent event) {
        Long networkId = event.getNetwork().getSUID();
        if (this.cyNetworkList.containsKey(networkId)) {
            this.cyNetworkList.remove(networkId);
        }
        if (this.cyNetworkListPostAnalysis.containsKey(networkId)) {
            this.cyNetworkListPostAnalysis.remove(networkId);
        }
    }
}

