/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMap {
    private String name = null;
    private HashMap<String, DataSet> datasets;
    private HashMap<String, GenesetSimilarity> genesetSimilarity;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    public static final String DATASET1 = "Dataset 1";
    public static final String DATASET2 = "Dataset 2";
    private EnrichmentMapParameters params;
    private int NumberOfGenes = 0;
    private HashMap<String, GeneSet> signatureGenesets;
    private PostAnalysisParameters paParams;

    public EnrichmentMap(EnrichmentMapParameters params) {
        DataSetFiles dataset2files;
        DataSetFiles dataset1files;
        this.params = params;
        this.name = null;
        this.datasets = new HashMap();
        if (params.getFiles().containsKey(DATASET1) && ((dataset1files = params.getFiles().get(DATASET1)).getEnrichmentFileName1() != null && !dataset1files.getEnrichmentFileName1().isEmpty() || dataset1files.getGMTFileName() != null && !dataset1files.getGMTFileName().isEmpty() || dataset1files.getExpressionFileName() != null && !dataset1files.getExpressionFileName().isEmpty())) {
            DataSet dataset1 = new DataSet(this, DATASET1, dataset1files);
            this.datasets.put(DATASET1, dataset1);
        }
        if (params.getFiles().containsKey(DATASET2) && ((dataset2files = params.getFiles().get(DATASET2)).getEnrichmentFileName1() != null && !dataset2files.getEnrichmentFileName1().isEmpty() || dataset2files.getExpressionFileName() != null && !dataset2files.getExpressionFileName().isEmpty())) {
            DataSet dataset2 = new DataSet(this, DATASET2, dataset2files);
            this.datasets.put(DATASET2, dataset2);
        }
        this.genes = new HashMap();
        this.hashkey2gene = new HashMap();
        this.genesetSimilarity = new HashMap();
        this.signatureGenesets = new HashMap();
        this.initialize_files();
    }

    public EnrichmentMap(EnrichmentMapParameters params, String name) {
        this(params);
        this.name = name;
    }

    public void copy(EnrichmentMap copy) {
        this.name = copy.getName();
        this.genes = copy.getGenes();
        this.hashkey2gene = copy.getHashkey2gene();
        this.genesetSimilarity = copy.getGenesetSimilarity();
        this.params = copy.getParams();
        this.datasets = copy.getDatasets();
        this.signatureGenesets = copy.getSignatureGenesets();
    }

    private void initialize_files() {
        DataSetFiles dataset1files = this.params.getFiles().get(DATASET1);
        if (dataset1files.getGMTFileName() != null && !dataset1files.getGMTFileName().isEmpty()) {
            this.getDataset(DATASET1).getSetofgenesets().setFilename(dataset1files.getGMTFileName());
        }
        if (dataset1files.getExpressionFileName() != null && !dataset1files.getExpressionFileName().isEmpty()) {
            this.getDataset(DATASET1).getExpressionSets().setFilename(dataset1files.getExpressionFileName());
        }
        if (dataset1files.getEnrichmentFileName1() != null && !dataset1files.getEnrichmentFileName1().isEmpty()) {
            this.getDataset(DATASET1).getEnrichments().setFilename1(dataset1files.getEnrichmentFileName1());
        }
        if (dataset1files.getEnrichmentFileName2() != null && !dataset1files.getEnrichmentFileName2().isEmpty()) {
            this.getDataset(DATASET1).getEnrichments().setFilename2(dataset1files.getEnrichmentFileName2());
        }
        if (dataset1files.getPhenotype1() != null && !dataset1files.getPhenotype1().isEmpty()) {
            this.getDataset(DATASET1).getEnrichments().setPhenotype1(dataset1files.getPhenotype1());
        }
        if (dataset1files.getPhenotype2() != null && !dataset1files.getPhenotype2().isEmpty()) {
            this.getDataset(DATASET1).getEnrichments().setPhenotype2(dataset1files.getPhenotype2());
        }
        if (dataset1files.getRankedFile() != null && !dataset1files.getRankedFile().isEmpty()) {
            if (this.params.getMethod().equals("GSEA")) {
                this.getDataset(DATASET1).getExpressionSets().createNewRanking("GSEARanking");
                this.getDataset(DATASET1).getExpressionSets().getRanksByName("GSEARanking").setFilename(dataset1files.getRankedFile());
            } else {
                this.getDataset(DATASET1).getExpressionSets().createNewRanking(DATASET1);
                this.getDataset(DATASET1).getExpressionSets().getRanksByName(DATASET1).setFilename(dataset1files.getRankedFile());
            }
        }
        if (this.params.getFiles().containsKey(DATASET2)) {
            DataSetFiles dataset2files = this.params.getFiles().get(DATASET2);
            if (dataset2files.getExpressionFileName() != null && !dataset2files.getExpressionFileName().isEmpty()) {
                this.getDataset(DATASET2).getExpressionSets().setFilename(dataset2files.getExpressionFileName());
            }
            if (dataset2files.getEnrichmentFileName1() != null && !dataset2files.getEnrichmentFileName1().isEmpty()) {
                this.getDataset(DATASET2).getEnrichments().setFilename1(dataset2files.getEnrichmentFileName1());
            }
            if (dataset2files.getEnrichmentFileName2() != null && !dataset2files.getEnrichmentFileName2().isEmpty()) {
                this.getDataset(DATASET2).getEnrichments().setFilename2(dataset2files.getEnrichmentFileName2());
            }
            if (dataset2files.getPhenotype1() != null && !dataset2files.getPhenotype1().isEmpty()) {
                this.getDataset(DATASET2).getEnrichments().setPhenotype1(dataset2files.getPhenotype1());
            }
            if (dataset2files.getPhenotype2() != null && !dataset2files.getPhenotype2().isEmpty()) {
                this.getDataset(DATASET2).getEnrichments().setPhenotype2(dataset2files.getPhenotype2());
            }
            if (dataset2files.getRankedFile() != null && !dataset2files.getRankedFile().isEmpty()) {
                if (this.params.getMethod().equals("GSEA")) {
                    this.getDataset(DATASET2).getExpressionSets().createNewRanking("GSEARanking");
                    this.getDataset(DATASET2).getExpressionSets().getRanksByName("GSEARanking").setFilename(dataset2files.getRankedFile());
                } else {
                    this.getDataset(DATASET2).getExpressionSets().createNewRanking(DATASET2);
                    this.getDataset(DATASET2).getExpressionSets().getRanksByName(DATASET2).setFilename(dataset2files.getRankedFile());
                }
            }
        }
    }

    public boolean checkGenesets() {
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            HashMap<String, GeneSet> genesets = this.datasets.get(k.next()).getSetofgenesets().getGenesets();
            Iterator<String> j = genesets.keySet().iterator();
            while (j.hasNext()) {
                String geneset2_name = j.next().toString();
                GeneSet current_set = genesets.get(geneset2_name);
                HashSet<Integer> geneset_genes = current_set.getGenes();
                if (geneset_genes.isEmpty()) continue;
                return true;
            }
        }
        return this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO");
    }

    public String getGeneFromHashKey(Integer hash) {
        String gene = null;
        if (this.hashkey2gene != null || !this.hashkey2gene.isEmpty()) {
            gene = this.hashkey2gene.get(hash);
        }
        return gene;
    }

    public HashMap<String, Integer> getGenesetsGenes(HashMap<String, GeneSet> current_genesets) {
        HashMap<String, Integer> genesetGenes = new HashMap<String, Integer>();
        Iterator<String> j = current_genesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset_name = j.next().toString();
            GeneSet current_set = current_genesets.get(geneset_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            for (Integer current_genekey : geneset_genes) {
                if (!this.hashkey2gene.containsKey(current_genekey)) continue;
                String name = this.hashkey2gene.get(current_genekey);
                genesetGenes.put(name, current_genekey);
            }
        }
        return genesetGenes;
    }

    public void filterGenesets() {
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            DataSet current_set = this.datasets.get(k.next());
            if (current_set.getDatasetGenes() == null || current_set.getDatasetGenes().isEmpty()) continue;
            current_set.getSetofgenesets().filterGenesets(current_set.getDatasetGenes());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, GeneSet> getAllGenesets() {
        HashMap<String, GeneSet> all_genesets = new HashMap<String, GeneSet>();
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            HashMap<String, GeneSet> current_genesets = this.datasets.get(k.next()).getSetofgenesets().getGenesets();
            all_genesets.putAll(current_genesets);
        }
        if (this.signatureGenesets != null && !this.signatureGenesets.isEmpty()) {
            all_genesets.putAll(this.signatureGenesets);
        }
        return all_genesets;
    }

    public HashMap<String, GeneSet> getAllGenesetsOfInterest() {
        HashMap<String, GeneSet> all_genesetsOfInterest = new HashMap<String, GeneSet>();
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            HashMap<String, GeneSet> current_genesets = this.datasets.get(k.next()).getGenesetsOfInterest().getGenesets();
            all_genesetsOfInterest.putAll(current_genesets);
        }
        if (this.signatureGenesets != null && !this.signatureGenesets.isEmpty()) {
            all_genesetsOfInterest.putAll(this.signatureGenesets);
        }
        return all_genesetsOfInterest;
    }

    public HashMap<String, GenesetSimilarity> getGenesetSimilarity() {
        return this.genesetSimilarity;
    }

    public void setGenesetSimilarity(HashMap<String, GenesetSimilarity> genesetSimilarity) {
        this.genesetSimilarity = genesetSimilarity;
    }

    public HashMap<String, Integer> getGenes() {
        return this.genes;
    }

    public void setGenes(HashMap<String, Integer> genes) {
        this.genes = genes;
    }

    public int getNumberOfGenes() {
        return this.NumberOfGenes;
    }

    public void setNumberOfGenes(int numberOfGenes) {
        this.NumberOfGenes = numberOfGenes;
    }

    public HashMap<String, DataSet> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(HashMap<String, DataSet> datasets) {
        this.datasets = datasets;
    }

    public void addDataset(String datasetName, DataSet dataset) {
        if (this.datasets != null) {
            this.datasets.put(datasetName, dataset);
        }
        if (dataset == null) {
            this.datasets.put(datasetName, new DataSet(this, datasetName, new DataSetFiles()));
        }
    }

    public DataSet getDataset(String datasetname) {
        if (this.datasets != null && this.datasets.containsKey(datasetname)) {
            return this.datasets.get(datasetname);
        }
        return null;
    }

    public EnrichmentMapParameters getParams() {
        return this.params;
    }

    public void setParams(EnrichmentMapParameters params) {
        this.params = params;
    }

    public HashMap<Integer, String> getHashkey2gene() {
        return this.hashkey2gene;
    }

    public void setHashkey2gene(HashMap<Integer, String> hashkey2gene) {
        this.hashkey2gene = hashkey2gene;
    }

    public HashSet<String> getAllRankNames() {
        HashSet<String> allRankNames = new HashSet<String>();
        for (String current_ds : this.datasets.keySet()) {
            HashSet<String> all_names = this.datasets.get(current_ds).getExpressionSets().getAllRanksNames();
            Iterator<String> l = all_names.iterator();
            while (l.hasNext()) {
                allRankNames.add(l.next() + "-" + current_ds);
            }
        }
        return allRankNames;
    }

    public HashMap<String, Ranking> getAllRanks() {
        HashMap<String, Ranking> allranks = new HashMap<String, Ranking>();
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            allranks.putAll(this.datasets.get(k.next()).getExpressionSets().getRanks());
        }
        return allranks;
    }

    public Ranking getRanksByName(String ranks_name) {
        String ds = "";
        String rank = "";
        if (ranks_name.split("-").length == 2) {
            ds = ranks_name.split("-")[1];
            rank = ranks_name.split("-")[0];
        }
        for (String current_dataset : this.datasets.keySet()) {
            if (!ds.equalsIgnoreCase("") && !rank.equalsIgnoreCase("")) {
                if (!ds.equalsIgnoreCase(current_dataset) || !this.datasets.get(current_dataset).getExpressionSets().getAllRanksNames().contains(rank)) continue;
                return this.datasets.get(current_dataset).getExpressionSets().getRanksByName(rank);
            }
            if (!this.datasets.get(current_dataset).getExpressionSets().getAllRanksNames().contains(ranks_name)) continue;
            return this.datasets.get(current_dataset).getExpressionSets().getRanksByName(ranks_name);
        }
        return null;
    }

    public HashSet<String> getAllGenesetTypes() {
        HashSet<String> all_genesetTypes = new HashSet<String>();
        Iterator<String> k = this.datasets.keySet().iterator();
        while (k.hasNext()) {
            HashSet<String> current_genesets_types = this.datasets.get(k.next()).getSetofgenesets().getGenesetTypes();
            all_genesetTypes.addAll(current_genesets_types);
        }
        return all_genesetTypes;
    }

    public void setSignatureGenesets(HashMap<String, GeneSet> signatureGenesets) {
        this.signatureGenesets = signatureGenesets;
    }

    public HashMap<String, GeneSet> getSignatureGenesets() {
        return this.signatureGenesets;
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    public PostAnalysisParameters getPaParams() {
        if (this.paParams == null) {
            this.paParams = new PostAnalysisParameters(this);
        }
        return this.paParams;
    }
}

