/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class VisualizeEnrichmentMapTask
extends AbstractTask {
    private EnrichmentMap map;
    private CyNetworkFactory networkFactory;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager networkViewManager;
    private CyNetworkViewFactory networkViewFactory;
    private VisualMappingManager visualMappingManager;
    private VisualStyleFactory visualStyleFactory;
    private VisualMappingFunctionFactory vmfFactoryContinuous;
    private VisualMappingFunctionFactory vmfFactoryDiscrete;
    private VisualMappingFunctionFactory vmfFactoryPassthrough;
    private CyLayoutAlgorithmManager layoutManager;
    private TaskMonitor taskMonitor = null;

    public VisualizeEnrichmentMapTask(EnrichmentMap map, CyNetworkFactory networkFactory, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyNetworkViewFactory networkViewFactory, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough, CyLayoutAlgorithmManager layoutManager) {
        this(map);
        this.networkFactory = networkFactory;
        this.networkManager = networkManager;
        this.networkViewManager = networkViewManager;
        this.networkViewFactory = networkViewFactory;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.layoutManager = layoutManager;
    }

    public VisualizeEnrichmentMapTask(EnrichmentMap map) {
        this.map = map;
    }

    public boolean visualizeMap() {
        CyNetwork network = this.networkManager.getNetwork(this.map.getParams().getNetworkID());
        String prefix = this.map.getParams().getAttributePrefix();
        CyNetworkView view = this.networkViewFactory.createNetworkView(network);
        this.networkViewManager.addNetworkView(view);
        String vs_name = prefix + "Enrichment_map_style";
        EnrichmentMapVisualStyle em_vs = new EnrichmentMapVisualStyle(this.map.getParams(), this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough);
        VisualStyle vs = this.visualStyleFactory.createVisualStyle(vs_name);
        em_vs.createVisualStyle(vs, prefix);
        this.visualMappingManager.addVisualStyle(vs);
        this.visualMappingManager.setCurrentVisualStyle(vs);
        vs.apply(view);
        view.updateView();
        CyLayoutAlgorithm layout = this.layoutManager.getLayout("force-directed");
        String layoutAttribute = null;
        this.insertTasksAfterCurrentTask(layout.createTaskIterator(view, layout.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, layoutAttribute));
        ParametersPanel parametersPanel = EnrichmentMapManager.getInstance().getParameterPanel();
        parametersPanel.updatePanel(this.map);
        return true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Creating Network View");
        this.visualizeMap();
    }
}

