/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.brainlib;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.baderlab.csplugins.brainlib.DistanceMatrix;
import org.baderlab.csplugins.brainlib.HierarchicalClusteringResultTree;

public class AvgLinkHierarchicalClustering {
    protected int[][] result = null;
    protected double[] linkDistance = null;
    protected DistanceMatrix distanceMatrix = null;
    protected int nelements = 0;
    protected int[] leafOrder;
    protected boolean optimalLeafOrdering = true;
    protected boolean singleLinkage = false;
    protected ArrayList labelHighlight;
    public static final String LEAF_ORDERING_BARJOSEPH2003 = "Bar-Joseph";
    protected int[][] linkedLeaves = null;
    private final int rightTree = 2;
    private final int leftTree = 1;
    private final double maxAdd = 2.0;

    public AvgLinkHierarchicalClustering(DistanceMatrix distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
        this.nelements = distanceMatrix.getMatrixDimension();
        this.result = new int[this.nelements - 1][2];
        this.linkedLeaves = new int[this.nelements - 1][2];
        this.linkDistance = new double[this.nelements];
        this.leafOrder = new int[this.nelements];
    }

    public String getLabel(int elementIndex) {
        String elementLabel = (String)this.distanceMatrix.getLabels().get(elementIndex);
        return elementLabel;
    }

    private double findClosestPair(int nNodes, Pair pair, DistanceMatrix dmInternal) {
        double distance = dmInternal.getValue(1, 0);
        for (int i = 0; i < nNodes; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(dmInternal.getValue(i, j) < distance)) continue;
                distance = dmInternal.getValue(i, j);
                pair.i = i;
                pair.j = j;
            }
        }
        return distance;
    }

    public void run() {
        int[] number = new int[this.nelements];
        int[] clusterid = new int[this.nelements];
        for (int j = 0; j < this.nelements; ++j) {
            number[j] = 1;
            clusterid[j] = j;
        }
        DistanceMatrix dmInternal = this.distanceMatrix.copy();
        Pair pair = new Pair();
        for (int nNodes = this.nelements; nNodes > 1; --nNodes) {
            pair.i = 1;
            pair.j = 0;
            this.linkDistance[this.nelements - nNodes] = this.findClosestPair(nNodes, pair, dmInternal);
            int isaved = pair.i;
            int jsaved = pair.j;
            int sum = 0;
            this.linkedLeaves[this.nelements - nNodes][0] = pair.i;
            this.linkedLeaves[this.nelements - nNodes][1] = pair.j;
            this.result[this.nelements - nNodes][0] = clusterid[isaved];
            this.result[this.nelements - nNodes][1] = clusterid[jsaved];
            if (!this.singleLinkage) {
                int j;
                sum = number[isaved] + number[jsaved];
                for (j = 0; j < jsaved; ++j) {
                    dmInternal.setValue(jsaved, j, dmInternal.getValue(isaved, j) * (double)number[isaved] + dmInternal.getValue(jsaved, j) * (double)number[jsaved]);
                    dmInternal.setValue(jsaved, j, dmInternal.getValue(jsaved, j) / (double)sum);
                }
                for (j = jsaved + 1; j < isaved; ++j) {
                    dmInternal.setValue(j, jsaved, dmInternal.getValue(isaved, j) * (double)number[isaved] + dmInternal.getValue(j, jsaved) * (double)number[jsaved]);
                    dmInternal.setValue(j, jsaved, dmInternal.getValue(j, jsaved) / (double)sum);
                }
                for (j = isaved + 1; j < nNodes; ++j) {
                    dmInternal.setValue(j, jsaved, dmInternal.getValue(j, isaved) * (double)number[isaved] + dmInternal.getValue(j, jsaved) * (double)number[jsaved]);
                    dmInternal.setValue(j, jsaved, dmInternal.getValue(j, jsaved) / (double)sum);
                }
                for (j = 0; j < isaved; ++j) {
                    dmInternal.setValue(isaved, j, dmInternal.getValue(nNodes - 1, j));
                }
                for (j = isaved + 1; j < nNodes - 1; ++j) {
                    dmInternal.setValue(j, isaved, dmInternal.getValue(nNodes - 1, j));
                }
            }
            number[jsaved] = sum;
            number[isaved] = number[nNodes - 1];
            clusterid[jsaved] = nNodes - this.nelements - 1;
            clusterid[isaved] = clusterid[nNodes - 1];
        }
        dmInternal = null;
        if (this.optimalLeafOrdering) {
            this.orderLeavesBarJoseph2003(this.result, this.distanceMatrix, this.leafOrder);
        } else {
            this.orderLeavesEisenHeuristic(this.leafOrder);
        }
    }

    public void old_run() {
        int[] number = new int[this.nelements];
        int[] clusterid = new int[this.nelements];
        for (int j = 0; j < this.nelements; ++j) {
            number[j] = 1;
            clusterid[j] = j;
        }
        DistanceMatrix dmInternal = this.distanceMatrix.copy();
        Pair pair = new Pair();
        for (int nNodes = this.nelements; nNodes > 1; --nNodes) {
            int j;
            pair.i = 1;
            pair.j = 0;
            this.linkDistance[this.nelements - nNodes] = this.findClosestPair(nNodes, pair, dmInternal);
            int isaved = pair.i;
            int jsaved = pair.j;
            int sum = 0;
            this.result[this.nelements - nNodes][0] = clusterid[isaved];
            this.result[this.nelements - nNodes][1] = clusterid[jsaved];
            sum = number[isaved] + number[jsaved];
            for (j = 0; j < jsaved; ++j) {
                dmInternal.setValue(jsaved, j, dmInternal.getValue(isaved, j) * (double)number[isaved] + dmInternal.getValue(jsaved, j) * (double)number[jsaved]);
                dmInternal.setValue(jsaved, j, dmInternal.getValue(jsaved, j) / (double)sum);
            }
            for (j = jsaved + 1; j < isaved; ++j) {
                dmInternal.setValue(j, jsaved, dmInternal.getValue(isaved, j) * (double)number[isaved] + dmInternal.getValue(j, jsaved) * (double)number[jsaved]);
                dmInternal.setValue(j, jsaved, dmInternal.getValue(j, jsaved) / (double)sum);
            }
            for (j = isaved + 1; j < nNodes; ++j) {
                dmInternal.setValue(j, jsaved, dmInternal.getValue(j, isaved) * (double)number[isaved] + dmInternal.getValue(j, jsaved) * (double)number[jsaved]);
                dmInternal.setValue(j, jsaved, dmInternal.getValue(j, jsaved) / (double)sum);
            }
            for (j = 0; j < isaved; ++j) {
                dmInternal.setValue(isaved, j, dmInternal.getValue(nNodes - 1, j));
            }
            for (j = isaved + 1; j < nNodes - 1; ++j) {
                dmInternal.setValue(j, isaved, dmInternal.getValue(nNodes - 1, j));
            }
            number[jsaved] = sum;
            number[isaved] = number[nNodes - 1];
            clusterid[jsaved] = nNodes - this.nelements - 1;
            clusterid[isaved] = clusterid[nNodes - 1];
        }
        dmInternal = null;
        if (this.optimalLeafOrdering) {
            this.orderLeavesBarJoseph2003(this.result, this.distanceMatrix, this.leafOrder);
        } else {
            this.orderLeavesEisenHeuristic(this.leafOrder);
        }
    }

    public int[] cutTree(int nclusters) {
        int k;
        int i;
        int icluster = 0;
        int n = this.nelements - nclusters;
        int[] clusterid = new int[this.nelements];
        boolean flag = false;
        if (nclusters > this.nelements || nclusters < 1) {
            flag = true;
        }
        for (i = 0; i < this.nelements - 1; ++i) {
            if (this.result[i][0] < this.nelements && this.result[i][0] >= -i && this.result[i][1] < this.nelements && this.result[i][1] >= -i) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (i = 0; i < this.nelements; ++i) {
                clusterid[i] = -1;
            }
            return null;
        }
        for (i = this.nelements - 2; i >= n; --i) {
            k = this.result[i][0];
            if (k >= 0) {
                clusterid[k] = icluster++;
            }
            if ((k = this.result[i][1]) < 0) continue;
            clusterid[k] = icluster++;
        }
        int[] nodeid = new int[n];
        for (i = 0; i < n; ++i) {
            nodeid[i] = -1;
        }
        for (i = n - 1; i >= 0; --i) {
            int j;
            if (nodeid[i] < 0) {
                nodeid[i] = j = icluster++;
            } else {
                j = nodeid[i];
            }
            k = this.result[i][0];
            if (k < 0) {
                nodeid[-k - 1] = j;
            } else {
                clusterid[k] = j;
            }
            k = this.result[i][1];
            if (k < 0) {
                nodeid[-k - 1] = j;
                continue;
            }
            clusterid[k] = j;
        }
        return clusterid;
    }

    public boolean isOptimalLeafOrdering() {
        return this.optimalLeafOrdering;
    }

    public void setOptimalLeafOrdering(boolean optimalLeafOrdering) {
        this.optimalLeafOrdering = optimalLeafOrdering;
    }

    public void setLeafOrderingMethod(String leafOrderingMethod) {
        this.optimalLeafOrdering = leafOrderingMethod == LEAF_ORDERING_BARJOSEPH2003;
    }

    public boolean isSingleLinkage() {
        return this.singleLinkage;
    }

    public void setSingleLinkage(boolean flag) {
        this.singleLinkage = flag;
    }

    public HierarchicalClusteringResultTree getResult() {
        return this.convertResultTreeToTreeClass(this.result, this.linkDistance, this.leafOrder);
    }

    private HierarchicalClusteringResultTree convertResultTreeToTreeClass(int[][] resultTree, double[] linkDistance, int[] leafOrder) {
        ArrayList<Integer> leafOrderList = new ArrayList<Integer>();
        for (int i = 0; i < leafOrder.length; ++i) {
            int index = leafOrder[i];
            leafOrderList.add(new Integer(index));
        }
        ArrayList clusteredElementLabels = this.distanceMatrix.getLabels();
        HierarchicalClusteringResultTree t = null;
        HierarchicalClusteringResultTree[] internalNodeList = new HierarchicalClusteringResultTree[resultTree.length + 1];
        for (int i = 0; i < resultTree.length; ++i) {
            HierarchicalClusteringResultTree tleft = null;
            HierarchicalClusteringResultTree tright = null;
            tleft = resultTree[i][0] >= 0 ? new HierarchicalClusteringResultTree(resultTree[i][0], leafOrderList.indexOf(new Integer(resultTree[i][0])), (String)clusteredElementLabels.get(resultTree[i][0])) : internalNodeList[-resultTree[i][0]];
            tright = resultTree[i][1] >= 0 ? new HierarchicalClusteringResultTree(resultTree[i][1], leafOrderList.indexOf(new Integer(resultTree[i][1])), (String)clusteredElementLabels.get(resultTree[i][1])) : internalNodeList[-resultTree[i][1]];
            HierarchicalClusteringResultTree leftLeaf = new HierarchicalClusteringResultTree(this.linkedLeaves[i][0], leafOrderList.indexOf(new Integer(this.linkedLeaves[i][0])), (String)clusteredElementLabels.get(this.linkedLeaves[i][0]));
            HierarchicalClusteringResultTree rightLeaf = new HierarchicalClusteringResultTree(this.linkedLeaves[i][1], leafOrderList.indexOf(new Integer(this.linkedLeaves[i][1])), (String)clusteredElementLabels.get(this.linkedLeaves[i][1]));
            HierarchicalClusteringResultTree hierarchicalClusteringResultTree = new HierarchicalClusteringResultTree(tleft, tright, i + 1, linkDistance[i], leftLeaf, rightLeaf);
            internalNodeList[i + 1] = hierarchicalClusteringResultTree;
            t = hierarchicalClusteringResultTree;
        }
        return t;
    }

    public int getNelements() {
        return this.nelements;
    }

    public double getMaxDistance() {
        double maxDistance = 0.0;
        for (int i = 0; i < this.linkDistance.length; ++i) {
            maxDistance = Math.max(maxDistance, this.linkDistance[i]);
        }
        return maxDistance;
    }

    public int[] getLeafOrder() {
        return this.leafOrder;
    }

    private void treeSort(double[] order, double[] nodeorder, int[] nodecounts, int[][] NodeElement, int[] leafOrder) {
        int i;
        int nNodes = this.nelements - 1;
        double[] neworder = new double[this.nelements];
        int[] clusterids = new int[this.nelements];
        for (i = 0; i < this.nelements; ++i) {
            clusterids[i] = i;
        }
        for (i = 0; i < nNodes; ++i) {
            int clusterid;
            int j;
            double increase;
            int count2;
            int i1 = NodeElement[i][0];
            int i2 = NodeElement[i][1];
            double order1 = i1 < 0 ? nodeorder[-i1 - 1] : order[i1];
            double order2 = i2 < 0 ? nodeorder[-i2 - 1] : order[i2];
            int count1 = i1 < 0 ? nodecounts[-i1 - 1] : 1;
            int n = count2 = i2 < 0 ? nodecounts[-i2 - 1] : 1;
            if (i1 < i2) {
                increase = order1 < order2 ? (double)count1 : (double)count2;
                for (j = 0; j < this.nelements; ++j) {
                    clusterid = clusterids[j];
                    if (clusterid == i1 && order1 >= order2) {
                        int n2 = j;
                        neworder[n2] = neworder[n2] + increase;
                    }
                    if (clusterid == i2 && order1 < order2) {
                        int n3 = j;
                        neworder[n3] = neworder[n3] + increase;
                    }
                    if (clusterid != i1 && clusterid != i2) continue;
                    clusterids[j] = -i - 1;
                }
                continue;
            }
            increase = order1 <= order2 ? (double)count1 : (double)count2;
            for (j = 0; j < this.nelements; ++j) {
                clusterid = clusterids[j];
                if (clusterid == i1 && order1 > order2) {
                    int n4 = j;
                    neworder[n4] = neworder[n4] + increase;
                }
                if (clusterid == i2 && order1 <= order2) {
                    int n5 = j;
                    neworder[n5] = neworder[n5] + increase;
                }
                if (clusterid != i1 && clusterid != i2) continue;
                clusterids[j] = -i - 1;
            }
        }
        this.sort(neworder, leafOrder);
    }

    private void sort(double[] data, int[] index) {
        class DataIndexPair
        implements Comparable {
            public double data;
            public int index;

            public DataIndexPair(double data, int index) {
                this.data = data;
                this.index = index;
            }

            public int compareTo(Object o) {
                DataIndexPair that = (DataIndexPair)o;
                return (int)(this.data - that.data);
            }
        }
        TreeSet<DataIndexPair> indexValue = new TreeSet<DataIndexPair>();
        for (int i = 0; i < data.length; ++i) {
            DataIndexPair dataIndexDataIndexPair = new DataIndexPair(data[i], i);
            indexValue.add(dataIndexDataIndexPair);
        }
        Iterator values = indexValue.iterator();
        int i = 0;
        while (values.hasNext()) {
            DataIndexPair dataIndexPair = (DataIndexPair)values.next();
            index[i] = dataIndexPair.index;
            ++i;
        }
    }

    private void orderLeavesEisenHeuristic(int[] leafOrder) {
        int i;
        int nNodes = this.nelements - 1;
        double[] nodeorder = new double[nNodes];
        int[] nodecounts = new int[nNodes];
        double[] origOrder = new double[this.nelements];
        for (i = 0; i < origOrder.length; ++i) {
            origOrder[i] = i;
        }
        for (i = 0; i < nNodes; ++i) {
            int counts2;
            double order2;
            int counts1;
            double order1;
            int min1 = this.result[i][0];
            int min2 = this.result[i][1];
            if (min1 < 0) {
                int index1 = -min1 - 1;
                order1 = nodeorder[index1];
                counts1 = nodecounts[index1];
                this.linkDistance[i] = Math.max(this.linkDistance[i], this.linkDistance[index1]);
            } else {
                order1 = origOrder[min1];
                counts1 = 1;
            }
            if (min2 < 0) {
                int index2 = -min2 - 1;
                order2 = nodeorder[index2];
                counts2 = nodecounts[index2];
                this.linkDistance[i] = Math.max(this.linkDistance[i], this.linkDistance[index2]);
            } else {
                order2 = origOrder[min2];
                counts2 = 1;
            }
            nodecounts[i] = counts1 + counts2;
            nodeorder[i] = ((double)counts1 * order1 + (double)counts2 * order2) / (double)(counts1 + counts2);
        }
        for (i = 0; i < this.nelements; ++i) {
            leafOrder[i] = i;
        }
        this.treeSort(origOrder, nodeorder, nodecounts, this.result, leafOrder);
    }

    private void orderLeavesBarJoseph2003(int[][] resultTree, DistanceMatrix dm, int[] leafOrder) {
        double[][] mat = new double[dm.getMatrixDimension() + 1][dm.getMatrixDimension() + 1];
        for (int i = 1; i < dm.getMatrixDimension() + 1; ++i) {
            for (int j = 1; j < dm.getMatrixDimension() + 1; ++j) {
                mat[i][j] = dm.getValue(i - 1, j - 1) - 1.0;
            }
        }
        Tree t = this.convertResultTreeToTreeClass(resultTree, mat);
        Object[] ret = t.returnOrder();
        int[] arr = (int[])ret[0];
        for (int i = 0; i < this.nelements; ++i) {
            leafOrder[i] = arr[i] - 1;
        }
    }

    private Tree convertResultTreeToTreeClass(int[][] resultTree, double[][] mat) {
        Tree t = null;
        Tree[] tlist = new Tree[this.nelements];
        for (int i = 0; i < this.nelements - 1; ++i) {
            Tree tleft = null;
            Tree tright = null;
            tleft = resultTree[i][0] >= 0 ? new Tree(resultTree[i][0] + 1, mat) : tlist[-resultTree[i][0]];
            tright = resultTree[i][1] >= 0 ? new Tree(resultTree[i][1] + 1, mat) : tlist[-resultTree[i][1]];
            Tree tree = new Tree(tright, tleft, i + 1);
            tlist[i + 1] = tree;
            t = tree;
        }
        return t;
    }

    private Tree barJosephClustering(double[][] m) {
        int j;
        int i;
        int num = this.nelements;
        double[][] newM = new double[num + 1][];
        Tree[] allTrees = new Tree[num + 1];
        for (i = 1; i < num + 1; ++i) {
            newM[i] = new double[num + 1];
            for (j = 1; j < num + 1; ++j) {
                newM[i][j] = m[i][j];
            }
        }
        for (i = 1; i < num + 1; ++i) {
            allTrees[i] = new Tree(i, m);
        }
        int r = 0;
        int l = 0;
        for (i = 1; i < num; ++i) {
            double max = Double.MIN_VALUE;
            for (int k = 1; k < num; ++k) {
                if (allTrees[k] == null) continue;
                for (j = k + 1; j < num + 1; ++j) {
                    if (allTrees[j] == null || !(max < -1.0 * newM[j][k])) continue;
                    max = -1.0 * newM[j][k];
                    l = k;
                    r = j;
                }
            }
            double rSize = allTrees[r].giveNumLeafs();
            double lSize = allTrees[l].giveNumLeafs();
            System.out.print("NODE" + i + "X" + '\t');
            if (allTrees[l].isLeaf()) {
                System.out.print("GENE" + allTrees[l].giveIndex() + "X\t");
            } else {
                System.out.print("NODE" + allTrees[l].giveIndex() + "X\t");
            }
            if (allTrees[r].isLeaf()) {
                System.out.print("GENE" + allTrees[r].giveIndex() + "X\t");
            } else {
                System.out.print("NODE" + allTrees[r].giveIndex() + "X\t");
            }
            System.out.println(max);
            Tree temp = allTrees[l];
            allTrees[l] = null;
            allTrees[l] = new Tree(temp, allTrees[r], i);
            allTrees[r] = null;
            for (j = 1; j < num + 1; ++j) {
                if (allTrees[j] == null || j == l) continue;
                newM[j][l] = (lSize * newM[j][l] + rSize * newM[j][r]) / (lSize + rSize);
                newM[l][j] = newM[j][l];
            }
        }
        Tree res = null;
        for (i = 1; i < num + 1; ++i) {
            if (allTrees[i] == null) continue;
            res = allTrees[i];
        }
        return res;
    }

    public void writeResultsToCytoscapeFormat(File sifFileName, File edgeAttributeFileName, double distanceCutoff) throws IOException {
        ArrayList labels = this.distanceMatrix.getLabels();
        BufferedWriter brSIF = new BufferedWriter(new FileWriter(sifFileName));
        BufferedWriter brEA = new BufferedWriter(new FileWriter(edgeAttributeFileName));
        brEA.write("ClusterDistance");
        brEA.newLine();
        for (int i = 0; i < this.nelements; ++i) {
            for (int j = i; j < this.nelements; ++j) {
                if (!(this.distanceMatrix.getValue(i, j) <= distanceCutoff) || this.distanceMatrix.getValue(i, j) == 0.0) continue;
                brSIF.write(labels.get(i) + "\tcl\t" + labels.get(j));
                brSIF.newLine();
                brEA.write(labels.get(i) + " (cl) " + labels.get(j) + " = " + this.distanceMatrix.getValue(i, j));
                brEA.newLine();
            }
        }
        brSIF.close();
        brEA.close();
    }

    public String writeResultsToGTRFormat() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < this.result.length; ++i) {
            sb.append("NODE" + (i + 1) + "X" + "\t");
            sb.append((this.result[i][0] >= 0 ? "GENE" + Math.abs(this.result[i][0]) : "NODE" + Math.abs(this.result[i][0])) + "X" + "\t");
            sb.append((this.result[i][1] >= 0 ? "GENE" + Math.abs(this.result[i][1]) : "NODE" + Math.abs(this.result[i][1])) + "X" + "\t");
            sb.append(1.0 - this.linkDistance[i] + lineSep);
        }
        return sb.toString();
    }

    public void setLabelHighlightInCDTOutput(ArrayList labelsToHighlight, String color) {
        if (this.labelHighlight == null) {
            this.labelHighlight = new ArrayList();
        }
        LabelColorPair lcp = new LabelColorPair(color, labelsToHighlight);
        this.labelHighlight.add(lcp);
    }

    public String toCDTString() {
        int indexi;
        int i;
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        if (this.labelHighlight != null) {
            sb.append("GID\tUNIQID\tNAME\tBGCOLOR\tGWEIGHT");
        } else {
            sb.append("GID\tUNIQID\tNAME\tGWEIGHT");
        }
        ArrayList labels = this.distanceMatrix.getLabels();
        for (i = 0; i < labels.size(); ++i) {
            indexi = this.leafOrder[i];
            sb.append("\t" + (String)labels.get(indexi));
        }
        sb.append(lineSep);
        sb.append("EWEIGHT\t\t\t");
        for (i = 0; i < this.nelements; ++i) {
            sb.append("\t1.000000");
        }
        sb.append(lineSep);
        for (i = 0; i < this.nelements; ++i) {
            indexi = this.leafOrder[i];
            sb.append("GENE" + indexi + "X\t" + labels.get(indexi) + "\t" + labels.get(indexi) + "\t");
            if (this.labelHighlight != null) {
                boolean found = false;
                for (int j = 0; j < this.labelHighlight.size(); ++j) {
                    LabelColorPair labelColorPair = (LabelColorPair)this.labelHighlight.get(j);
                    ArrayList labelsToHighlight = labelColorPair.getLabels();
                    if (!labelsToHighlight.contains(labels.get(indexi))) continue;
                    found = true;
                    sb.append(labelColorPair.getColor());
                    break;
                }
                if (!found) {
                    sb.append("#FFFFFF");
                }
            }
            sb.append("\t1.000000");
            for (int j = 0; j < this.nelements; ++j) {
                int indexj = this.leafOrder[j];
                sb.append("\t" + this.distanceMatrix.getValue(indexi, indexj));
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }

    private class LabelColorPair {
        private String color;
        private ArrayList labels;

        public LabelColorPair(String color, ArrayList labels) {
            this.color = color;
            this.labels = labels;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public ArrayList getLabels() {
            return this.labels;
        }

        public void setLabels(ArrayList labels) {
            this.labels = labels;
        }
    }

    private class Tree {
        private Tree left;
        private Tree right;
        private int numLeafs;
        private Leaf[] allLeafs;
        private int nodeNum;
        private double[][] mat;

        public Tree(int index, double[][] m) {
            Leaf myLeaf;
            this.mat = m;
            this.nodeNum = index;
            this.allLeafs = new Leaf[1];
            this.allLeafs[0] = myLeaf = new Leaf(index, this.mat);
            this.numLeafs = 1;
            this.right = null;
            this.left = null;
        }

        public Tree(Tree t1, Tree t2, int nNum) {
            int i;
            this.nodeNum = nNum;
            this.mat = t1.giveMat();
            int n1 = t1.giveNumLeafs();
            int n2 = t2.giveNumLeafs();
            this.numLeafs = n1 + n2;
            this.allLeafs = new Leaf[this.numLeafs];
            Leaf[] l = t1.giveLeafs();
            for (i = 0; i < n1; ++i) {
                this.allLeafs[i] = l[i];
            }
            l = t2.giveLeafs();
            for (i = 0; i < n2; ++i) {
                this.allLeafs[n1 + i] = l[i];
            }
            this.left = t1;
            this.right = t2;
        }

        int compDist() {
            int j;
            if (this.numLeafs == 1) {
                return 0;
            }
            this.left.compDist();
            this.right.compDist();
            int n1 = this.left.giveNumLeafs();
            int n2 = this.right.giveNumLeafs();
            if (n1 + n2 == AvgLinkHierarchicalClustering.this.nelements) {
                return this.lastTree(n1, n2);
            }
            if (n1 > 1 && n2 > 1) {
                return this.compDist(n1, n2);
            }
            Leaf[] l1 = this.left.giveLeafs();
            Leaf[] l2 = this.right.giveLeafs();
            for (j = 0; j < n2; ++j) {
                l2[j].initNewSize(n1);
            }
            for (int i = 0; i < n1; ++i) {
                l1[i].initNewSize(n2);
                l1[i].addToNew(l2, l2, n1, n2, n2, n2, Double.MIN_VALUE);
                l1[i].replace();
            }
            for (j = 0; j < n2; ++j) {
                l2[j].replace();
            }
            return 0;
        }

        int lastTree(int n1, int n2) {
            Leaf[] l1 = this.left.giveLeafs();
            Leaf[] l2 = this.right.giveLeafs();
            int res = l1[0].findLast(l1, l2, n1, n2);
            return res;
        }

        int compDist(int tot1, int tot2) {
            int j4;
            int j3;
            int j;
            int i;
            Tree t1 = this.left;
            Tree t2 = this.right;
            Tree t1l = t1.left;
            Tree t1r = t1.right;
            Tree t2l = t2.left;
            Tree t2r = t2.right;
            int n1 = t1l.giveNumLeafs();
            int n2 = t1r.giveNumLeafs();
            int n3 = t2l.giveNumLeafs();
            int n4 = t2r.giveNumLeafs();
            Leaf[] l1 = t1l.giveLeafs();
            Leaf[] l2 = t1r.giveLeafs();
            Leaf[] l3 = t2l.giveLeafs();
            Leaf[] l4 = t2r.giveLeafs();
            Leaf[] c2 = t2.giveLeafs();
            double mint1rt2r = 1.0;
            double mint1rt2l = 1.0;
            double mint1lt2r = 1.0;
            double mint1lt2l = 1.0;
            for (i = 0; i < n1; ++i) {
                int i1 = l1[i].giveIndex();
                for (j = 0; j < n3; ++j) {
                    j3 = l3[j].giveIndex();
                    if (!(this.mat[i1][j3] < mint1rt2r)) continue;
                    mint1rt2r = this.mat[i1][j3];
                }
                for (j = 0; j < n4; ++j) {
                    j4 = l4[j].giveIndex();
                    if (!(this.mat[i1][j4] < mint1rt2l)) continue;
                    mint1rt2l = this.mat[i1][j4];
                }
            }
            for (i = 0; i < n2; ++i) {
                int i2 = l2[i].giveIndex();
                for (j = 0; j < n3; ++j) {
                    j3 = l3[j].giveIndex();
                    if (!(this.mat[i2][j3] < mint1lt2r)) continue;
                    mint1lt2r = this.mat[i2][j3];
                }
                for (j = 0; j < n4; ++j) {
                    j4 = l4[j].giveIndex();
                    if (!(this.mat[i2][j4] < mint1lt2l)) continue;
                    mint1lt2l = this.mat[i2][j4];
                }
            }
            for (j = 0; j < tot2; ++j) {
                c2[j].initNewSize(tot1);
            }
            for (i = 0; i < n1; ++i) {
                l1[i].initNewSize(tot2);
                l1[i].addToNew(l4, l3, tot1, tot2, n4, n3, mint1lt2l);
                l1[i].addToNew(l3, l4, tot1, tot2, n3, n4, mint1lt2r);
                l1[i].replace();
            }
            for (i = 0; i < n2; ++i) {
                l2[i].initNewSize(tot2);
                l2[i].addToNew(l4, l3, tot1, tot2, n4, n3, mint1rt2l);
                l2[i].addToNew(l3, l4, tot1, tot2, n3, n4, mint1rt2r);
                l2[i].replace();
            }
            for (j = 0; j < tot2; ++j) {
                c2[j].replace();
            }
            return 0;
        }

        Object[] returnOrder() {
            int start = this.compDist();
            LeafDist[] myDist = this.allLeafs[start].giveList();
            Double bestDist = new Double(myDist[0].dist);
            LeafPair best = myDist[0].best;
            int[] res = new int[this.numLeafs];
            this.compTree(best.preLeft, res, 0, best.n1 - 1, 1);
            this.compTree(best.preRight, res, best.n1, this.numLeafs - 1, 2);
            Object[] ret = new Object[]{res, bestDist};
            return ret;
        }

        void compTree(LeafPair best, int[] res, int start, int last, int l) {
            if (start == last) {
                res[start] = best.leftLeaf;
                return;
            }
            if (l == 1) {
                this.compTree(best.preLeft, res, start, start + best.n1 - 1, 1);
                this.compTree(best.preRight, res, start + best.n1, last, 2);
            }
            if (l == 2) {
                this.compTree(best.preLeft, res, start + best.n2, last, 2);
                this.compTree(best.preRight, res, start, start + best.n2 - 1, 1);
            }
        }

        double curDist(double[][] m) {
            if (this.numLeafs == 1) {
                return 0.0;
            }
            double d1 = this.left.curDist(m);
            double d2 = this.right.curDist(m);
            int lCorner = this.left.findRight();
            int rCorner = this.right.findLeft();
            return d1 + d2 + m[lCorner][rCorner];
        }

        int findRight() {
            if (this.numLeafs == 1) {
                return this.allLeafs[0].giveIndex();
            }
            return this.right.findRight();
        }

        int findLeft() {
            if (this.numLeafs == 1) {
                return this.allLeafs[0].giveIndex();
            }
            return this.left.findLeft();
        }

        int[] initOrder() {
            int[] res = new int[this.numLeafs + 1];
            this.fillArray(res, 0, this.numLeafs - 1);
            return res;
        }

        void fillArray(int[] array, int s, int l) {
            if (this.numLeafs == 1) {
                array[s] = this.allLeafs[0].giveIndex();
                return;
            }
            int n1 = this.left.giveNumLeafs();
            this.left.fillArray(array, s, s + n1 - 1);
            this.right.fillArray(array, s + n1, l);
        }

        boolean isLeaf() {
            return this.numLeafs == 1;
        }

        int giveIndex() {
            return this.nodeNum;
        }

        double[][] giveMat() {
            return this.mat;
        }

        int giveNumLeafs() {
            return this.numLeafs;
        }

        Leaf[] giveLeafs() {
            return this.allLeafs;
        }
    }

    private class Leaf {
        private int index;
        private LeafDist[] curDist;
        private LeafDist[] newDist;
        private double[][] distMat;
        private int listSize;
        private int newSize;
        public double bestNew;

        void setSize(int size) {
            this.listSize = size;
        }

        int giveSize() {
            return this.listSize;
        }

        LeafDist[] giveList() {
            return this.curDist;
        }

        void initNewSize(int nSize) {
            this.newDist = new LeafDist[nSize];
        }

        void initNewDist() {
            this.newDist = null;
        }

        int giveIndex() {
            return this.index;
        }

        public Leaf(int num, double[][] mat) {
            this.index = num;
            this.distMat = mat;
            LeafPair oneLeaf = new LeafPair(this.index, -1, null, null, 1, 0);
            this.curDist = new LeafDist[1];
            this.curDist[0] = new LeafDist(this.index, 0.0, oneLeaf);
            this.listSize = 1;
            this.newDist = null;
            this.newSize = 0;
            this.bestNew = Double.MAX_VALUE;
        }

        void replace() {
            int i;
            for (i = 0; i < this.listSize; ++i) {
                this.curDist[i] = null;
            }
            this.curDist = null;
            this.listSize = this.newSize;
            this.bestNew += 2.0;
            this.curDist = new LeafDist[this.listSize];
            for (i = 0; i < this.newSize; ++i) {
                this.curDist[i] = this.newDist[i];
            }
            this.newDist = null;
            Arrays.sort(this.curDist);
            this.newSize = 0;
            this.bestNew = Double.MAX_VALUE;
        }

        void addToNew(Leaf[] corner1, Leaf[] corner2, int n1, int n2, int c1, int c2, double max1) {
            double curVal;
            double bestPos;
            int i;
            int fromIndex;
            int j;
            double[] bestC = new double[AvgLinkHierarchicalClustering.this.nelements + 1];
            int[] bForC = new int[AvgLinkHierarchicalClustering.this.nelements + 1];
            int cForD = 0;
            int dPlace = 0;
            double maxAC = Double.MAX_VALUE;
            for (j = 0; j < c1; ++j) {
                fromIndex = corner1[j].giveIndex();
                bestC[fromIndex] = Double.MAX_VALUE;
                for (i = 0; i < this.listSize; ++i) {
                    bestPos = this.curDist[i].dist + max1;
                    if (bestPos > bestC[fromIndex]) {
                        i = this.listSize;
                        continue;
                    }
                    curVal = this.curDist[i].dist + this.distMat[this.curDist[i].n][fromIndex];
                    if (!(curVal < bestC[fromIndex])) continue;
                    bestC[fromIndex] = curVal;
                    bForC[fromIndex] = i;
                }
                if (!(bestC[fromIndex] < maxAC)) continue;
                maxAC = bestC[fromIndex];
            }
            for (j = 0; j < c2; ++j) {
                double bestD = Double.MAX_VALUE;
                Leaf curLeaf = corner2[j];
                int fromNum = curLeaf.giveSize();
                fromIndex = curLeaf.giveIndex();
                LeafDist[] fDist = curLeaf.giveList();
                for (i = 0; i < fromNum; ++i) {
                    bestPos = curLeaf.curDist[i].dist + maxAC;
                    if (bestPos > bestD) {
                        i = fromNum;
                        continue;
                    }
                    curVal = bestC[fDist[i].n] + curLeaf.curDist[i].dist;
                    if (!(curVal < bestD)) continue;
                    bestD = curVal;
                    cForD = curLeaf.curDist[i].n;
                    dPlace = i;
                }
                LeafPair newPair = new LeafPair(this.index, fromIndex, this.curDist[bForC[cForD]].best, fDist[dPlace].best, n1, n2);
                this.newDist[this.newSize] = new LeafDist(fromIndex, bestD, newPair);
                ++this.newSize;
                LeafPair cornerPair = new LeafPair(fromIndex, this.index, fDist[dPlace].best, this.curDist[bForC[cForD]].best, n2, n1);
                curLeaf.addNewDist(this.index, bestD, cornerPair);
            }
            bForC = null;
            bestC = null;
        }

        void addNewDist(int n, double dist, LeafPair p) {
            this.newDist[this.newSize] = new LeafDist(n, dist, p);
            ++this.newSize;
        }

        int findLast(Leaf[] corner1, Leaf[] corner2, int n1, int n2) {
            int size;
            LeafDist[] myDist;
            int j;
            int i;
            double best = Double.MAX_VALUE;
            int myInd = 0;
            int bestIndl = 0;
            int bestIndr = 0;
            int mBestl = 0;
            int mBestr = 0;
            LeafPair lpre = null;
            LeafPair rpre = null;
            LeafDist[][] fDist = new LeafDist[n2][];
            for (i = 0; i < n2; ++i) {
                fDist[i] = corner2[i].giveList();
            }
            for (j = 0; j < n1; ++j) {
                Leaf curLeaf = corner1[j];
                myDist = curLeaf.giveList();
                double myVal = myDist[0].dist;
                myInd = curLeaf.giveIndex();
                for (i = 0; i < n2; ++i) {
                    double curVal = myVal + fDist[i][0].dist + this.distMat[myInd][corner2[i].giveIndex()];
                    if (!(best > curVal)) continue;
                    best = curVal;
                    bestIndl = myDist[0].n;
                    bestIndr = fDist[i][0].n;
                    mBestl = myInd;
                    mBestr = corner2[i].giveIndex();
                }
            }
            int place = 0;
            for (i = 0; i < n2; ++i) {
                if (corner2[i].giveIndex() != bestIndr) continue;
                size = corner2[i].giveSize();
                for (j = 0; j < size; ++j) {
                    if (fDist[i][j].n != mBestr) continue;
                    rpre = fDist[i][j].best;
                    j = size;
                }
                i = n2;
            }
            for (i = 0; i < n1; ++i) {
                if (corner1[i].giveIndex() != bestIndl) continue;
                size = corner1[i].giveSize();
                myDist = corner1[i].giveList();
                for (j = 0; j < size; ++j) {
                    if (myDist[j].n != mBestl) continue;
                    lpre = myDist[j].best;
                    j = size;
                }
                LeafPair newPair = new LeafPair(bestIndl, bestIndr, lpre, rpre, n1, n2);
                place = i;
                corner1[i].initNewSize(1);
                corner1[i].addNewDist(bestIndr, best, newPair);
                corner1[i].replace();
                i = n1;
            }
            fDist = null;
            return place;
        }
    }

    private class LeafDist
    implements Comparable {
        public int n;
        public double dist;
        public LeafPair best;

        public LeafDist(int to, double d, LeafPair p) {
            this.n = to;
            this.dist = d;
            this.best = p;
        }

        public int compareTo(Object o) {
            LeafDist ld = (LeafDist)o;
            return (int)(this.dist - ld.dist);
        }
    }

    private class LeafPair {
        private int leftLeaf;
        private int rightLeaf;
        private LeafPair preLeft;
        private LeafPair preRight;
        private int n1;
        private int n2;

        public LeafPair(int l, int r, LeafPair pl, LeafPair pr, int t1, int t2) {
            this.leftLeaf = l;
            this.rightLeaf = r;
            this.preLeft = pl;
            this.preRight = pr;
            this.n1 = t1;
            this.n2 = t2;
        }
    }

    private class Pair {
        public int i = 0;
        public int j = 0;
    }
}

