/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;
import org.baderlab.csplugins.enrichmentmap.parsers.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.InitializeGenesetsOfInterestTask;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;

public class EnrichmentMapSessionAction
implements SessionAboutToBeSavedListener,
SessionLoadedListener {
    private CyNetworkManager cyNetworkManager;
    private CySessionManager cySessionManager;
    private CyApplicationManager cyApplicationManager;
    private StreamUtil streamUtil;
    private static final String appName = "EnrichmentMap";

    public EnrichmentMapSessionAction(CyNetworkManager cyNetworkManager, CySessionManager cySessionManager, CyApplicationManager cyApplicationManager, StreamUtil streamUtil) {
        this.cyNetworkManager = cyNetworkManager;
        this.cySessionManager = cySessionManager;
        this.cyApplicationManager = cyApplicationManager;
        this.streamUtil = streamUtil;
    }

    public void handleEvent(SessionLoadedEvent e) {
        if (e.getLoadedSession().getAppFileListMap() == null || e.getLoadedSession().getAppFileListMap().size() == 0) {
            return;
        }
        List pStateFileList = (List)e.getLoadedSession().getAppFileListMap().get(appName);
        try {
            CyNetwork net;
            File prop_file;
            int i;
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = (File)pStateFileList.get(i);
                if (!prop_file.getName().contains(".props")) continue;
                InputStream reader = this.streamUtil.getInputStream(prop_file.getAbsolutePath());
                String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
                EnrichmentMapParameters params = new EnrichmentMapParameters(fullText, this.cySessionManager, this.streamUtil, this.cyApplicationManager);
                EnrichmentMap em = new EnrichmentMap(params);
                String param_name = em.getName();
                String props_name = prop_file.getName().split("\\.")[0];
                String name = param_name;
                if (!props_name.equalsIgnoreCase(param_name)) {
                    name = props_name;
                    em.setName(name);
                }
                HashMap<String, DataSetFiles> files = params.getFiles();
                for (String current_dataset : params.getFiles().keySet()) {
                    em.addDataset(current_dataset, new DataSet(em, current_dataset, files.get(current_dataset)));
                }
                EnrichmentMapManager.getInstance().registerNetwork(this.getNetworkByName(name), em);
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                Ranking new_ranking;
                SetOfEnrichmentResults enrichments;
                InputStream reader;
                String fullText;
                EnrichmentMap em;
                prop_file = (File)pStateFileList.get(i);
                FileNameParts parts = this.ParseFileName(prop_file);
                if (parts == null || prop_file.getName().contains(".props")) continue;
                net = this.getNetworkByName(parts.name);
                EnrichmentMap enrichmentMap = em = net != null ? EnrichmentMapManager.getInstance().getMap(net.getSUID()) : null;
                if (em == null) {
                    System.out.println("network for file" + prop_file.getName() + " does not exist.");
                    continue;
                }
                if (prop_file.getName().contains(".props") || prop_file.getName().contains(".expression1.txt") || prop_file.getName().contains(".expression2.txt")) continue;
                EnrichmentMapParameters params = em.getParams();
                HashMap<String, String> props = params.getProps();
                if (parts.dataset != null && em.getDataset(parts.dataset) == null && !parts.dataset.equalsIgnoreCase("signature")) {
                    em.addDataset(parts.dataset, new DataSet(em, parts.name, params.getFiles().get(parts.dataset)));
                }
                if (parts.type == null) {
                    System.out.println("Sorry, unable to determine the type of the file: " + prop_file.getName());
                }
                if ((fullText = new Scanner(reader = this.streamUtil.getInputStream(prop_file.getAbsolutePath()), "UTF-8").useDelimiter("\\A").next()) == null || fullText.equalsIgnoreCase("")) continue;
                if (prop_file.getName().contains(".gmt")) {
                    SetOfGeneSets gs;
                    if (prop_file.getName().contains(".signature.gmt")) {
                        em.setSignatureGenesets(params.repopulateHashmap(fullText, 1));
                    } else if (prop_file.getName().contains(".set2.gmt")) {
                        if (em.getAllGenesets().containsKey("Dataset 2")) {
                            gs = new SetOfGeneSets("Dataset 2", props);
                            gs.setGenesets(params.repopulateHashmap(fullText, 1));
                        }
                    } else {
                        gs = new SetOfGeneSets(parts.dataset, props);
                        gs.setGenesets(params.repopulateHashmap(fullText, 1));
                        em.getDatasets().get(parts.dataset).setSetofgenesets(gs);
                    }
                }
                if (prop_file.getName().contains(".genes.txt")) {
                    HashMap genes = params.repopulateHashmap(fullText, 2);
                    em.setGenes(genes);
                    if (genes != null && !genes.isEmpty()) {
                        em.setNumberOfGenes(Math.max(em.getNumberOfGenes(), (Integer)Collections.max(genes.values()) + 1));
                    }
                }
                if (prop_file.getName().contains(".hashkey2genes.txt")) {
                    HashMap hashkey2gene = params.repopulateHashmap(fullText, 5);
                    em.setHashkey2gene(hashkey2gene);
                    if (hashkey2gene != null && !hashkey2gene.isEmpty()) {
                        em.setNumberOfGenes(Math.max(em.getNumberOfGenes(), (Integer)Collections.max(hashkey2gene.keySet()) + 1));
                    }
                }
                if (parts.type != null && (parts.type.equalsIgnoreCase("ENR") || parts.type.equalsIgnoreCase("SubENR")) || prop_file.getName().contains(".ENR1.txt") || prop_file.getName().contains(".SubENR1.txt")) {
                    boolean temp = true;
                    if (parts.dataset != null && em.getDataset(parts.dataset).getEnrichments() != null) {
                        enrichments = em.getDataset(parts.dataset).getEnrichments();
                    } else if (parts.dataset == null) {
                        enrichments = em.getDataset("Dataset 1").getEnrichments();
                    } else {
                        enrichments = new SetOfEnrichmentResults(parts.dataset, props);
                        em.getDataset(parts.dataset).setEnrichments(enrichments);
                    }
                    if (parts.type.equalsIgnoreCase("ENR") || prop_file.getName().contains(".ENR1.txt")) {
                        if (params.getMethod().equalsIgnoreCase("GSEA")) {
                            enrichments.setEnrichments(params.repopulateHashmap(fullText, 3));
                        } else {
                            enrichments.setEnrichments(params.repopulateHashmap(fullText, 4));
                        }
                    }
                }
                if (prop_file.getName().contains(".RANKS1.txt") || prop_file.getName().contains(".RANKS1Genes.txt")) {
                    if (em.getDataset("Dataset 1").getExpressionSets().getAllRanksNames().contains("GSEARanking")) {
                        new_ranking = em.getDataset("Dataset 1").getExpressionSets().getRanksByName("GSEARanking");
                    } else {
                        new_ranking = new Ranking();
                        em.getDataset("Dataset 1").getExpressionSets().addRanks("GSEARanking", new_ranking);
                    }
                    if (prop_file.getName().contains(".RANKS1Genes.txt")) {
                        new_ranking.setRank2gene(em.getParams().repopulateHashmap(fullText, 7));
                    }
                    if (prop_file.getName().contains(".RANKS1.txt")) {
                        new_ranking.setRanking(em.getParams().repopulateHashmap(fullText, 6));
                    }
                }
                if (prop_file.getName().contains(".RANKS.txt")) {
                    if (parts.ranks_name == null) {
                        String[] file_name_tokens = prop_file.getName().split("\\.");
                        parts.ranks_name = file_name_tokens.length == 4 && (file_name_tokens[1].equals("Dataset 1 Ranking") || file_name_tokens[1].equals("Dataset 2 Ranking")) || prop_file.getName().contains("GSEARanking") ? "GSEARanking" : prop_file.getName();
                    }
                    new_ranking = new Ranking();
                    new_ranking.setRanking(em.getParams().repopulateHashmap(fullText, 6));
                    if (parts.dataset != null) {
                        em.getDataset(parts.dataset).getExpressionSets().addRanks(parts.ranks_name, new_ranking);
                    } else {
                        em.getDataset("Dataset 1").getExpressionSets().addRanks(parts.ranks_name, new_ranking);
                    }
                }
                if (!params.isTwoDatasets()) continue;
                if (!em.getDatasets().containsKey("Dataset 2")) {
                    em.addDataset("Dataset 2", null);
                }
                if (prop_file.getName().contains(".ENR2.txt") || prop_file.getName().contains(".SubENR2.txt")) {
                    if (em.getDataset("Dataset 2").getEnrichments() != null) {
                        enrichments = em.getDataset("Dataset 2").getEnrichments();
                    } else {
                        enrichments = new SetOfEnrichmentResults("Dataset 2", props);
                        em.getDataset("Dataset 2").setEnrichments(enrichments);
                    }
                    if (prop_file.getName().contains(".ENR2.txt")) {
                        if (params.getMethod().equalsIgnoreCase("GSEA")) {
                            enrichments.setEnrichments(params.repopulateHashmap(fullText, 3));
                        } else {
                            enrichments.setEnrichments(params.repopulateHashmap(fullText, 4));
                        }
                    }
                }
                if (!prop_file.getName().contains(".RANKS2.txt") && !prop_file.getName().contains(".RANKS2Genes.txt")) continue;
                if (em.getDataset("Dataset 2").getExpressionSets().getAllRanksNames().contains("GSEARanking")) {
                    new_ranking = em.getDataset("Dataset 2").getExpressionSets().getRanksByName("GSEARanking");
                } else {
                    new_ranking = new Ranking();
                    em.getDataset("Dataset 2").getExpressionSets().addRanks("GSEARanking", new_ranking);
                }
                if (prop_file.getName().contains(".RANKS2Genes.txt")) {
                    new_ranking.setRank2gene(em.getParams().repopulateHashmap(fullText, 7));
                }
                if (!prop_file.getName().contains(".RANKS2.txt")) continue;
                new_ranking.setGene2rank(em.getParams().repopulateHashmap(fullText, 6));
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                ExpressionFileReaderTask expressionFile1;
                EnrichmentMap map;
                prop_file = (File)pStateFileList.get(i);
                FileNameParts parts_exp = this.ParseFileName(prop_file);
                if (parts_exp == null || parts_exp.name == null) continue;
                net = this.getNetworkByName(parts_exp.name);
                EnrichmentMap enrichmentMap = map = net != null ? EnrichmentMapManager.getInstance().getMap(net.getSUID()) : null;
                if (parts_exp.type != null && parts_exp.type.equalsIgnoreCase("expression") && map.getDatasets().containsKey(parts_exp.dataset)) {
                    DataSet ds = map.getDataset(parts_exp.dataset);
                    ds.getDatasetFiles().setExpressionFileName(prop_file.getAbsolutePath());
                    ds.getExpressionSets().setFilename(prop_file.getAbsolutePath());
                    expressionFile1 = new ExpressionFileReaderTask(ds, this.streamUtil);
                    expressionFile1.parse();
                }
                if (prop_file.getName().contains("expression1.txt")) {
                    DataSet ds1 = map.getDataset("Dataset 1");
                    ds1.getDatasetFiles().setExpressionFileName(prop_file.getAbsolutePath());
                    ds1.getExpressionSets().setFilename(prop_file.getAbsolutePath());
                    expressionFile1 = new ExpressionFileReaderTask(ds1, this.streamUtil);
                    expressionFile1.parse();
                }
                if (!prop_file.getName().contains("expression2.txt")) continue;
                DataSet ds2 = map.getDataset("Dataset 2");
                ds2.getDatasetFiles().setExpressionFileName(prop_file.getAbsolutePath());
                ds2.getExpressionSets().setFilename(prop_file.getAbsolutePath());
                ExpressionFileReaderTask expressionFile2 = new ExpressionFileReaderTask(ds2, this.streamUtil);
                expressionFile2.parse();
                if (map.getDataset("Dataset 2") == null || map.getDataset("Dataset 2").getGenesetsOfInterest() == null || map.getDataset("Dataset 2").getGenesetsOfInterest().getGenesets().isEmpty()) continue;
                map.getParams().setTwoDistinctExpressionSets(true);
                map.getDataset("Dataset 1").setDatasetGenes(new HashSet<Integer>(map.getDataset("Dataset 1").getExpressionSets().getGeneIds()));
                map.getDataset("Dataset 2").setDatasetGenes(new HashSet<Integer>(map.getDataset("Dataset 2").getExpressionSets().getGeneIds()));
            }
            EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
            HashMap<Long, EnrichmentMap> networks = manager.getCyNetworkList();
            Iterator<Long> j = networks.keySet().iterator();
            while (j.hasNext()) {
                Long id = j.next();
                CyNetwork currentNetwork = this.cyNetworkManager.getNetwork(id.longValue());
                EnrichmentMap map = manager.getMap(id);
                if (map == null) continue;
                InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(map);
                genesets_init.initializeSets();
                ComputeSimilarityTask similarities = new ComputeSimilarityTask(map, 0);
                similarities.computeGenesetSimilarities();
                HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
                map.setGenesetSimilarity(similarity_results);
                if (!map.getSignatureGenesets().isEmpty()) {
                    ComputeSimilarityTask sigSimilarities = new ComputeSimilarityTask(map, 1);
                    sigSimilarities.computeGenesetSimilarities();
                    HashMap<String, GenesetSimilarity> sig_similarity_results = sigSimilarities.getGeneset_similarities();
                    map.getGenesetSimilarity().putAll(sig_similarity_results);
                }
                if (j.hasNext()) continue;
                this.cyApplicationManager.setCurrentNetwork(currentNetwork);
                ParametersPanel paramPanel = manager.getParameterPanel();
                paramPanel.updatePanel(map);
                paramPanel.revalidate();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        ArrayList<File> pFileList = new ArrayList<File>();
        String tmpDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir: [" + tmpDir + "]");
        String prop_file_content = "";
        HashMap<Long, EnrichmentMap> networks = EnrichmentMapManager.getInstance().getCyNetworkList();
        for (Long networkId : networks.keySet()) {
            String param_name;
            EnrichmentMap em = networks.get(networkId);
            EnrichmentMapParameters params = networks.get(networkId).getParams();
            CyNetwork network = this.cyNetworkManager.getNetwork(networkId.longValue());
            String name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
            if (!name.equalsIgnoreCase(param_name = em.getName())) {
                em.setName(name);
            }
            File session_prop_file = new File(tmpDir, name + ".props");
            File siggmt = new File(tmpDir, name + ".signature.gmt");
            prop_file_content = prop_file_content + "Version\t2.0\n";
            prop_file_content = prop_file_content + params.toString();
            try {
                if (!em.getSignatureGenesets().isEmpty()) {
                    BufferedWriter sigGmtwriter = new BufferedWriter(new FileWriter(siggmt));
                    sigGmtwriter.write(params.printHashmap(em.getSignatureGenesets()));
                    sigGmtwriter.close();
                    pFileList.add(siggmt);
                }
                File genes = new File(tmpDir, name + ".genes.txt");
                BufferedWriter geneswriter = new BufferedWriter(new FileWriter(genes));
                geneswriter.write(params.printHashmap(em.getGenes()));
                geneswriter.close();
                pFileList.add(genes);
                File hkgenes = new File(tmpDir, name + ".hashkey2genes.txt");
                BufferedWriter hashkey2geneswriter = new BufferedWriter(new FileWriter(hkgenes));
                hashkey2geneswriter.write(params.printHashmap(em.getHashkey2gene()));
                hashkey2geneswriter.close();
                pFileList.add(hkgenes);
                if (em.getDatasets().isEmpty()) continue;
                HashMap<String, DataSet> all_datasets = em.getDatasets();
                prop_file_content = prop_file_content + "Datasets\t" + all_datasets.keySet().toString() + "\n";
                Iterator<String> k = all_datasets.keySet().iterator();
                while (k.hasNext()) {
                    String dataset_name;
                    String current = dataset_name = k.next().toString();
                    if (dataset_name.contains(".")) {
                        dataset_name.replace('.', '_');
                    }
                    File gmt = new File(tmpDir, name + "." + dataset_name + ".gmt");
                    BufferedWriter gmtwriter = new BufferedWriter(new FileWriter(gmt));
                    gmtwriter.write(params.printHashmap(em.getDataset(current).getGenesetsOfInterest().getGenesets()));
                    gmtwriter.close();
                    pFileList.add(gmt);
                    File enrichmentresults_backcomp = new File(tmpDir, name + ".ENR1.txt");
                    if (dataset_name.equals("Dataset 1")) {
                        enrichmentresults_backcomp = new File(tmpDir, name + ".ENR1.txt");
                    }
                    if (dataset_name.equals("Dataset 2")) {
                        enrichmentresults_backcomp = new File(tmpDir, name + ".ENR2.txt");
                    }
                    BufferedWriter enr1writer_backcomp = new BufferedWriter(new FileWriter(enrichmentresults_backcomp));
                    enr1writer_backcomp.write(params.printHashmap(em.getDataset(current).getEnrichments().getEnrichments()));
                    enr1writer_backcomp.close();
                    pFileList.add(enrichmentresults_backcomp);
                    prop_file_content = prop_file_content + em.getDataset(current).getSetofgenesets().toString(current);
                    File enrichmentresults = new File(tmpDir, name + "." + dataset_name + ".ENR.txt");
                    BufferedWriter enr1writer = new BufferedWriter(new FileWriter(enrichmentresults));
                    enr1writer.write(params.printHashmap(em.getDataset(current).getEnrichments().getEnrichments()));
                    enr1writer.close();
                    pFileList.add(enrichmentresults);
                    prop_file_content = prop_file_content + em.getDataset(current).getEnrichments().toString(current);
                    if (em.getDataset(current).getExpressionSets() == null) continue;
                    File expression = new File(tmpDir, name + "." + dataset_name + ".expression.txt");
                    BufferedWriter expression1writer = new BufferedWriter(new FileWriter(expression));
                    expression1writer.write(em.getDataset(current).getExpressionSets().toString());
                    expression1writer.close();
                    pFileList.add(expression);
                    prop_file_content = prop_file_content + em.getDataset(current).getExpressionSets().toString(current);
                    if (em.getDataset(current).getExpressionSets().getRanks().isEmpty()) continue;
                    HashMap<String, Ranking> all_ranks = em.getDataset(current).getExpressionSets().getRanks();
                    Iterator<String> j = all_ranks.keySet().iterator();
                    while (j.hasNext()) {
                        String ranks_name;
                        String current_ranks_name = ranks_name = j.next().toString();
                        if (ranks_name.contains(".")) {
                            ranks_name.replace('.', '_');
                        }
                        File current_ranks = new File(tmpDir, name + "." + dataset_name + "." + ranks_name + ".RANKS.txt");
                        BufferedWriter subrank1writer = new BufferedWriter(new FileWriter(current_ranks));
                        subrank1writer.write(params.printHashmap(all_ranks.get(current_ranks_name).getRanking()));
                        subrank1writer.close();
                        pFileList.add(current_ranks);
                        File current_ranks_backcomp = new File(tmpDir, name + "." + ranks_name + ".RANKS.txt");
                        BufferedWriter subrank1writer_backcomp = new BufferedWriter(new FileWriter(current_ranks_backcomp));
                        subrank1writer_backcomp.write(params.printHashmap(all_ranks.get(current_ranks_name).getRanking()));
                        subrank1writer_backcomp.close();
                        pFileList.add(current_ranks_backcomp);
                    }
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(session_prop_file));
                writer.write(prop_file_content);
                writer.close();
                pFileList.add(session_prop_file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            e.addAppFiles(appName, pFileList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private FileNameParts ParseFileName(File filename) {
        String fullname = filename.getName();
        String name = null;
        String type = null;
        String dataset = null;
        String ranks_name = null;
        if (fullname != null) {
            String[] tokens = fullname.split("\\.");
            if (tokens.length == 2 && tokens[1].equals("gmt")) {
                name = tokens[0];
                dataset = "Dataset 1";
                type = "gmt";
            }
            if (tokens.length == 3 && !tokens[2].equals("gmt")) {
                name = tokens[0];
                type = tokens[1];
            }
            if (tokens.length == 3 && tokens[2].equals("gmt")) {
                name = tokens[0];
                dataset = tokens[1];
                type = "gmt";
            }
            if (tokens.length == 4 && !tokens[2].equals("RANKS")) {
                name = tokens[0];
                dataset = tokens[1];
                type = tokens[tokens.length - 2];
            }
            if (tokens.length == 4 && tokens[2].equals("RANKS")) {
                name = tokens[0];
                dataset = null;
                type = tokens[tokens.length - 2];
            }
            if (tokens.length > 4) {
                name = tokens[0];
                dataset = tokens[1];
                ranks_name = tokens[tokens.length - 3];
                type = tokens[tokens.length - 2];
            }
            FileNameParts parts = new FileNameParts(name, type, dataset, ranks_name);
            return parts;
        }
        return null;
    }

    public CyNetwork getNetworkByName(String name) {
        Set networks = this.cyNetworkManager.getNetworkSet();
        for (CyNetwork network : networks) {
            String currentName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
            if (!currentName.equals(name)) continue;
            return network;
        }
        return null;
    }

    public class FileNameParts {
        public String name;
        public String type;
        public String ranks_name;
        public String dataset;

        public FileNameParts(String name, String type, String dataset, String ranks_name) {
            this.name = name;
            this.type = type;
            this.dataset = dataset;
            this.ranks_name = ranks_name;
        }
    }
}

