/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeSimilarityTask
extends AbstractTask {
    public static final int ENRICHMENT = 0;
    public static final int SIGNATURE = 1;
    private EnrichmentMap map;
    private int type;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public ComputeSimilarityTask(EnrichmentMap map, TaskMonitor taskMonitor) {
        this(map);
        this.taskMonitor = taskMonitor;
    }

    public ComputeSimilarityTask(EnrichmentMap map) {
        this.map = map;
        this.geneset_similarities = map.getGenesetSimilarity();
        this.type = 0;
    }

    public ComputeSimilarityTask(EnrichmentMap map, int type) {
        this.map = map;
        this.geneset_similarities = map.getGenesetSimilarity();
        this.type = type;
    }

    public boolean computeGenesetSimilarities() {
        HashMap<String, GeneSet> genesetsInnerLoop;
        HashMap<String, GeneSet> genesetsOfInterest = this.map.getAllGenesetsOfInterest();
        if (genesetsOfInterest == null || genesetsOfInterest.isEmpty()) {
            genesetsOfInterest = this.map.getAllGenesets();
        }
        String edgeType = "pp";
        if (this.type == 0) {
            genesetsInnerLoop = genesetsOfInterest;
            edgeType = this.map.getParams().getEnrichment_edge_type();
        } else if (this.type == 1) {
            genesetsInnerLoop = this.map.getSignatureGenesets();
            edgeType = "sig";
        } else {
            genesetsInnerLoop = genesetsOfInterest;
        }
        int currentProgress = 0;
        int maxValue = genesetsOfInterest.size();
        int enrichment_set = 0;
        if (this.map.getParams().isTwoDistinctExpressionSets()) {
            enrichment_set = 1;
        }
        Iterator<String> i = genesetsOfInterest.keySet().iterator();
        while (i.hasNext()) {
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Computing Geneset similarity " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            String geneset1_name = i.next().toString();
            Iterator<String> j = genesetsInnerLoop.keySet().iterator();
            while (j.hasNext()) {
                double coeffecient;
                String similarity_key2;
                String similarity_key1;
                String geneset2_name = j.next().toString();
                if (enrichment_set == 0) {
                    similarity_key1 = geneset1_name + " (" + edgeType + ") " + geneset2_name;
                    similarity_key2 = geneset2_name + " (" + edgeType + ") " + geneset1_name;
                } else {
                    similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set1" + ") " + geneset2_name;
                    similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set1" + ") " + geneset1_name;
                }
                if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                GeneSet geneset1 = genesetsOfInterest.get(geneset1_name);
                GeneSet geneset2 = genesetsOfInterest.get(geneset2_name);
                if (geneset1 == null) {
                    geneset1 = genesetsInnerLoop.get(geneset1_name);
                }
                if (geneset2 == null) {
                    geneset2 = genesetsInnerLoop.get(geneset2_name);
                }
                HashSet<Integer> genes1 = geneset1.getGenes();
                HashSet<Integer> genes2 = geneset2.getGenes();
                HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                intersection.retainAll(genes2);
                HashSet<Integer> union = new HashSet<Integer>(genes1);
                union.addAll(genes2);
                if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                    coeffecient = (double)intersection.size() / (double)union.size();
                } else if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                    coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                } else {
                    double jaccard = (double)intersection.size() / (double)union.size();
                    double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    double k = this.map.getParams().getCombinedConstant();
                    coeffecient = k * overlap + (1.0 - k) * jaccard;
                }
                GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.map.getParams().getEnrichment_edge_type(), intersection, enrichment_set);
                if (this.type == 1) {
                    this.geneset_similarities.put(similarity_key2, comparison);
                    continue;
                }
                this.geneset_similarities.put(similarity_key1, comparison);
            }
        }
        if (this.map.getParams().isTwoDistinctExpressionSets()) {
            enrichment_set = 2;
            HashMap<String, GeneSet> genesetsOfInterest_set2 = this.map.getDataset("Dataset 2").getGenesetsOfInterest().getGenesets();
            genesetsInnerLoop = genesetsOfInterest_set2;
            maxValue = genesetsOfInterest.size() + genesetsOfInterest_set2.size();
            Iterator<String> i2 = genesetsOfInterest_set2.keySet().iterator();
            while (i2.hasNext()) {
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setProgress((double)percentComplete);
                    this.taskMonitor.setStatusMessage("Computing Geneset similarity " + currentProgress + " of " + maxValue);
                }
                ++currentProgress;
                String geneset1_name = i2.next().toString();
                Iterator<String> j = genesetsInnerLoop.keySet().iterator();
                while (j.hasNext()) {
                    double coeffecient;
                    String geneset2_name = j.next().toString();
                    String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set2" + ") " + geneset2_name;
                    String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set2" + ") " + geneset1_name;
                    if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                    GeneSet geneset1 = genesetsOfInterest_set2.get(geneset1_name);
                    GeneSet geneset2 = genesetsOfInterest_set2.get(geneset2_name);
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                        coeffecient = (double)intersection.size() / (double)union.size();
                    } else if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                        coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    } else {
                        double jaccard = (double)intersection.size() / (double)union.size();
                        double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        double k = this.map.getParams().getCombinedConstant();
                        coeffecient = k * overlap + (1.0 - k) * jaccard;
                    }
                    GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.map.getParams().getEnrichment_edge_type(), intersection, enrichment_set);
                    if (this.type == 1) {
                        this.geneset_similarities.put(similarity_key2, comparison);
                        continue;
                    }
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
            }
            HashMap<String, GeneSet> sig_genesets_set1 = this.map.getDataset("Dataset 1").getGenesetsOfInterest().getGenesets();
            HashMap<String, GeneSet> sig_genesets_set2 = this.map.getDataset("Dataset 2").getGenesetsOfInterest().getGenesets();
            HashMap<String, GeneSet> genesetsInnerLoop_missingedges = this.map.getAllGenesets();
            HashMap<String, GeneSet> genesetsOfInterest_missingedges = this.map.getAllGenesets();
            HashMap<String, EnrichmentResult> dataset1_results = this.map.getDataset("Dataset 1").getEnrichments().getEnrichments();
            Iterator<String> i3 = genesetsOfInterest_missingedges.keySet().iterator();
            while (i3.hasNext()) {
                enrichment_set = 1;
                String geneset1_name = i3.next().toString();
                if (!dataset1_results.containsKey(geneset1_name)) continue;
                Iterator<String> j = genesetsInnerLoop_missingedges.keySet().iterator();
                while (j.hasNext()) {
                    double coeffecient;
                    String geneset2_name = j.next().toString();
                    if (!dataset1_results.containsKey(geneset2_name)) continue;
                    String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set1" + ") " + geneset2_name;
                    String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set1" + ") " + geneset1_name;
                    if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2) || !(sig_genesets_set1.containsKey(geneset1_name) && !sig_genesets_set2.containsKey(geneset1_name) && !sig_genesets_set1.containsKey(geneset2_name) && sig_genesets_set2.containsKey(geneset2_name) || !sig_genesets_set1.containsKey(geneset1_name) && sig_genesets_set2.containsKey(geneset1_name) && sig_genesets_set1.containsKey(geneset2_name) && !sig_genesets_set2.containsKey(geneset2_name)) && (!sig_genesets_set2.containsKey(geneset1_name) || !sig_genesets_set2.containsKey(geneset2_name))) continue;
                    GeneSet geneset1 = genesetsOfInterest_missingedges.get(geneset1_name);
                    GeneSet geneset2 = genesetsOfInterest_missingedges.get(geneset2_name);
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                        coeffecient = (double)intersection.size() / (double)union.size();
                    } else if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                        coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    } else {
                        double jaccard = (double)intersection.size() / (double)union.size();
                        double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        double k = this.map.getParams().getCombinedConstant();
                        coeffecient = k * overlap + (1.0 - k) * jaccard;
                    }
                    GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.map.getParams().getEnrichment_edge_type(), intersection, enrichment_set);
                    if (this.type == 1) {
                        this.geneset_similarities.put(similarity_key2, comparison);
                        continue;
                    }
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
            }
            HashMap<String, GeneSet> genesetsInnerLoop_missingedges_d2 = this.map.getDataset("Dataset 2").getSetofgenesets().getGenesets();
            HashMap<String, GeneSet> genesetsOfInterest_missingedges_d2 = this.map.getDataset("Dataset 2").getSetofgenesets().getGenesets();
            HashMap<String, EnrichmentResult> dataset2_results = this.map.getDataset("Dataset 2").getEnrichments().getEnrichments();
            Iterator<String> i4 = genesetsOfInterest_missingedges_d2.keySet().iterator();
            while (i4.hasNext()) {
                enrichment_set = 2;
                String geneset1_name = i4.next().toString();
                if (!dataset2_results.containsKey(geneset1_name)) continue;
                Iterator<String> j = genesetsInnerLoop_missingedges_d2.keySet().iterator();
                while (j.hasNext()) {
                    double coeffecient;
                    String geneset2_name = j.next().toString();
                    if (!dataset2_results.containsKey(geneset2_name)) continue;
                    String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set2" + ") " + geneset2_name;
                    String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set2" + ") " + geneset1_name;
                    if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2) || !(sig_genesets_set1.containsKey(geneset1_name) && !sig_genesets_set2.containsKey(geneset1_name) && !sig_genesets_set1.containsKey(geneset2_name) && sig_genesets_set2.containsKey(geneset2_name) || !sig_genesets_set1.containsKey(geneset1_name) && sig_genesets_set2.containsKey(geneset1_name) && sig_genesets_set1.containsKey(geneset2_name) && !sig_genesets_set2.containsKey(geneset2_name)) && (!sig_genesets_set1.containsKey(geneset1_name) || !sig_genesets_set1.containsKey(geneset2_name))) continue;
                    GeneSet geneset1 = genesetsOfInterest_missingedges_d2.get(geneset1_name);
                    GeneSet geneset2 = genesetsOfInterest_missingedges_d2.get(geneset2_name);
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                        coeffecient = (double)intersection.size() / (double)union.size();
                    } else if (this.map.getParams().getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                        coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    } else {
                        double jaccard = (double)intersection.size() / (double)union.size();
                        double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        double k = this.map.getParams().getCombinedConstant();
                        coeffecient = k * overlap + (1.0 - k) * jaccard;
                    }
                    GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.map.getParams().getEnrichment_edge_type(), intersection, enrichment_set);
                    if (this.type == 1) {
                        this.geneset_similarities.put(similarity_key2, comparison);
                        continue;
                    }
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
            }
        }
        return true;
    }

    public HashMap<String, GenesetSimilarity> getGeneset_similarities() {
        return this.geneset_similarities;
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Computing geneset similarities");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Computing geneset similarities");
        this.computeGenesetSimilarities();
    }
}

