/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.HashMap;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateEnrichmentMapNetworkTask;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class BuildGMTEnrichmentMapTask
implements TaskFactory {
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;
    private CyApplicationManager applicationManager;
    private CyNetworkManager networkManager;
    private CyNetworkViewManager networkViewManager;
    private CyNetworkViewFactory networkViewFactory;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;
    private EnrichmentMap map;
    TaskIterator buildEMGMTTaskIterator;

    public BuildGMTEnrichmentMapTask(EnrichmentMap map, CyNetworkFactory networkFactory, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyTableFactory tableFactory, CyTableManager tableManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable) {
        this.map = map;
        this.networkFactory = networkFactory;
        this.applicationManager = applicationManager;
        this.networkManager = networkManager;
        this.networkViewManager = networkViewManager;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.mapTableToNetworkTable = mapTableToNetworkTable;
    }

    public void buildEnrichmentMap() {
        DataSet current_dataset = this.map.getDataset("Dataset 1");
        this.map.getParams().setMethod("generic");
        current_dataset.setGenesetsOfInterest(current_dataset.getSetofgenesets());
        ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.map);
        this.buildEMGMTTaskIterator.append((Task)similarities);
        HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
        this.map.setGenesetSimilarity(similarity_results);
        HashMap<String, GeneSet> current_sets = current_dataset.getSetofgenesets().getGenesets();
        SetOfEnrichmentResults setofenrichments = new SetOfEnrichmentResults();
        HashMap<String, EnrichmentResult> currentEnrichments = setofenrichments.getEnrichments();
        Iterator<String> i = current_sets.keySet().iterator();
        while (i.hasNext()) {
            String geneset1_name = i.next().toString();
            GeneSet current = current_sets.get(geneset1_name);
            GenericResult temp_result = new GenericResult(current.getName(), current.getDescription(), 0.01, current.getGenes().size());
            currentEnrichments.put(current.getName(), temp_result);
        }
        current_dataset.setEnrichments(setofenrichments);
        CreateEnrichmentMapNetworkTask create_map = new CreateEnrichmentMapNetworkTask(this.map, this.networkFactory, this.applicationManager, this.networkManager, this.tableFactory, this.tableManager, this.mapTableToNetworkTable);
        this.buildEMGMTTaskIterator.append((Task)create_map);
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setTitle("Building Enrichment Map based on GMT File");
        this.buildEnrichmentMap();
    }

    public TaskIterator createTaskIterator() {
        this.buildEMGMTTaskIterator = new TaskIterator(new Task[0]);
        this.buildEnrichmentMap();
        return this.buildEMGMTTaskIterator;
    }

    public boolean isReady() {
        return false;
    }
}

