/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateEnrichmentMapNetworkTask;
import org.baderlab.csplugins.enrichmentmap.task.InitializeGenesetsOfInterestTask;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class BuildEnrichmentMapTask
implements TaskFactory {
    private EnrichmentMap map;
    private String name = null;
    private TaskIterator buildEMTaskIterator;
    private CyApplicationManager applicationManager;
    private CyNetworkManager networkManager;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;

    public BuildEnrichmentMapTask(EnrichmentMap map, CyNetworkFactory networkFactory, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyTableFactory tableFactory, CyTableManager tableManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable) {
        this.map = map;
        this.networkFactory = networkFactory;
        this.applicationManager = applicationManager;
        this.networkManager = networkManager;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.mapTableToNetworkTable = mapTableToNetworkTable;
    }

    public BuildEnrichmentMapTask(EnrichmentMap map, String name, CyNetworkFactory networkFactory, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyNetworkViewManager networkViewManager, CyTableFactory tableFactory, CyTableManager tableManager, MapTableToNetworkTablesTaskFactory mapTableToNetworkTable) {
        this(map, networkFactory, applicationManager, networkManager, networkViewManager, tableFactory, tableManager, mapTableToNetworkTable);
        this.name = name;
    }

    public void buildEnrichmentMap() {
        this.map.filterGenesets();
        if (!this.map.checkGenesets()) {
            throw new IllegalThreadStateException("No genes in the expression file are found in the GMT file ");
        }
        InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(this.map);
        this.buildEMTaskIterator.append((Task)genesets_init);
        ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.map);
        this.buildEMTaskIterator.append((Task)similarities);
        CreateEnrichmentMapNetworkTask create_map = new CreateEnrichmentMapNetworkTask(this.map, this.networkFactory, this.applicationManager, this.networkManager, this.tableFactory, this.tableManager, this.mapTableToNetworkTable);
        this.buildEMTaskIterator.append((Task)create_map);
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GSEA results");
    }

    public TaskIterator createTaskIterator() {
        this.buildEMTaskIterator = new TaskIterator(new Task[0]);
        this.buildEnrichmentMap();
        return this.buildEMTaskIterator;
    }

    public boolean isReady() {
        return true;
    }
}

