/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;

public class RanksFileReaderTask
implements Task {
    private String RankFileName;
    private DataSet dataset;
    private String ranks_name;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private boolean loadFromHeatmap = false;

    public RanksFileReaderTask(String rankFileName, DataSet dataset, boolean loadFromHeatmap) {
        this.RankFileName = rankFileName;
        this.dataset = dataset;
        this.loadFromHeatmap = loadFromHeatmap;
    }

    public RanksFileReaderTask(String rankFileName, DataSet dataset, TaskMonitor taskMonitor, boolean loadFromHeatmap) {
        this.RankFileName = rankFileName;
        this.dataset = dataset;
        this.taskMonitor = taskMonitor;
        this.loadFromHeatmap = loadFromHeatmap;
    }

    public RanksFileReaderTask(String rankFileName, DataSet dataset, String ranks_name, TaskMonitor taskMonitor, boolean loadFromHeatmap) {
        this.RankFileName = rankFileName;
        this.ranks_name = ranks_name;
        this.dataset = dataset;
        this.taskMonitor = taskMonitor;
        this.loadFromHeatmap = loadFromHeatmap;
    }

    public RanksFileReaderTask(String rankFileName, DataSet dataset, String ranks_name, boolean loadFromHeatmap) {
        this.RankFileName = rankFileName;
        this.ranks_name = ranks_name;
        this.dataset = dataset;
        this.loadFromHeatmap = loadFromHeatmap;
    }

    public RanksFileReaderTask(String rankFileName, String ranks_name, boolean loadFromHeatmap) {
        this.RankFileName = rankFileName;
        this.ranks_name = ranks_name;
        this.loadFromHeatmap = loadFromHeatmap;
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.RankFileName);
        reader.read();
        String fullText = reader.getText();
        int lineNumber = 0;
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        Double[] score_collector = new Double[lines.length];
        boolean gseaDefinedRanks = false;
        HashMap<Integer, Rank> ranks = new HashMap<Integer, Rank>();
        HashMap<Integer, Integer> rank2gene = new HashMap<Integer, Integer>();
        int nScores = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.startsWith("#")) {
                if (!Pattern.matches("^# *Ranks[ _-]?Name *:.+", line)) continue;
                this.ranks_name = line.split(":", 2)[1];
                while (this.ranks_name.startsWith(" ")) {
                    this.ranks_name = this.ranks_name.substring(1);
                }
                continue;
            }
            String[] tokens = line.split("\t");
            String name = tokens[0].toUpperCase();
            double score = 0.0;
            if (tokens.length == 5) {
                try {
                    score = Double.parseDouble(tokens[4]);
                }
                catch (NumberFormatException nfe) {
                    if (lineNumber == 0) {
                        ++lineNumber;
                        continue;
                    }
                    throw new IllegalThreadStateException("rank value for" + tokens[0] + "is not a valid number");
                }
                ++nScores;
            } else if (tokens.length == 2) {
                try {
                    score = Double.parseDouble(tokens[1]);
                }
                catch (NumberFormatException nfe) {
                    if (lineNumber == 0) {
                        ++lineNumber;
                        continue;
                    }
                    throw new IllegalThreadStateException("rank value for" + tokens[0] + "is not a valid number");
                }
                ++nScores;
            } else {
                System.out.println("Invalid number of tokens line of Rank File (should be 5 or 2)");
                continue;
            }
            if (tokens.length == 5 || this.dataset.getMap().getParams().getMethod().equalsIgnoreCase("GSEA") && !this.loadFromHeatmap) {
                gseaDefinedRanks = true;
            }
            score_collector[nScores - 1] = score;
            if (genes.containsKey(name)) {
                Rank current_ranking;
                Integer genekey = genes.get(name);
                if (tokens.length == 5 || this.dataset.getMap().getParams().getMethod().equalsIgnoreCase("GSEA") && !this.loadFromHeatmap) {
                    current_ranking = new Rank(name, score, nScores);
                    rank2gene.put(nScores, genekey);
                } else {
                    current_ranking = new Rank(name, score);
                }
                ranks.put(genekey, current_ranking);
            }
            int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
            long timeRemaining = this.maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing Rank file " + currentProgress + " of " + this.maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
        }
        if (ranks.isEmpty()) {
            throw new IllegalThreadStateException("None of the genes in the rank file are found in the expression file.  Make sure the identifiers of the two files match.");
        }
        Object[] sort_scores = new Double[nScores];
        for (int i = 0; i < nScores; ++i) {
            sort_scores[i] = score_collector[i];
        }
        HashMap<Object, Integer> score2ranks = new HashMap<Object, Integer>();
        Arrays.sort(sort_scores, Collections.reverseOrder());
        if (sort_scores[0] <= 1.0 && sort_scores[sort_scores.length - 1] >= -1.0) {
            Arrays.sort(sort_scores);
        }
        for (int j = 0; j < sort_scores.length; ++j) {
            if (score2ranks.containsKey(sort_scores[j])) continue;
            score2ranks.put(sort_scores[j], j);
        }
        if (!gseaDefinedRanks) {
            Iterator k = ranks.keySet().iterator();
            while (k.hasNext()) {
                Rank current_ranking = (Rank)ranks.get(k.next());
                current_ranking.setRank((Integer)score2ranks.get(current_ranking.getScore()));
            }
        }
        HashSet<Integer> current_genes = this.dataset.getDatasetGenes();
        Set current_ranks = ranks.keySet();
        HashSet<Integer> intersection = new HashSet<Integer>(current_genes);
        intersection.retainAll(current_ranks);
        if (intersection.size() != current_genes.size()) {
            // empty if block
        }
        Ranking new_ranking = new Ranking();
        new_ranking.setRanking(ranks);
        new_ranking.setRank2gene(rank2gene);
        this.dataset.getExpressionSets().addRanks(this.ranks_name, new_ranking);
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Ranks file");
    }
}

