/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import javax.swing.DefaultListModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;

public class PostAnalysisParameters
extends EnrichmentMapParameters {
    private boolean isSignatureHub;
    public static final int HYPERGEOM = 0;
    public static final int ABS_NUMBER = 1;
    public static final int JACCARD = 2;
    public static final int OVERLAP = 3;
    public static final int DIR_OVERLAP = 4;
    public static final int PERCENT = 0;
    public static final int NUMBER = 1;
    public static final int SPECIFIC = 2;
    public static final String[] filterItems = new String[]{"Overlap X percent of EM gs", "Overlap has at least X genes", "Overlap X percent of Signature gs"};
    public static final String[] sigCutoffItems = new String[]{"Hypergeometric Test", "Number of common genes", "Jaccard Coefficient", "Overlap Coefficient", "Directed Overlap"};
    public static final String SIGNATURE_INTERACTION_TYPE = "sig";
    private String signatureHub_nodeShape = "TRIANGLE";
    private String signatureHub_nodeColor = "255,255,0";
    private String signatureHub_borderColor = "255,255,0";
    private String signatureHub_edgeColor = "255,0,200";
    private String signatureGMTFileName;
    private int signature_absNumber_Cutoff;
    private double signature_Jaccard_Cutoff;
    private double signature_Overlap_Cutoff;
    private double signature_DirOverlap_Cutoff;
    private double signature_Hypergeom_Cutoff;
    private int signature_CutoffMetric;
    private int default_signature_absNumber_Cutoff = 5;
    private double default_signature_Jaccard_Cutoff = 0.125;
    private double default_signature_Overlap_Cutoff = 0.25;
    private double default_signature_DirOverlap_Cutoff = 0.25;
    private double default_signature_Hypergeom_Cutoff = 0.05;
    private int default_signature_CutoffMetric = 0;
    private SetOfGeneSets signatureGenesets;
    private DefaultListModel signatureSetNames;
    private DefaultListModel selectedSignatureSetNames;
    private double currentNodePlacementY_Offset;
    private boolean filter = false;
    private int filterValue;
    private int default_filter_value = 50;
    private int default_signature_filterMetric = 0;
    private int signature_filterMetric;

    public PostAnalysisParameters(EnrichmentMap map) {
        super.copy(map.getParams());
        this.isSignatureHub = true;
        this.signatureGMTFileName = "";
        this.signature_absNumber_Cutoff = this.default_signature_absNumber_Cutoff;
        this.signature_Jaccard_Cutoff = this.default_signature_Jaccard_Cutoff;
        this.signature_Overlap_Cutoff = this.default_signature_Overlap_Cutoff;
        this.signature_DirOverlap_Cutoff = this.default_signature_DirOverlap_Cutoff;
        this.signature_Hypergeom_Cutoff = this.default_signature_Hypergeom_Cutoff;
        this.signature_CutoffMetric = this.default_signature_CutoffMetric;
        this.signatureGenesets = new SetOfGeneSets();
        this.signatureSetNames = new DefaultListModel();
        this.selectedSignatureSetNames = new DefaultListModel();
        this.currentNodePlacementY_Offset = 0.0;
        this.filterValue = this.default_filter_value;
        this.signature_filterMetric = this.default_signature_filterMetric;
        map.setPaParams(this);
    }

    public PostAnalysisParameters() {
        this.isSignatureHub = true;
        this.signatureGMTFileName = "";
        this.signature_absNumber_Cutoff = this.default_signature_absNumber_Cutoff;
        this.signature_Jaccard_Cutoff = this.default_signature_Jaccard_Cutoff;
        this.signature_Overlap_Cutoff = this.default_signature_Overlap_Cutoff;
        this.signature_DirOverlap_Cutoff = this.default_signature_DirOverlap_Cutoff;
        this.signature_Hypergeom_Cutoff = this.default_signature_Hypergeom_Cutoff;
        this.signature_CutoffMetric = this.default_signature_CutoffMetric;
        this.signatureGenesets = new SetOfGeneSets();
        this.signatureSetNames = new DefaultListModel();
        this.selectedSignatureSetNames = new DefaultListModel();
        this.currentNodePlacementY_Offset = 0.0;
        this.filterValue = this.default_filter_value;
        this.signature_filterMetric = this.default_signature_filterMetric;
    }

    public void copyFrom(PostAnalysisParameters source) {
        super.copy(source);
        this.isSignatureHub = source.isSignatureHub();
        this.signatureGMTFileName = source.getSignatureGMTFileName();
        this.signature_absNumber_Cutoff = source.getSignature_absNumber_Cutoff();
        this.signature_Jaccard_Cutoff = source.getSignature_Jaccard_Cutoff();
        this.signature_Overlap_Cutoff = source.getSignature_Overlap_Cutoff();
        this.signature_DirOverlap_Cutoff = source.getSignature_DirOverlap_Cutoff();
        this.signature_Hypergeom_Cutoff = source.getSignature_Hypergeom_Cutoff();
        this.signature_CutoffMetric = source.getSignature_CutoffMetric();
        this.signatureGenesets = source.getSignatureGenesets();
        this.signatureSetNames = source.getSignatureSetNames();
        this.selectedSignatureSetNames = source.getSelectedSignatureSetNames();
        this.currentNodePlacementY_Offset = source.getCurrentNodePlacementY_Offset();
        this.filterValue = source.getFilterValue();
    }

    public String checkMinimalRequirements() {
        String errors = "";
        errors = errors + this.checkGMTfiles();
        if (this.selectedSignatureSetNames.isEmpty()) {
            errors = errors + "No Signature Genesets selected \n";
        }
        if (this.signature_CutoffMetric == 1) {
            if (this.signature_absNumber_Cutoff <= 0) {
                errors = errors + "Number of Genes Cutoff must be a positive, non-zero integer \n";
            }
        } else if (this.signature_CutoffMetric == 0) {
            if (!(this.signature_Hypergeom_Cutoff >= 0.0) || !(this.signature_Hypergeom_Cutoff <= 1.0)) {
                errors = errors + "Hypergeometric Cutoff must be a decimal Number between 0.0 and 1.0 \n";
            }
        } else if (this.signature_CutoffMetric == 3) {
            if (!(this.signature_Overlap_Cutoff >= 0.0) || !(this.signature_Overlap_Cutoff <= 1.0)) {
                errors = errors + "Overlap Cutoff must be a decimal Number between 0.0 and 1.0 \n";
            }
        } else if (this.signature_CutoffMetric == 2) {
            if (!(this.signature_Jaccard_Cutoff >= 0.0) || !(this.signature_Jaccard_Cutoff <= 1.0)) {
                errors = errors + "Jaccard Cutoff must be a decimal Number between 0.0 and 1.0 \n";
            }
        } else if (this.signature_CutoffMetric == 4) {
            if (!(this.signature_DirOverlap_Cutoff >= 0.0) || !(this.signature_DirOverlap_Cutoff <= 1.0)) {
                errors = errors + "Directed Overlap Cutoff must be a decimal Number between 0.0 and 1.0 \n";
            }
        } else {
            errors = errors + "Invalid Cutoff metric \n";
        }
        return errors;
    }

    public String checkGMTfiles() {
        String errors = "";
        if (this.getGMTFileName().equalsIgnoreCase("") || !this.checkFile(this.getGMTFileName())) {
            errors = errors + "GMT file can not be found \n";
        }
        if (this.getSignatureGMTFileName().equalsIgnoreCase("") || !this.checkFile(this.getSignatureGMTFileName())) {
            errors = errors + "Signature GMT file can not be found \n";
        }
        return errors;
    }

    public void setSignatureGMTFileName(String signatureGMTFileName) {
        this.signatureGMTFileName = signatureGMTFileName;
    }

    public String getSignatureGMTFileName() {
        return this.signatureGMTFileName;
    }

    public void setSignature_absNumber_Cutoff(int signature_absNumber_Cutoff) {
        this.signature_absNumber_Cutoff = signature_absNumber_Cutoff;
    }

    public int getSignature_absNumber_Cutoff() {
        return this.signature_absNumber_Cutoff;
    }

    public void setSignature_Jaccard_Cutoff(double signature_Jaccard_Cutoff) {
        this.signature_Jaccard_Cutoff = signature_Jaccard_Cutoff;
    }

    public double getSignature_Jaccard_Cutoff() {
        return this.signature_Jaccard_Cutoff;
    }

    public void setSignature_Overlap_Cutoff(double signature_Overlap_Cutoff) {
        this.signature_Overlap_Cutoff = signature_Overlap_Cutoff;
    }

    public double getSignature_Overlap_Cutoff() {
        return this.signature_Overlap_Cutoff;
    }

    public void setSignature_DirOverlap_Cutoff(double signature_DirOverlap_Cutoff) {
        this.signature_DirOverlap_Cutoff = signature_DirOverlap_Cutoff;
    }

    public double getSignature_DirOverlap_Cutoff() {
        return this.signature_DirOverlap_Cutoff;
    }

    public void setSignature_Hypergeom_Cutoff(double signature_Hypergeom_Cutoff) {
        this.signature_Hypergeom_Cutoff = signature_Hypergeom_Cutoff;
    }

    public double getSignature_Hypergeom_Cutoff() {
        return this.signature_Hypergeom_Cutoff;
    }

    public void setSignature_CutoffMetric(int signature_CutoffMetric) {
        this.signature_CutoffMetric = signature_CutoffMetric;
    }

    public int getSignature_CutoffMetric() {
        return this.signature_CutoffMetric;
    }

    public void setSignatureHub(boolean isSignatureHub) {
        this.isSignatureHub = isSignatureHub;
    }

    public void setDefault_signature_absNumber_Cutoff(int defaultSignatureAbsNumberCutoff) {
        this.default_signature_absNumber_Cutoff = defaultSignatureAbsNumberCutoff;
    }

    public int getDefault_signature_absNumber_Cutoff() {
        return this.default_signature_absNumber_Cutoff;
    }

    public void setDefault_signature_Jaccard_Cutoff(double defaultSignatureJaccardCutoff) {
        this.default_signature_Jaccard_Cutoff = defaultSignatureJaccardCutoff;
    }

    public double getDefault_signature_Jaccard_Cutoff() {
        return this.default_signature_Jaccard_Cutoff;
    }

    public void setDefault_signature_Overlap_Cutoff(double defaultSignatureOverlapCutoff) {
        this.default_signature_Overlap_Cutoff = defaultSignatureOverlapCutoff;
    }

    public double getDefault_signature_Overlap_Cutoff() {
        return this.default_signature_Overlap_Cutoff;
    }

    public void setDefault_signature_Hypergeom_Cutoff(double defaultSignatureHypergeomCutoff) {
        this.default_signature_Hypergeom_Cutoff = defaultSignatureHypergeomCutoff;
    }

    public double getDefault_signature_Hypergeom_Cutoff() {
        return this.default_signature_Hypergeom_Cutoff;
    }

    public void setDefault_signature_DirOverlap_Cutoff(double default_signature_DirOverlap_Cutoff) {
        this.default_signature_DirOverlap_Cutoff = default_signature_DirOverlap_Cutoff;
    }

    public double getDefault_signature_DirOverlap_Cutoff() {
        return this.default_signature_DirOverlap_Cutoff;
    }

    public void setDefault_signature_CutoffMetric(int defaultSignatureCutoffMetric) {
        this.default_signature_CutoffMetric = defaultSignatureCutoffMetric;
    }

    public int getDefault_signature_CutoffMetric() {
        return this.default_signature_CutoffMetric;
    }

    public boolean isSignatureHub() {
        return this.isSignatureHub;
    }

    public void setSignatureGenesets(SetOfGeneSets signatureGenesets) {
        this.signatureGenesets = signatureGenesets;
    }

    public SetOfGeneSets getSignatureGenesets() {
        return this.signatureGenesets;
    }

    public void setSignatureSetNames(DefaultListModel signatureSetNames) {
        this.signatureSetNames = signatureSetNames;
    }

    public DefaultListModel getSignatureSetNames() {
        return this.signatureSetNames;
    }

    public void setSelectedSignatureSetNames(DefaultListModel selectedSignatureSetNames) {
        this.selectedSignatureSetNames = selectedSignatureSetNames;
    }

    public DefaultListModel getSelectedSignatureSetNames() {
        return this.selectedSignatureSetNames;
    }

    public void setSignatureHub_nodeShape(String signatureHub_nodeShape) {
        this.signatureHub_nodeShape = signatureHub_nodeShape;
    }

    public String getSignatureHub_nodeShape() {
        return this.signatureHub_nodeShape;
    }

    public void setSignatureHub_nodeColor(String signatureHub_nodeColor) {
        this.signatureHub_nodeColor = signatureHub_nodeColor;
    }

    public String getSignatureHub_nodeColor() {
        return this.signatureHub_nodeColor;
    }

    public void setSignatureHub_borderColor(String signatureHub_borderColor) {
        this.signatureHub_borderColor = signatureHub_borderColor;
    }

    public String getSignatureHub_borderColor() {
        return this.signatureHub_borderColor;
    }

    public void setSignatureHub_edgeColor(String signatureHub_edgeColor) {
        this.signatureHub_edgeColor = signatureHub_edgeColor;
    }

    public String getSignatureHub_edgeColor() {
        return this.signatureHub_edgeColor;
    }

    public void setCurrentNodePlacementY_Offset(double currentNodePlacementY_Offset) {
        this.currentNodePlacementY_Offset = currentNodePlacementY_Offset;
    }

    public double getCurrentNodePlacementY_Offset() {
        return this.currentNodePlacementY_Offset;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public int getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(int filterValue) {
        this.filterValue = filterValue;
    }

    public int getSignature_filterMetric() {
        return this.signature_filterMetric;
    }

    public void setSignature_filterMetric(int signature_filterMetric) {
        this.signature_filterMetric = signature_filterMetric;
    }

    public int getDefault_signature_filterMetric() {
        return this.default_signature_filterMetric;
    }
}

