/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import cytoscape.Cytoscape;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;
import org.baderlab.csplugins.enrichmentmap.parsers.RanksFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;

public class HeatMapActionListener
implements ActionListener {
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private HeatMapParameters hmParams;
    private JComboBox box;
    private EnrichmentMapParameters params;
    private EnrichmentMap map;

    public HeatMapActionListener(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel, JComboBox box, HeatMapParameters hmParams, EnrichmentMap map) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.hmParams = hmParams;
        this.box = box;
        this.params = map.getParams();
        this.map = map;
    }

    public void actionPerformed(ActionEvent evt) {
        this.edgeOverlapPanel.clearPanel();
        this.nodeOverlapPanel.clearPanel();
        String select = (String)this.box.getSelectedItem();
        if (select.equalsIgnoreCase("Data As Is")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.ASIS);
        } else if (select.equalsIgnoreCase("Row Normalize Data")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.ROWNORM);
        } else if (select.equalsIgnoreCase("Log Transform Data")) {
            this.hmParams.setTransformation(HeatMapParameters.Transformation.LOGTRANSFORM);
        } else if (select.equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) {
            this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
            this.hmParams.setSortIndex(-1);
        } else if (select.equalsIgnoreCase("Add Rankings ... ")) {
            HashMap<String, Ranking> all_ranks = this.map.getAllRanks();
            CyFileFilter filter = new CyFileFilter();
            filter.addExtension("txt");
            filter.addExtension("xls");
            filter.addExtension("rnk");
            File file = FileUtil.getFile((String)"Import new Rank file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
            if (file != null) {
                String ranks_name = JOptionPane.showInputDialog((Component)Cytoscape.getDesktop(), "What would you like to name these Rankings?", "My Rankings");
                boolean noname = true;
                while (noname) {
                    noname = false;
                    Iterator<String> j = all_ranks.keySet().iterator();
                    while (j.hasNext()) {
                        String current_name = j.next().toString();
                        if (!current_name.equalsIgnoreCase(ranks_name)) continue;
                        noname = true;
                        ranks_name = JOptionPane.showInputDialog((Component)Cytoscape.getDesktop(), (Object)"Sorry that name already exists.Please choose another name.");
                    }
                }
                RanksFileReaderTask ranking1 = new RanksFileReaderTask(file.getAbsolutePath(), this.map.getDataset("Dataset 1"), ranks_name, true);
                ranking1.run();
                boolean[] ascending = this.hmParams.getAscending();
                boolean[] new_ascending = new boolean[ascending.length + 1];
                System.arraycopy(ascending, 0, new_ascending, 0, ascending.length);
                new_ascending[new_ascending.length - 1] = true;
                this.hmParams.setAscending(new_ascending);
            }
        } else if (select.equalsIgnoreCase(HeatMapParameters.sort_none)) {
            this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            this.hmParams.setSortIndex(-1);
            this.hmParams.setRankFileIndex("");
        } else if (select.contains(HeatMapParameters.sort_column)) {
            this.hmParams.setRankFileIndex("");
            this.hmParams.setSort(HeatMapParameters.Sort.COLUMN);
            if (this.hmParams.isSortbycolumn_event_triggered()) {
                this.hmParams.setSortbycolumn_event_triggered(false);
                this.hmParams.flipAscending(this.hmParams.getSortIndex());
            }
        } else {
            HashMap<String, Ranking> ranks = this.map.getAllRanks();
            int i = 0;
            int columns = 0;
            columns = this.params.isData2() && this.map.getDataset("Dataset 2").getExpressionSets() != null ? this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length + this.map.getDataset("Dataset 2").getExpressionSets().getColumnNames().length - 2 : this.map.getDataset("Dataset 1").getExpressionSets().getColumnNames().length;
            Iterator<String> j = ranks.keySet().iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (ranks_name.equalsIgnoreCase(select)) {
                    this.hmParams.setSort(HeatMapParameters.Sort.RANK);
                    this.hmParams.setRankFileIndex(ranks_name);
                    this.hmParams.setSortIndex(columns + i);
                }
                ++i;
            }
        }
        this.hmParams.ResetColorGradient();
        this.edgeOverlapPanel.updatePanel();
        this.nodeOverlapPanel.updatePanel();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        int index = cytoPanel.getSelectedIndex();
        cytoPanel.setSelectedIndex(index);
    }
}

