/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.DefaultBoundedRangeModel;
import prefuse.util.TypeLib;
import prefuse.util.ui.ValuedRangeModel;

public class NumberRangeModel
extends DefaultBoundedRangeModel
implements ValuedRangeModel {
    protected Class m_type;
    protected Number m_min;
    protected Number m_max;
    protected Number m_lo;
    protected Number m_hi;

    public NumberRangeModel(int lo, int hi, int min, int max) {
        this(new Integer(lo), new Integer(hi), new Integer(min), new Integer(max));
    }

    public NumberRangeModel(long lo, long hi, long min, long max) {
        this(new Long(lo), new Long(hi), new Long(min), new Long(max));
    }

    public NumberRangeModel(float lo, float hi, float min, float max) {
        this(new Float(lo), new Float(hi), new Float(min), new Float(max));
    }

    public NumberRangeModel(double lo, double hi, double min, double max) {
        this(new Double(lo), new Double(hi), new Double(min), new Double(max));
    }

    public NumberRangeModel(Number lo, Number hi, Number min, Number max) {
        this.m_type = TypeLib.getPrimitiveType(min.getClass());
        this.setValueRange(lo, hi, min, max);
    }

    protected void updateRange() {
        if (this.m_type == Integer.TYPE) {
            this.setRange(this.m_lo.intValue(), this.m_hi.intValue() - this.m_lo.intValue(), this.m_min.intValue(), this.m_max.intValue());
        } else if (this.m_type == Long.TYPE) {
            int v = 10000 * (int)((this.m_lo.longValue() - this.m_min.longValue()) / (this.m_max.longValue() - this.m_min.longValue()));
            int e = 10000 * (int)((this.m_hi.longValue() - this.m_min.longValue()) / (this.m_max.longValue() - this.m_min.longValue())) - v;
            this.setRange(v, e, 0, 10000);
        } else {
            int v = (int)Math.round(10000.0 * ((this.m_lo.doubleValue() - this.m_min.doubleValue()) / (this.m_max.doubleValue() - this.m_min.doubleValue())));
            int e = (int)Math.round(10000.0 * ((this.m_hi.doubleValue() - this.m_min.doubleValue()) / (this.m_max.doubleValue() - this.m_min.doubleValue()))) - v;
            this.setRange(v, e, 0, 10000);
        }
    }

    protected void setRange(int val, int ext, int min, int max) {
        super.setRangeProperties(val, ext, min, max, false);
    }

    public void setRangeProperties(int val, int extent, int min, int max, boolean adj) {
        if (min != this.getMinimum() || max != this.getMaximum()) {
            throw new IllegalArgumentException("Can not change min or max.");
        }
        this.m_lo = null;
        this.m_hi = null;
        super.setRangeProperties(val, extent, min, max, adj);
    }

    public void setValueRange(Number lo, Number hi, Number min, Number max) {
        this.m_lo = lo;
        this.m_hi = hi;
        this.m_min = min;
        this.m_max = max;
        this.updateRange();
    }

    public void setValueRange(double lo, double hi, double min, double max) {
        this.m_lo = new Double(lo);
        this.m_hi = new Double(hi);
        this.m_min = new Double(min);
        this.m_max = new Double(max);
        this.updateRange();
    }

    public void setValueRange(int lo, int hi, int min, int max) {
        this.m_lo = new Integer(lo);
        this.m_hi = new Integer(hi);
        this.m_min = new Integer(min);
        this.m_max = new Integer(max);
        this.updateRange();
    }

    public void setValueRange(long lo, long hi, long min, long max) {
        this.m_lo = new Long(lo);
        this.m_hi = new Long(hi);
        this.m_min = new Long(min);
        this.m_max = new Long(max);
        this.updateRange();
    }

    public Object getMinValue() {
        return this.m_min;
    }

    public void setMinValue(Number n) {
        this.setValueRange((Number)this.getLowValue(), (Number)this.getHighValue(), n, this.m_max);
    }

    public Object getMaxValue() {
        return this.m_max;
    }

    public void setMaxValue(Number n) {
        this.setValueRange((Number)this.getLowValue(), (Number)this.getHighValue(), this.m_min, n);
    }

    public Object getLowValue() {
        if (this.m_lo == null) {
            this.m_lo = (Number)this.value(this.getValue());
        }
        return this.m_lo;
    }

    public void setLowValue(Number n) {
        this.setValueRange(n, (Number)this.getHighValue(), this.m_min, this.m_max);
    }

    public Object getHighValue() {
        if (this.m_hi == null) {
            this.m_hi = (Number)this.value(this.getValue() + this.getExtent());
        }
        return this.m_hi;
    }

    public void setHighValue(Number n) {
        this.setValueRange((Number)this.getLowValue(), n, this.m_min, this.m_max);
    }

    protected Object value(int val) {
        int min = this.getMinimum();
        int max = this.getMaximum();
        if (this.m_type == Double.TYPE || this.m_type == Float.TYPE) {
            double f = (double)(val - min) / (double)(max - min);
            double m = this.m_min.doubleValue();
            double v = m + f * (this.m_max.doubleValue() - m);
            return this.m_type == Float.TYPE ? (Number)new Float((float)v) : (Number)new Double(v);
        }
        if (this.m_type == Long.TYPE) {
            long m = this.m_min.longValue();
            long v = m + (long)(val - min) * (this.m_max.longValue() - m) / (long)(max - min);
            return new Long(v);
        }
        return new Integer(val);
    }

    public void setMinimum(int min) {
        throw new UnsupportedOperationException();
    }

    public void setMaximum(int max) {
        throw new UnsupportedOperationException();
    }

    public void setValue(int val) {
        this.m_lo = null;
        super.setValue(val);
    }

    public void setExtent(int extent) {
        this.m_hi = null;
        super.setExtent(extent);
    }
}

