/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.parsers.EnrichmentResultFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.RanksFileReaderTask;

public class LoadDataSetTask
implements Task {
    private DataSet dataset;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public LoadDataSetTask(DataSet dataset) {
        this.dataset = dataset;
    }

    public LoadDataSetTask(DataSet dataset, TaskMonitor taskMonitor) {
        this.dataset = dataset;
        this.taskMonitor = taskMonitor;
    }

    public void parse() {
        RanksFileReaderTask ranking1;
        try {
            if (this.dataset.getSetofgenesets().getFilename() != null && !this.dataset.getSetofgenesets().getFilename().isEmpty()) {
                GMTFileReaderTask gmtFile = new GMTFileReaderTask(this.dataset, this.taskMonitor);
                gmtFile.run();
            }
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to load GMT file");
            return;
        }
        try {
            EnrichmentResultFileReaderTask enrichmentResultsFiles = new EnrichmentResultFileReaderTask(this.dataset, this.taskMonitor);
            enrichmentResultsFiles.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to load enrichment results files");
            return;
        }
        try {
            ExpressionFileReaderTask expressionFile = new ExpressionFileReaderTask(this.dataset, this.taskMonitor);
            expressionFile.run();
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Either no genes in the expression file are found in the GMT file \n OR the identifiers in the Expression and GMT do not match up.", "Expression and GMT file do not match");
            return;
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to load GSEA DATA (.GCT) file");
            return;
        }
        if (this.dataset.getMap().getParams().getMethod().equalsIgnoreCase("GSEA")) {
            if (this.dataset.getExpressionSets().getRanksByName("GSEARanking") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("GSEARanking").getFilename(), this.dataset, "GSEARanking", this.taskMonitor, false);
                ranking1.run();
            }
        } else {
            if (this.dataset.getExpressionSets().getRanksByName("Dataset 1") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("Dataset 1").getFilename(), this.dataset, "Dataset 1", this.taskMonitor, false);
                ranking1.run();
            }
            if (this.dataset.getExpressionSets().getRanksByName("Dataset 2") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("Dataset 2").getFilename(), this.dataset, "Dataset 2", this.taskMonitor, false);
                ranking1.run();
            }
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Dataset file");
    }
}

