/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseEDBEnrichmentResults {
    private Document dom;
    private File inputFile;
    private HashMap<String, EnrichmentResult> enrichmentresults;

    public ParseEDBEnrichmentResults(File inputFile) {
        this.inputFile = inputFile;
        this.enrichmentresults = new HashMap();
    }

    private void parseFile() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.inputFile);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public HashMap<String, EnrichmentResult> parseDocument() {
        this.parseFile();
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("DTG");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                GSEAResult e = this.getEnrichmentResult(el);
                this.enrichmentresults.put(e.getName(), e);
            }
        }
        return this.enrichmentresults;
    }

    private GSEAResult getEnrichmentResult(Element el) {
        String name = el.getAttribute("GENESET").replace("gene_sets.gmt#", "");
        int gsSize = el.getAttribute("HIT_INDICES") != null ? el.getAttribute("HIT_INDICES").split(" ").length : 0;
        double ES = el.getAttribute("ES") != null ? Double.parseDouble(el.getAttribute("ES")) : 0.0;
        double NES = el.getAttribute("NES") != null ? Double.parseDouble(el.getAttribute("NES")) : 0.0;
        double pvalue = el.getAttribute("NP") != null ? Double.parseDouble(el.getAttribute("NP")) : 1.0;
        double FDR = el.getAttribute("FDR") != null ? Double.parseDouble(el.getAttribute("FDR")) : 1.0;
        double FWER = el.getAttribute("FWER") != null ? Double.parseDouble(el.getAttribute("FWER")) : 1.0;
        double rank_at_max = el.getAttribute("RANK_AT_ES") != null ? Double.parseDouble(el.getAttribute("RANK_AT_ES")) : 0.0;
        double score_at_max = NES;
        GSEAResult result = new GSEAResult(name, gsSize, ES, NES, pvalue, FDR, FWER, (int)rank_at_max, score_at_max);
        return result;
    }
}

