/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.model.Ranking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneExpressionMatrix {
    private String[] columnNames;
    private int numConditions;
    private int numGenes;
    private HashMap<Integer, GeneExpression> expressionMatrix;
    private HashMap<Integer, GeneExpression> expressionMatrix_rowNormalized;
    private double maxExpression = -1000000.0;
    private double minExpression = 1.0E7;
    private String[] phenotypes;
    private String phenotype1;
    private String phenotype2;
    private HashMap<String, Ranking> ranks;
    private String filename;

    public GeneExpressionMatrix() {
        this.expressionMatrix = new HashMap();
        this.expressionMatrix_rowNormalized = new HashMap();
        this.ranks = new HashMap();
    }

    public GeneExpressionMatrix(String filename) {
        this();
        this.filename = filename;
    }

    public GeneExpressionMatrix(String[] columnNames) {
        this.setColumnNames(columnNames);
    }

    public void SetColumnNames() {
        this.numConditions = this.columnNames.length;
        if (this.numConditions == 2) {
            this.numConditions = 3;
            String[] newNames = new String[3];
            if (this.columnNames[1].equalsIgnoreCase("description")) {
                newNames[0] = this.columnNames[0];
                newNames[1] = this.columnNames[1];
                newNames[2] = "NO DATA";
            } else {
                newNames[0] = this.columnNames[0];
                newNames[1] = "description";
                newNames[2] = this.columnNames[1];
            }
            this.columnNames = newNames;
        }
    }

    public HashMap<Integer, GeneExpression> getExpressionMatrix(HashSet<Integer> subset) {
        if (subset == null || subset.size() == 0) {
            return null;
        }
        HashMap<Integer, GeneExpression> expression_subset = new HashMap<Integer, GeneExpression>();
        for (Integer k : subset) {
            if (!this.expressionMatrix.containsKey(k)) continue;
            expression_subset.put(k, this.expressionMatrix.get(k));
        }
        return expression_subset;
    }

    public double getMaxExpression(HashMap<Integer, GeneExpression> currentMatrix) {
        double max = 0.0;
        if (currentMatrix != null) {
            Iterator<Integer> i = currentMatrix.keySet().iterator();
            while (i.hasNext()) {
                Double[] currentRow = currentMatrix.get(i.next()).getExpression();
                for (int j = 0; j < currentRow.length; ++j) {
                    if (!(max < currentRow[j])) continue;
                    max = currentRow[j];
                }
            }
        }
        return max;
    }

    public double getMinExpression(HashMap<Integer, GeneExpression> currentMatrix) {
        double min = 0.0;
        if (currentMatrix != null) {
            Iterator<Integer> i = currentMatrix.keySet().iterator();
            while (i.hasNext()) {
                Double[] currentRow = currentMatrix.get(i.next()).getExpression();
                for (int j = 0; j < currentRow.length; ++j) {
                    if (!(min > currentRow[j])) continue;
                    min = currentRow[j];
                }
            }
        }
        return min;
    }

    public void rowNormalizeMatrix() {
        if (this.expressionMatrix == null) {
            return;
        }
        this.expressionMatrix_rowNormalized = new HashMap();
        for (Integer key : this.expressionMatrix.keySet()) {
            GeneExpression currentexpression = this.expressionMatrix.get(key);
            String Name = currentexpression.getName();
            String description = currentexpression.getDescription();
            GeneExpression norm_row = new GeneExpression(Name, description);
            Double[] currentexpression_row_normalized = currentexpression.rowNormalize();
            norm_row.setExpression(currentexpression_row_normalized);
            this.expressionMatrix_rowNormalized.put(key, norm_row);
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public void setNumConditions(int numConditions) {
        this.numConditions = numConditions;
    }

    public int getNumGenes() {
        return this.numGenes;
    }

    public void setNumGenes(int numGenes) {
        this.numGenes = numGenes;
    }

    public HashMap<Integer, GeneExpression> getExpressionMatrix() {
        return this.expressionMatrix;
    }

    public void setExpressionMatrix(HashMap<Integer, GeneExpression> expressionMatrix) {
        this.expressionMatrix = expressionMatrix;
    }

    public HashMap<Integer, GeneExpression> getExpressionMatrix_rowNormalized() {
        return this.expressionMatrix_rowNormalized;
    }

    public void setExpressionMatrix_rowNormalized(HashMap<Integer, GeneExpression> expressionMatrix_rowNormalized) {
        this.expressionMatrix_rowNormalized = expressionMatrix_rowNormalized;
    }

    public double getMaxExpression() {
        return this.maxExpression;
    }

    public void setMaxExpression(double maxExpression) {
        this.maxExpression = maxExpression;
    }

    public double getMinExpression() {
        return this.minExpression;
    }

    public void setMinExpression(double minExpression) {
        this.minExpression = minExpression;
    }

    public String[] getPhenotypes() {
        return this.phenotypes;
    }

    public void setPhenotypes(String[] phenotypes) {
        this.phenotypes = phenotypes;
    }

    public String getPhenotype1() {
        return this.phenotype1;
    }

    public void setPhenotype1(String phenotype1) {
        this.phenotype1 = phenotype1;
    }

    public String getPhenotype2() {
        return this.phenotype2;
    }

    public void setPhenotype2(String phenotype2) {
        this.phenotype2 = phenotype2;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String toString() {
        StringBuffer expressionSb = new StringBuffer();
        for (int i = 0; i < this.columnNames.length; ++i) {
            expressionSb.append(this.columnNames[i] + "\t");
        }
        expressionSb.append("\n");
        Iterator<Integer> i = this.expressionMatrix.keySet().iterator();
        while (i.hasNext()) {
            expressionSb.append(this.expressionMatrix.get(i.next()).toString());
        }
        return expressionSb.toString();
    }

    public String toString(String ds) {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%filename\t" + this.filename + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%phenotype1\t" + this.phenotype1 + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%phenotype2\t" + this.phenotype2 + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%numConditions\t" + this.numConditions + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%numGenes\t" + this.numGenes + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%minExpression\t" + this.minExpression + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%maxExpression\t" + this.maxExpression + "\n");
        if (this.phenotypes != null) {
            paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%phenotypes\t" + this.phenotypes.toString() + "\n");
        }
        return paramVariables.toString();
    }

    public Set<Integer> getGeneIds() {
        return this.expressionMatrix.keySet();
    }

    public HashMap<String, Ranking> getRanks() {
        return this.ranks;
    }

    public void setRanks(HashMap<String, Ranking> ranks) {
        this.ranks = ranks;
    }

    public void addRanks(String ranks_name, Ranking new_rank) {
        if (this.ranks != null && ranks_name != null && new_rank != null) {
            this.ranks.put(ranks_name, new_rank);
        }
    }

    public Ranking getRanksByName(String ranks_name) {
        if (this.ranks != null) {
            return this.ranks.get(ranks_name);
        }
        return null;
    }

    public HashSet<String> getAllRanksNames() {
        HashSet<String> allnames = new HashSet<String>();
        if (this.ranks != null && !this.ranks.isEmpty()) {
            for (String current_name : this.ranks.keySet()) {
                if (current_name == null) continue;
                allnames.add(current_name);
            }
        }
        return allnames;
    }

    public boolean haveRanks() {
        return this.ranks != null && this.ranks.size() > 0;
    }

    public void createNewRanking(String name) {
        Ranking new_ranking = new Ranking();
        this.ranks.put(name, new_ranking);
    }
}

