/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.CytoscapeSessionWriter;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import org.baderlab.csplugins.enrichmentmap.BuildEnrichmentMapTask;
import org.baderlab.csplugins.enrichmentmap.BulkEMCreationPanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;

public class BuildBulkEnrichmentMapActionListener
implements ActionListener {
    private JTaskConfig config;
    private BulkEMCreationPanel inputPanel;

    public BuildBulkEnrichmentMapActionListener(BulkEMCreationPanel panel) {
        this.inputPanel = panel;
    }

    public void actionPerformed(ActionEvent event) {
        this.config = new JTaskConfig();
        this.config.displayCancelButton(true);
        this.config.displayCloseButton(true);
        this.config.displayStatus(true);
        EnrichmentMapParameters params = this.inputPanel.getParams();
        params.setBulkEM(true);
        String mainDirectory = params.getGSEAResultsDirName();
        String[] gsea_results = new File(mainDirectory).list();
        int lower = params.getLowerlimit();
        int upper = params.getUpperlimit();
        if (lower == 1 && upper == 1) {
            upper = gsea_results.length;
        }
        int counter = 0;
        for (int i = 0; i < gsea_results.length; ++i) {
            File current = new File(mainDirectory, gsea_results[i]);
            if (!current.isDirectory()) continue;
            String[] children = current.list();
            boolean foundRpt = false;
            for (int k = 0; k < children.length; ++k) {
                if (!children[k].endsWith(".rpt")) continue;
                foundRpt = true;
                if (++counter < lower || counter >= upper) continue;
                File rpt_file = new File(current, children[k]);
                this.inputPanel.populateFieldsFromRpt(rpt_file);
                params = this.inputPanel.getParams();
                String rpt_name = rpt_file.getName();
                String[] tokens = rpt_name.split("\\.");
                String name = tokens[0];
                params.setNetworkName(name);
                BuildEnrichmentMapTask new_map = new BuildEnrichmentMapTask(params);
                boolean success = TaskManager.executeTask((Task)new_map, (JTaskConfig)this.config);
                Cytoscape.getCurrentNetworkView().fitContent();
                Cytoscape.getCurrentNetworkView().setZoom(0.5);
                Cytoscape.getCurrentNetworkView().updateView();
                try {
                    File outputFile = new File(mainDirectory, name + ".xgmml");
                    CyNetworkView view = Cytoscape.getCurrentNetworkView();
                    CyNetwork nw = Cytoscape.getCurrentNetwork();
                    FileWriter writer = new FileWriter(outputFile);
                    XGMMLWriter exporter = new XGMMLWriter(nw, view);
                    exporter.write((Writer)writer);
                    writer.close();
                    CytoscapeSessionWriter session = new CytoscapeSessionWriter(mainDirectory + File.separator + name + ".cys");
                    System.out.println(mainDirectory + File.separator + name + ".cys");
                    session.writeSessionToDisk();
                    Cytoscape.destroyNetwork((String)name);
                    System.gc();
                    Cytoscape.createNewSession();
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("Can't export network " + name + " .");
                    continue;
                }
                catch (IOException e2) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (URISyntaxException e3) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (JAXBException e4) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (Exception eRest) {
                    System.out.println("Can't export network " + name + ".cys");
                }
            }
        }
    }
}

