/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.colorgradient;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorGradientMapper {
    public static ColorGradientMapper getInstance() {
        return new ColorGradientMapper();
    }

    public static Color getColorGradient(ColorGradientTheme theme, ColorGradientRange range, String gene, Double measurement) {
        if (measurement == null || measurement.equals(Double.NaN)) {
            return theme.getNoDataColor();
        }
        ContinuousMapping continuousMapping = ColorGradientMapper.getContinuousMapping(theme, range);
        if (continuousMapping == null) {
            return theme.getNoDataColor();
        }
        HashMap<String, Double> attrBundle = new HashMap<String, Double>();
        attrBundle.put(gene, measurement);
        ContinuousRangeCalculator calculator = ColorGradientMapper.createContinuousRangeCalculatorHack(ColorGradientMapper.getAllPointsHack(continuousMapping), continuousMapping.getInterpolator(), attrBundle);
        return (Color)calculator.calculateRangeValue(gene);
    }

    public static ContinuousMapping getContinuousMapping(ColorGradientTheme colorGradientTheme, ColorGradientRange colorGradientRange) {
        if (colorGradientTheme == null || colorGradientRange == null) {
            return null;
        }
        ContinuousMapping continuousMapping = new ContinuousMapping((Object)Color.WHITE, 1);
        continuousMapping.setInterpolator((Interpolator)new LinearNumberToColorInterpolator());
        Color minColor = colorGradientTheme.getMinColor();
        Color medColor = colorGradientTheme.getCenterColor();
        Color maxColor = colorGradientTheme.getMaxColor();
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)minColor, (Object)minColor, (Object)minColor);
        BoundaryRangeValues bv1a = new BoundaryRangeValues((Object)medColor, (Object)medColor, (Object)medColor);
        BoundaryRangeValues bv1b = new BoundaryRangeValues((Object)medColor, (Object)medColor, (Object)medColor);
        BoundaryRangeValues bv2 = new BoundaryRangeValues((Object)maxColor, (Object)maxColor, (Object)maxColor);
        continuousMapping.addPoint(colorGradientRange.getMinValue(), bv0);
        continuousMapping.addPoint(colorGradientRange.getCenterLowValue(), bv1a);
        continuousMapping.addPoint(colorGradientRange.getCenterHighValue(), bv1b);
        continuousMapping.addPoint(colorGradientRange.getMaxValue(), bv2);
        return continuousMapping;
    }

    private static ContinuousRangeCalculator createContinuousRangeCalculatorHack(ArrayList<?> points, Interpolator interpolator, Map<String, Double> attributes) {
        Constructor constructor = null;
        for (Class type : new Class[]{ArrayList.class, List.class}) {
            try {
                constructor = ContinuousRangeCalculator.class.getConstructor(type, Interpolator.class, Map.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (constructor == null) {
            throw new RuntimeException();
        }
        try {
            return (ContinuousRangeCalculator)constructor.newInstance(points, interpolator, attributes);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static ArrayList<?> getAllPointsHack(ContinuousMapping mapping) {
        try {
            Method method = ContinuousMapping.class.getMethod("getAllPoints", new Class[0]);
            return (ArrayList)method.invoke((Object)mapping, new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getColorGradientAsString(ColorGradientTheme theme, ColorGradientRange range, String gene, Double measurement) {
        Color color = ColorGradientMapper.getColorGradient(theme, range, gene, measurement);
        int red = color.getRed();
        String redColor = Integer.toHexString(red);
        if (red <= 9) {
            redColor = "0" + redColor;
        }
        int green = color.getGreen();
        String greenColor = Integer.toHexString(green);
        if (green <= 9) {
            greenColor = "0" + greenColor;
        }
        int blue = color.getBlue();
        String blueColor = Integer.toHexString(blue);
        if (blue <= 9) {
            blueColor = "0" + blueColor;
        }
        return redColor + greenColor + blueColor;
    }

    private ColorGradientMapper() {
    }
}

