/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.InitializeGenesetsOfInterestTask;
import org.baderlab.csplugins.enrichmentmap.task.LoadDataSetTask;
import org.baderlab.csplugins.enrichmentmap.task.VisualizeEnrichmentMapTask;

public class BuildEnrichmentMapTask
implements Task {
    private EnrichmentMapParameters params = new EnrichmentMapParameters();
    private String name = null;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public BuildEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params.copyInputParameters(params);
    }

    public BuildEnrichmentMapTask(EnrichmentMapParameters params, String name) {
        this(params);
        this.name = name;
    }

    public BuildEnrichmentMapTask(EnrichmentMapParameters params, String name, TaskMonitor taskMonitor) {
        this(params);
        this.name = name;
        this.taskMonitor = taskMonitor;
    }

    public void buildEnrichmentMap() {
        EnrichmentMap map = new EnrichmentMap(this.params, this.name);
        DataSet dataset = map.getDataset("Dataset 1");
        try {
            LoadDataSetTask loaddata = new LoadDataSetTask(dataset, this.taskMonitor);
            loaddata.run();
            if (map.getParams().isTwoDatasets() && map.getDatasets().containsKey("Dataset 2")) {
                DataSet dataset2 = map.getDataset("Dataset 2");
                LoadDataSetTask loaddataset2 = new LoadDataSetTask(dataset2, this.taskMonitor);
                loaddataset2.run();
                this.params.setData2(true);
                if (!dataset.getDatasetGenes().containsAll(dataset2.getDatasetGenes()) || !dataset2.getDatasetGenes().containsAll(dataset.getDatasetGenes())) {
                    this.params.setTwoDistinctExpressionSets(true);
                }
            }
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to load DataSet");
            return;
        }
        map.filterGenesets();
        if (!map.checkGenesets()) {
            throw new IllegalThreadStateException("No genes in the expression file are found in the GMT file ");
        }
        try {
            InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(map, this.taskMonitor);
            genesets_init.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
            return;
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Genesets defined in the Enrichment results file are not found in  gene set file (GMT).  (Click \"Show Error details\" to see which genesets is not found)Please make sure you are using the correct GMT file.");
            return;
        }
        try {
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(map, this.taskMonitor);
            similarities.run();
            VisualizeEnrichmentMapTask map_viz = new VisualizeEnrichmentMapTask(map, this.taskMonitor);
            map_viz.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to build/visualize map");
        }
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GSEA results");
    }
}

