/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;

public class GMTFileReaderTask
implements Task {
    private EnrichmentMap map;
    private String GMTFileName;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private SetOfGeneSets setOfgenesets;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    public static final int ENRICHMENT_GMT = 1;
    public static final int SIGNATURE_GMT = 2;

    public GMTFileReaderTask(DataSet dataset, TaskMonitor taskMonitor) {
        this(dataset);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(DataSet dataset) {
        this.GMTFileName = dataset.getSetofgenesets().getFilename();
        this.genes = dataset.getMap().getGenes();
        this.hashkey2gene = dataset.getMap().getHashkey2gene();
        this.setOfgenesets = dataset.getSetofgenesets();
        this.map = dataset.getMap();
    }

    public GMTFileReaderTask(EnrichmentMap map, PostAnalysisParameters params, TaskMonitor taskMonitor, int genesets_file) {
        this(map, params, genesets_file);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(EnrichmentMap map, PostAnalysisParameters params, int genesets_file) {
        this.map = map;
        this.genes = map.getGenes();
        this.hashkey2gene = map.getHashkey2gene();
        if (genesets_file != 1) {
            if (genesets_file == 2) {
                this.GMTFileName = params.getSignatureGMTFileName();
                this.setOfgenesets = params.getSignatureGenesets();
            } else {
                throw new IllegalArgumentException("argument not allowed:" + genesets_file);
            }
        }
    }

    public String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public void parse() {
        HashMap<String, GeneSet> genesets = this.setOfgenesets.getGenesets();
        TextFileReader reader = new TextFileReader(this.GMTFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        try {
            for (int i = 0; i < lines.length; ++i) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (tokens.length < 2) continue;
                String Name = tokens[0].toUpperCase().trim();
                String description = tokens[1].trim();
                GeneSet gs = new GeneSet(Name, description);
                int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
                long timeRemaining = this.maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + this.maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                for (int j = 2; j < tokens.length; ++j) {
                    if (this.genes.containsKey(tokens[j].toUpperCase())) {
                        gs.addGene(this.genes.get(tokens[j].toUpperCase()));
                        continue;
                    }
                    if (tokens[j].equalsIgnoreCase("")) continue;
                    int value = this.map.getNumberOfGenes();
                    this.genes.put(tokens[j].toUpperCase(), value);
                    this.hashkey2gene.put(value, tokens[j].toUpperCase());
                    this.map.setNumberOfGenes(value + 1);
                    gs.addGene(this.genes.get(tokens[j].toUpperCase()));
                }
                genesets.put(Name, gs);
                this.setOfgenesets.addGenesetType(gs.getSource());
            }
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException((Throwable)e, "Loading of GMT file cancelled");
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GMT file");
    }
}

