/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.EnrichmentMapInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapManager
implements PropertyChangeListener {
    private static EnrichmentMapManager manager = null;
    private HashMap<String, EnrichmentMap> cyNetworkList = new HashMap();
    private HashMap<String, PostAnalysisParameters> cyNetworkListPostAnalysis = new HashMap();
    private ParametersPanel parameterPanel;
    private HeatMapPanel nodesOverlapPanel;
    private HeatMapPanel edgesOverlapPanel;
    private EnrichmentMapInputPanel inputWindow;
    private PostAnalysisInputPanel analysisWindow;

    public static EnrichmentMapManager getInstance() {
        if (manager == null) {
            manager = new EnrichmentMapManager();
        }
        return manager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        CyNetwork cyNetwork;
        String networkId;
        boolean relevantEventFlag = false;
        if (event.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            this.networkDestroyed((String)event.getNewValue());
            relevantEventFlag = true;
        } else if (event.getPropertyName().equals("NETWORK_VIEW_DESTROYED")) {
            relevantEventFlag = true;
        } else if (event.getPropertyName().equals("NETWORK_VIEW_CREATED")) {
            this.networkFocusEvent(event, false);
        } else if (event.getPropertyName().equals("NETWORK_VIEW_FOCUSED")) {
            this.networkFocusEvent(event, false);
        } else if (event.getPropertyName().equals("NETWORK_TITLE_MODIFIED") && this.cyNetworkList.containsKey(networkId = (cyNetwork = Cytoscape.getCurrentNetwork()).getIdentifier())) {
            EnrichmentMap currentNetworkParams = this.cyNetworkList.get(networkId);
            currentNetworkParams.setName(cyNetwork.getTitle());
        }
        if (relevantEventFlag && !this.networkViewsRemain()) {
            this.onZeroNetworkViewsRemain();
        }
    }

    private EnrichmentMapManager() {
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getDesktop().getNetworkViewManager().getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
        this.parameterPanel = new ParametersPanel();
        URL EMIconURL = Thread.currentThread().getContextClassLoader().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        if (EMIcon != null) {
            cytoSidePanel.add("Legend", (Icon)EMIcon, (Component)this.parameterPanel);
        } else {
            cytoSidePanel.add("Legend", (Component)this.parameterPanel);
        }
        cytoSidePanel.setSelectedIndex(cytoSidePanel.indexOfComponent((Component)this.parameterPanel));
        cytoSidePanel.setState(CytoPanelState.DOCK);
        this.nodesOverlapPanel = new HeatMapPanel(true);
        this.edgesOverlapPanel = new HeatMapPanel(false);
        if (EMIcon != null) {
            cytoPanel.add("EM Overlap Expression viewer", (Icon)EMIcon, (Component)this.edgesOverlapPanel);
            cytoPanel.add("EM Geneset Expression viewer", (Icon)EMIcon, (Component)this.nodesOverlapPanel);
        } else {
            cytoPanel.add("EM Overlap Expression viewer", (Component)this.edgesOverlapPanel);
            cytoPanel.add("EM Geneset Expression viewer", (Component)this.nodesOverlapPanel);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, EnrichmentMap map) {
        if (!this.cyNetworkList.containsKey(cyNetwork.getIdentifier())) {
            this.cyNetworkList.put(cyNetwork.getIdentifier(), map);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, PostAnalysisParameters paParams) {
        if (!this.cyNetworkListPostAnalysis.containsKey(cyNetwork.getIdentifier())) {
            this.cyNetworkListPostAnalysis.put(cyNetwork.getIdentifier(), paParams);
        }
    }

    private void networkFocusEvent(PropertyChangeEvent event, boolean sessionLoaded) {
        String networkId = null;
        CyNetwork cyNetwork = null;
        Object newValue = event.getNewValue();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
        if (event.getPropertyName().equals(Cytoscape.SESSION_LOADED)) {
            cyNetwork = Cytoscape.getCurrentNetwork();
            networkId = cyNetwork.getIdentifier();
        } else if (newValue instanceof CyNetwork) {
            cyNetwork = (CyNetwork)newValue;
            networkId = cyNetwork.getIdentifier();
        } else if (newValue instanceof String) {
            networkId = (String)newValue;
            cyNetwork = Cytoscape.getNetwork((String)networkId);
        } else if (newValue instanceof CyNetworkView) {
            cyNetwork = ((CyNetworkView)newValue).getNetwork();
            networkId = cyNetwork.getIdentifier();
        }
        if (networkId != null && !sessionLoaded) {
            if (this.cyNetworkList.containsKey(networkId)) {
                this.nodesOverlapPanel.clearPanel();
                this.edgesOverlapPanel.clearPanel();
                EnrichmentMap currentNetwork = this.cyNetworkList.get(networkId);
                PostAnalysisParameters currentPaParams = this.cyNetworkListPostAnalysis.get(networkId);
                this.parameterPanel.updatePanel(currentNetwork);
                if (this.inputWindow != null) {
                    this.inputWindow.updateContents(currentNetwork.getParams());
                }
                if (this.analysisWindow != null) {
                    this.analysisWindow.updateContents(currentNetwork.getParams());
                }
                this.nodesOverlapPanel.updatePanel(currentNetwork);
                this.edgesOverlapPanel.updatePanel(currentNetwork);
                this.nodesOverlapPanel.revalidate();
                this.edgesOverlapPanel.revalidate();
            } else if (event.getPropertyName().equals("NETWORK_VIEW_CREATED")) {
                this.nodesOverlapPanel.clearPanel();
                this.edgesOverlapPanel.clearPanel();
                this.nodesOverlapPanel.revalidate();
                this.edgesOverlapPanel.revalidate();
            }
        }
    }

    private void networkDestroyed(String networkId) {
        if (this.cyNetworkList.containsKey(networkId)) {
            EnrichmentMap currentNetworkParams = this.cyNetworkList.get(networkId);
            this.cyNetworkList.remove(networkId);
        }
        if (this.cyNetworkListPostAnalysis.containsKey(networkId)) {
            PostAnalysisParameters currentPaParams = this.cyNetworkListPostAnalysis.get(networkId);
            this.cyNetworkListPostAnalysis.remove(networkId);
        }
    }

    private boolean networkViewsRemain() {
        for (String id : this.cyNetworkList.keySet()) {
            CyNetworkView cyNetworkView = Cytoscape.getNetworkView((String)id);
            if (cyNetworkView == null) continue;
            return true;
        }
        return false;
    }

    protected void onZeroNetworkViewsRemain() {
    }

    public ParametersPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public HeatMapPanel getNodesOverlapPanel() {
        return this.nodesOverlapPanel;
    }

    public HeatMapPanel getEdgesOverlapPanel() {
        return this.edgesOverlapPanel;
    }

    public HashMap<String, EnrichmentMap> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public EnrichmentMap getMap(String name) {
        if (this.cyNetworkList.containsKey(name)) {
            return this.cyNetworkList.get(name);
        }
        return null;
    }

    public EnrichmentMapInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(EnrichmentMapInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public PostAnalysisInputPanel getAnalysisWindow() {
        return this.analysisWindow;
    }

    public void setAnalysisWindow(PostAnalysisInputPanel analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    public boolean isEnrichmentMap(String networkID) {
        return this.cyNetworkList.containsKey(networkID);
    }
}

