/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.commands;

import cytoscape.command.AbstractCommandHandler;
import cytoscape.command.CyCommandException;
import cytoscape.command.CyCommandManager;
import cytoscape.command.CyCommandResult;
import cytoscape.layout.Tunable;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.task.BuildEnrichmentMapTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapCommandHandler
extends AbstractCommandHandler {
    private static String command = "build";
    private static String edbdir = "edbdir";
    private static String pvalue = "pvalue";
    private static String qvalue = "qvalue";
    private static String overlap = "overlap";
    private static String expressionfile = "expressionfile";
    private static String similaritymetric = "similaritymetric";
    private static String combinedconstant = "combinedconstant";

    public EnrichmentMapCommandHandler(String namespace) {
        super(CyCommandManager.reserveNamespace((String)namespace));
        this.addDescription(command, "Build an enrichmentmap from GSEA results (in an edb directory)");
        this.addArgument(command, edbdir);
        this.addArgument(command, pvalue);
        this.addArgument(command, qvalue);
        this.addArgument(command, overlap);
        this.addArgument(command, similaritymetric);
        this.addArgument(command, combinedconstant);
        this.addArgument(command, expressionfile);
    }

    public CyCommandResult execute(String arg0, Map<String, Object> arg1) throws CyCommandException {
        CyCommandResult results = new CyCommandResult();
        String file = "";
        Double pvalue_loaded = 0.05;
        Double qvalue_loaded = 0.25;
        Double overlap_loaded = 0.5;
        String expression_loaded = "";
        Double combinedconstant_loaded = 0.5;
        String similaritymetric_loaded = "OVERLAP";
        if (arg1.containsKey(edbdir)) {
            file = (String)arg1.get(edbdir);
        }
        if (arg1.containsKey(expressionfile)) {
            expression_loaded = (String)arg1.get(expressionfile);
        }
        if (arg1.containsKey(pvalue)) {
            try {
                pvalue_loaded = Double.parseDouble((String)arg1.get(pvalue));
            }
            catch (NumberFormatException e) {
                System.out.println("the pvalue can only be a number (i.e. pvalue=0.05).  Ignored pvalue setting by user and using default.");
                pvalue_loaded = 0.05;
            }
        }
        if (arg1.containsKey(qvalue)) {
            try {
                qvalue_loaded = Double.parseDouble((String)arg1.get(qvalue));
            }
            catch (NumberFormatException e) {
                System.out.println("the qvalue can only be a number (i.e. qvalue=0.25).  Ignored qvalue setting by user and using default.");
                qvalue_loaded = 0.25;
            }
        }
        if (arg1.containsKey(overlap)) {
            try {
                overlap_loaded = Double.parseDouble((String)arg1.get(overlap));
            }
            catch (NumberFormatException e) {
                System.out.println("the overlap can only be a number (i.e. overlap=0.50).  Ignored overlap setting by user and using default.");
                overlap_loaded = 0.5;
            }
        }
        if (arg1.containsKey(combinedconstant)) {
            try {
                combinedconstant_loaded = Double.parseDouble((String)arg1.get(combinedconstant));
            }
            catch (NumberFormatException e) {
                System.out.println("the combinedconstant can only be a number (i.e. combinedconstant=0.5).  Ignored combinedconstant setting by user and using default.");
                combinedconstant_loaded = 0.05;
            }
        }
        if (arg1.containsKey(similaritymetric)) {
            similaritymetric_loaded = (String)arg1.get(similaritymetric);
            similaritymetric_loaded = similaritymetric_loaded.equalsIgnoreCase("OVERLAP") ? "OVERLAP" : (similaritymetric_loaded.equalsIgnoreCase("JACCARD") ? "JACCARD" : (similaritymetric_loaded.equalsIgnoreCase("COMBINED") ? "COMBINED" : "OVERLAP"));
        }
        EnrichmentMapParameters params = new EnrichmentMapParameters();
        String file_sep = System.getProperty("file.separator");
        String testEdbResultsFileName = file + file_sep + "results.edb";
        String testgmtFileName = file + file_sep + "gene_sets.gmt";
        String testrnkFileName = "";
        File directory = new File(file);
        String[] dir_listing = directory.list();
        if (dir_listing.length > 0) {
            for (int i = 0; i < dir_listing.length; ++i) {
                if (dir_listing[i].endsWith("rnk") && testrnkFileName.equals("")) {
                    testrnkFileName = file + file_sep + dir_listing[i];
                    continue;
                }
                if (!dir_listing[i].endsWith("rnk") || testrnkFileName.equals("")) continue;
                System.out.println("There are two rnk files in the edb directory.  Using the first one found");
            }
        }
        DataSetFiles files = new DataSetFiles();
        files.setEnrichmentFileName1(testEdbResultsFileName);
        files.setGMTFileName(testgmtFileName);
        if (!testrnkFileName.equals("")) {
            files.setRankedFile(testrnkFileName);
        }
        if (!expression_loaded.equals("")) {
            files.setExpressionFileName(expression_loaded);
            params.setData(true);
        }
        params.addFiles("Dataset 1", files);
        params.setMethod("GSEA");
        params.setSimilarityMetric(similaritymetric_loaded);
        params.setSimilarityCutOff(overlap_loaded);
        params.setPvalue(pvalue_loaded);
        params.setQvalue(qvalue_loaded);
        params.setFDR(true);
        params.setCombinedConstant(combinedconstant_loaded);
        JTaskConfig config = new JTaskConfig();
        config.displayCancelButton(true);
        config.displayCloseButton(true);
        config.displayStatus(true);
        BuildEnrichmentMapTask new_map = new BuildEnrichmentMapTask(params);
        boolean success = TaskManager.executeTask((Task)new_map, (JTaskConfig)config);
        return results;
    }

    public CyCommandResult execute(String arg0, Collection<Tunable> arg1) throws CyCommandException {
        return this.execute(command, this.createKVMap(arg1));
    }
}

