/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeSimilarityTask
implements Task {
    static final int ENRICHMENT = 0;
    static final int SIGNATURE = 1;
    private EnrichmentMapParameters params;
    private int type;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private CyLogger logger = CyLogger.getLogger(ComputeSimilarityTask.class);

    public ComputeSimilarityTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public ComputeSimilarityTask(EnrichmentMapParameters params) {
        this.params = params;
        this.geneset_similarities = new HashMap();
        this.type = 0;
    }

    public ComputeSimilarityTask(EnrichmentMapParameters params, int type) {
        this.params = params;
        this.geneset_similarities = new HashMap();
        this.type = type;
    }

    public boolean computeGenesetSimilarities() {
        try {
            HashMap<String, GeneSet> genesetsInnerLoop;
            HashMap<String, GeneSet> genesetsOfInterest = this.params.getGenesetsOfInterest();
            String edgeType = "pp";
            if (this.type == 0) {
                genesetsInnerLoop = genesetsOfInterest;
                edgeType = this.params.getEnrichment_edge_type();
            } else if (this.type == 1) {
                genesetsInnerLoop = this.params.getSignatureGenesets();
                edgeType = "sig";
            } else {
                genesetsInnerLoop = genesetsOfInterest;
                this.logger.error("Invalid type argument: " + this.type);
            }
            int currentProgress = 0;
            int maxValue = genesetsOfInterest.size();
            int enrichment_set = 0;
            if (this.params.isTwoDistinctExpressionSets()) {
                enrichment_set = 1;
                maxValue = genesetsOfInterest.size() + this.params.getGenesetsOfInterest_set2().size();
            }
            Iterator<String> i = genesetsOfInterest.keySet().iterator();
            while (i.hasNext()) {
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Computing Geneset similarity " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                String geneset1_name = i.next().toString();
                Iterator<String> j = genesetsInnerLoop.keySet().iterator();
                while (j.hasNext()) {
                    double coeffecient;
                    String similarity_key2;
                    String similarity_key1;
                    String geneset2_name = j.next().toString();
                    if (enrichment_set == 0) {
                        similarity_key1 = geneset1_name + " (" + edgeType + ") " + geneset2_name;
                        similarity_key2 = geneset2_name + " (" + edgeType + ") " + geneset1_name;
                    } else {
                        similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set1" + ") " + geneset2_name;
                        similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set1" + ") " + geneset1_name;
                    }
                    if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                    GeneSet geneset1 = genesetsOfInterest.get(geneset1_name);
                    GeneSet geneset2 = genesetsOfInterest.get(geneset2_name);
                    if (geneset1 == null) {
                        geneset1 = genesetsInnerLoop.get(geneset1_name);
                    }
                    if (geneset2 == null) {
                        geneset2 = genesetsInnerLoop.get(geneset2_name);
                    }
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                        coeffecient = (double)intersection.size() / (double)union.size();
                    } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                        coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    } else {
                        double jaccard = (double)intersection.size() / (double)union.size();
                        double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        double k = this.params.getCombinedConstant();
                        coeffecient = k * overlap + (1.0 - k) * jaccard;
                    }
                    GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.params.getEnrichment_edge_type(), intersection, enrichment_set);
                    if (this.type == 1) {
                        this.geneset_similarities.put(similarity_key2, comparison);
                        continue;
                    }
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
            }
            if (this.params.isTwoDistinctExpressionSets()) {
                enrichment_set = 2;
                HashMap<String, GeneSet> genesetsOfInterest_set2 = this.params.getGenesetsOfInterest_set2();
                genesetsInnerLoop = genesetsOfInterest_set2;
                Iterator<String> i2 = genesetsOfInterest_set2.keySet().iterator();
                while (i2.hasNext()) {
                    int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                    long timeRemaining = maxValue - currentProgress;
                    if (this.taskMonitor != null) {
                        this.taskMonitor.setPercentCompleted(percentComplete);
                        this.taskMonitor.setStatus("Computing Geneset similarity " + currentProgress + " of " + maxValue);
                        this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                    }
                    ++currentProgress;
                    String geneset1_name = i2.next().toString();
                    Iterator<String> j = genesetsInnerLoop.keySet().iterator();
                    while (j.hasNext()) {
                        double coeffecient;
                        String geneset2_name = j.next().toString();
                        String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set2" + ") " + geneset2_name;
                        String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set2" + ") " + geneset1_name;
                        if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                        GeneSet geneset1 = genesetsOfInterest_set2.get(geneset1_name);
                        GeneSet geneset2 = genesetsOfInterest_set2.get(geneset2_name);
                        HashSet<Integer> genes1 = geneset1.getGenes();
                        HashSet<Integer> genes2 = geneset2.getGenes();
                        HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                        intersection.retainAll(genes2);
                        HashSet<Integer> union = new HashSet<Integer>(genes1);
                        union.addAll(genes2);
                        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                            coeffecient = (double)intersection.size() / (double)union.size();
                        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                            coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        } else {
                            double jaccard = (double)intersection.size() / (double)union.size();
                            double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                            double k = this.params.getCombinedConstant();
                            coeffecient = k * overlap + (1.0 - k) * jaccard;
                        }
                        GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.params.getEnrichment_edge_type(), intersection, enrichment_set);
                        if (this.type == 1) {
                            this.geneset_similarities.put(similarity_key2, comparison);
                            continue;
                        }
                        this.geneset_similarities.put(similarity_key1, comparison);
                    }
                }
                HashMap<String, GeneSet> sig_genesets_set1 = this.params.getGenesetsOfInterest();
                HashMap<String, GeneSet> sig_genesets_set2 = this.params.getGenesetsOfInterest_set2();
                HashMap<String, GeneSet> genesetsInnerLoop_missingedges = this.params.getGenesets();
                HashMap<String, GeneSet> genesetsOfInterest_missingedges = this.params.getGenesets();
                HashMap<String, EnrichmentResult> dataset1_results = this.params.getEnrichmentResults1();
                Iterator<String> i3 = genesetsOfInterest_missingedges.keySet().iterator();
                while (i3.hasNext()) {
                    enrichment_set = 1;
                    String geneset1_name = i3.next().toString();
                    if (!dataset1_results.containsKey(geneset1_name)) continue;
                    Iterator<String> j = genesetsInnerLoop_missingedges.keySet().iterator();
                    while (j.hasNext()) {
                        double coeffecient;
                        String geneset2_name = j.next().toString();
                        if (!dataset1_results.containsKey(geneset2_name)) continue;
                        String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set1" + ") " + geneset2_name;
                        String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set1" + ") " + geneset1_name;
                        if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2) || !(sig_genesets_set1.containsKey(geneset1_name) && !sig_genesets_set2.containsKey(geneset1_name) && !sig_genesets_set1.containsKey(geneset2_name) && sig_genesets_set2.containsKey(geneset2_name) || !sig_genesets_set1.containsKey(geneset1_name) && sig_genesets_set2.containsKey(geneset1_name) && sig_genesets_set1.containsKey(geneset2_name) && !sig_genesets_set2.containsKey(geneset2_name)) && (!sig_genesets_set2.containsKey(geneset1_name) || !sig_genesets_set2.containsKey(geneset2_name))) continue;
                        GeneSet geneset1 = genesetsOfInterest_missingedges.get(geneset1_name);
                        GeneSet geneset2 = genesetsOfInterest_missingedges.get(geneset2_name);
                        HashSet<Integer> genes1 = geneset1.getGenes();
                        HashSet<Integer> genes2 = geneset2.getGenes();
                        HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                        intersection.retainAll(genes2);
                        HashSet<Integer> union = new HashSet<Integer>(genes1);
                        union.addAll(genes2);
                        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                            coeffecient = (double)intersection.size() / (double)union.size();
                        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                            coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        } else {
                            double jaccard = (double)intersection.size() / (double)union.size();
                            double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                            double k = this.params.getCombinedConstant();
                            coeffecient = k * overlap + (1.0 - k) * jaccard;
                        }
                        GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.params.getEnrichment_edge_type(), intersection, enrichment_set);
                        if (this.type == 1) {
                            this.geneset_similarities.put(similarity_key2, comparison);
                            continue;
                        }
                        this.geneset_similarities.put(similarity_key1, comparison);
                    }
                }
                HashMap<String, GeneSet> genesetsInnerLoop_missingedges_d2 = this.params.getGenesets_set2();
                HashMap<String, GeneSet> genesetsOfInterest_missingedges_d2 = this.params.getGenesets_set2();
                HashMap<String, EnrichmentResult> dataset2_results = this.params.getEnrichmentResults2();
                Iterator<String> i4 = genesetsOfInterest_missingedges_d2.keySet().iterator();
                while (i4.hasNext()) {
                    enrichment_set = 2;
                    String geneset1_name = i4.next().toString();
                    if (!dataset2_results.containsKey(geneset1_name)) continue;
                    Iterator<String> j = genesetsInnerLoop_missingedges_d2.keySet().iterator();
                    while (j.hasNext()) {
                        double coeffecient;
                        String geneset2_name = j.next().toString();
                        if (!dataset2_results.containsKey(geneset2_name)) continue;
                        String similarity_key1 = geneset1_name + " (" + "Geneset_Overlap_set2" + ") " + geneset2_name;
                        String similarity_key2 = geneset2_name + " (" + "Geneset_Overlap_set2" + ") " + geneset1_name;
                        if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2) || !(sig_genesets_set1.containsKey(geneset1_name) && !sig_genesets_set2.containsKey(geneset1_name) && !sig_genesets_set1.containsKey(geneset2_name) && sig_genesets_set2.containsKey(geneset2_name) || !sig_genesets_set1.containsKey(geneset1_name) && sig_genesets_set2.containsKey(geneset1_name) && sig_genesets_set1.containsKey(geneset2_name) && !sig_genesets_set2.containsKey(geneset2_name)) && (!sig_genesets_set1.containsKey(geneset1_name) || !sig_genesets_set1.containsKey(geneset2_name))) continue;
                        GeneSet geneset1 = genesetsOfInterest_missingedges_d2.get(geneset1_name);
                        GeneSet geneset2 = genesetsOfInterest_missingedges_d2.get(geneset2_name);
                        HashSet<Integer> genes1 = geneset1.getGenes();
                        HashSet<Integer> genes2 = geneset2.getGenes();
                        HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                        intersection.retainAll(genes2);
                        HashSet<Integer> union = new HashSet<Integer>(genes1);
                        union.addAll(genes2);
                        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
                            coeffecient = (double)intersection.size() / (double)union.size();
                        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
                            coeffecient = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                        } else {
                            double jaccard = (double)intersection.size() / (double)union.size();
                            double overlap = (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                            double k = this.params.getCombinedConstant();
                            coeffecient = k * overlap + (1.0 - k) * jaccard;
                        }
                        GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, this.params.getEnrichment_edge_type(), intersection, enrichment_set);
                        if (this.type == 1) {
                            this.geneset_similarities.put(similarity_key2, comparison);
                            continue;
                        }
                        this.geneset_similarities.put(similarity_key1, comparison);
                    }
                }
            }
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Unable to compute similarity coeffecients");
            return false;
        }
        return true;
    }

    public HashMap<String, GenesetSimilarity> getGeneset_similarities() {
        return this.geneset_similarities;
    }

    public void run() {
        this.computeGenesetSimilarities();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Computing geneset similarities");
    }
}

