/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.data.readers.TextFileReader;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.util.OpenBrowser;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.BuildEnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.BulkEMCreationAction;
import org.baderlab.csplugins.enrichmentmap.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.Enrichment_Map_Plugin;
import org.baderlab.csplugins.enrichmentmap.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.ShowAboutPanelAction;

public class EnrichmentMapInputPanel
extends JPanel {
    private static final long serialVersionUID = -7837369382106745874L;
    CollapsiblePanel Parameters;
    CollapsiblePanel datasets;
    CollapsiblePanel dataset1;
    CollapsiblePanel dataset2;
    JPanel DatasetsPanel;
    DecimalFormat decFormat = new DecimalFormat();
    private EnrichmentMapParameters params;
    private JFormattedTextField GMTFileNameTextField;
    private JFormattedTextField GCTFileName1TextField;
    private JFormattedTextField GCTFileName2TextField;
    private JFormattedTextField Dataset1FileNameTextField;
    private JFormattedTextField Dataset1FileName2TextField;
    private JFormattedTextField Dataset2FileNameTextField;
    private JFormattedTextField Dataset2FileName2TextField;
    private JFormattedTextField Dataset1RankFileTextField;
    private JFormattedTextField Dataset2RankFileTextField;
    private JFormattedTextField Dataset1Phenotype1TextField;
    private JFormattedTextField Dataset1Phenotype2TextField;
    private JFormattedTextField Dataset2Phenotype1TextField;
    private JFormattedTextField Dataset2Phenotype2TextField;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField combinedConstantTextField;
    private JRadioButton gsea;
    private JRadioButton generic;
    private JRadioButton david;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    private int defaultColumns = 15;
    public static String gct_instruction = "Please select the expression file (.gct), (.rpt)...";
    public static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    public static String dataset_instruction = "Please select the GSEA Result file (.txt)...";
    public static String rank_instruction = "Please select the rank file (.txt), (.rnk)...";
    private static String gmtTip = "File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...";
    private static String gctTip = "File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...";
    private static String datasetTip = "File specifying enrichment results.\n";
    private static String rankTip = "File specifying ranked genes.\nFormat: gene <tab> score or statistic";

    public EnrichmentMapInputPanel() {
        this.decFormat.setParseIntegerOnly(false);
        this.setLayout(new BorderLayout());
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(3);
        this.params = new EnrichmentMapParameters();
        JPanel AnalysisTypePanel = this.createAnalysisTypePanel();
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JScrollPane scroll = new JScrollPane(OptionsPanel);
        JPanel bottomPanel = this.createBottomPanel();
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)scroll, "Center");
        this.add((Component)AnalysisTypePanel, "North");
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenBrowser.openURL((String)Enrichment_Map_Plugin.userManualUrl);
            }
        });
        JButton about = new JButton("About");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction()));
        JButton bulk = new JButton("Bulk EM");
        bulk.addActionListener((ActionListener)((Object)new BulkEMCreationAction()));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        c_buttons.gridy = 2;
        gridbag_buttons.setConstraints(bulk, c_buttons);
        buttonsPanel.add(bulk);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Analysis Type"));
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea = new JRadioButton("GSEA", true);
            this.generic = new JRadioButton("generic", false);
            this.david = new JRadioButton("DAVID/BiNGO", false);
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic", true);
            this.david = new JRadioButton("DAVID/BiNGO", false);
        } else if (this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            this.gsea = new JRadioButton("GSEA", false);
            this.generic = new JRadioButton("generic", false);
            this.david = new JRadioButton("DAVID/BiNGO", true);
        }
        this.gsea.setActionCommand("GSEA");
        this.generic.setActionCommand("generic");
        this.david.setActionCommand("DAVID/BiNGO");
        this.gsea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.generic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.david.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.gsea);
        analysisOptions.add(this.generic);
        analysisOptions.add(this.david);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.gsea, c);
        panel.add(this.gsea);
        c.gridy = 1;
        gridbag.setConstraints(this.generic, c);
        panel.add(this.generic);
        c.gridy = 2;
        gridbag.setConstraints(this.david, c);
        panel.add(this.david);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTcollapsiblePanel = this.createGMTPanel();
        GMTcollapsiblePanel.setCollapsed(false);
        this.DatasetsPanel = new JPanel();
        this.DatasetsPanel.setLayout(new BoxLayout(this.DatasetsPanel, 1));
        this.datasets = new CollapsiblePanel("Datasets");
        this.datasets.setLayout(new BorderLayout());
        this.dataset1 = this.createDataset1Panel();
        this.dataset1.setCollapsed(false);
        this.dataset2 = this.createDataset2Panel();
        this.datasets.setCollapsed(false);
        this.DatasetsPanel.add(this.dataset1);
        this.DatasetsPanel.add(this.dataset2);
        this.datasets.getContentPane().add((Component)this.DatasetsPanel, "North");
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        panel.add(GMTcollapsiblePanel);
        panel.add(this.datasets);
        panel.add(ParametersPanel2);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("GMT:"){
            private static final long serialVersionUID = -122741876830022713L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GMTLabel.setToolTipText(gmtTip);
        JButton selectGMTFileButton = new JButton();
        this.GMTFileNameTextField = new JFormattedTextField();
        this.GMTFileNameTextField.setColumns(this.defaultColumns);
        this.GMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel newGMTPanel = new JPanel();
        newGMTPanel.setLayout(new BorderLayout());
        newGMTPanel.add((Component)GMTLabel, "West");
        newGMTPanel.add((Component)this.GMTFileNameTextField, "Center");
        newGMTPanel.add((Component)selectGMTFileButton, "East");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            panel.add(newGMTPanel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createDataset1Panel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Dataset 1");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GCTLabel = new JLabel("Expression:"){
            private static final long serialVersionUID = -1021506153608619217L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GCTLabel.setToolTipText(gctTip);
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(this.defaultColumns);
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 10));
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGCTFileButtonActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)GCTLabel, "West");
        GCTPanel.add((Component)this.GCTFileName1TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        JLabel Results1Label = new JLabel("Enrichments 1:"){
            private static final long serialVersionUID = 4890287742836119482L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results1Label.setToolTipText(datasetTip);
        if (!this.params.getMethod().equalsIgnoreCase("GSEA")) {
            Results1Label.setText("Enrichments:");
        }
        JButton selectResults1FileButton = new JButton();
        this.Dataset1FileNameTextField = new JFormattedTextField();
        this.Dataset1FileNameTextField.setColumns(this.defaultColumns);
        this.Dataset1FileNameTextField.setFont(new Font("Dialog", 1, 10));
        selectResults1FileButton.setText("...");
        selectResults1FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults1FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset1FileButtonActionPerformed(evt);
            }
        });
        JPanel Results1Panel = new JPanel();
        Results1Panel.setLayout(new BorderLayout());
        Results1Panel.add((Component)Results1Label, "West");
        Results1Panel.add((Component)this.Dataset1FileNameTextField, "Center");
        Results1Panel.add((Component)selectResults1FileButton, "East");
        JLabel Results2Label = new JLabel("Enrichments 2:"){
            private static final long serialVersionUID = 8462720651589188103L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results2Label.setToolTipText(datasetTip);
        JButton selectResults2FileButton = new JButton();
        this.Dataset1FileName2TextField = new JFormattedTextField();
        this.Dataset1FileName2TextField.setColumns(this.defaultColumns);
        this.Dataset1FileName2TextField.setFont(new Font("Dialog", 1, 10));
        selectResults2FileButton.setText("...");
        selectResults2FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults2FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset1File2ButtonActionPerformed(evt);
            }
        });
        JPanel Results2Panel = new JPanel();
        Results2Panel.setLayout(new BorderLayout());
        Results2Panel.add((Component)Results2Label, "West");
        Results2Panel.add((Component)this.Dataset1FileName2TextField, "Center");
        Results2Panel.add((Component)selectResults2FileButton, "East");
        panel.add(GCTPanel);
        panel.add(Results1Panel);
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            panel.add(Results2Panel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            collapsiblePanel.getContentPane().add((Component)this.createAdvancedDatasetOptions(1), "South");
        }
        return collapsiblePanel;
    }

    private CollapsiblePanel createDataset2Panel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Dataset 2");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GCTLabel = new JLabel("Expression:"){
            private static final long serialVersionUID = 2369686770191667604L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GCTLabel.setToolTipText(gctTip);
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName2TextField = new JFormattedTextField();
        this.GCTFileName2TextField.setColumns(this.defaultColumns);
        this.GCTFileName2TextField.setFont(new Font("Dialog", 1, 10));
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectGCTFileButton2ActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)GCTLabel, "West");
        GCTPanel.add((Component)this.GCTFileName2TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        JLabel Results1Label = new JLabel("Enrichments 1:"){
            private static final long serialVersionUID = -1405865291417154L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        if (!this.params.getMethod().equalsIgnoreCase("GSEA")) {
            Results1Label.setText("Enrichments:");
        }
        Results1Label.setToolTipText(datasetTip);
        JButton selectResults1FileButton = new JButton();
        this.Dataset2FileNameTextField = new JFormattedTextField();
        this.Dataset2FileNameTextField.setColumns(this.defaultColumns);
        this.Dataset2FileNameTextField.setFont(new Font("Dialog", 1, 10));
        selectResults1FileButton.setText("...");
        selectResults1FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults1FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset2FileButtonActionPerformed(evt);
            }
        });
        JPanel Results1Panel = new JPanel();
        Results1Panel.setLayout(new BorderLayout());
        Results1Panel.add((Component)Results1Label, "West");
        Results1Panel.add((Component)this.Dataset2FileNameTextField, "Center");
        Results1Panel.add((Component)selectResults1FileButton, "East");
        JLabel Results2Label = new JLabel("Enrichments 2:"){
            private static final long serialVersionUID = -5178668573493553453L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        Results2Label.setToolTipText(datasetTip);
        JButton selectResults2FileButton = new JButton();
        this.Dataset2FileName2TextField = new JFormattedTextField();
        this.Dataset2FileName2TextField.setColumns(this.defaultColumns);
        this.Dataset2FileName2TextField.setFont(new Font("Dialog", 1, 10));
        selectResults2FileButton.setText("...");
        selectResults2FileButton.setMargin(new Insets(0, 0, 0, 0));
        selectResults2FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectDataset2File2ButtonActionPerformed(evt);
            }
        });
        JPanel Results2Panel = new JPanel();
        Results2Panel.setLayout(new BorderLayout());
        Results2Panel.add((Component)Results2Label, "West");
        Results2Panel.add((Component)this.Dataset2FileName2TextField, "Center");
        Results2Panel.add((Component)selectResults2FileButton, "East");
        panel.add(GCTPanel);
        panel.add(Results1Panel);
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            panel.add(Results2Panel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            collapsiblePanel.getContentPane().add((Component)this.createAdvancedDatasetOptions(2), "South");
        }
        return collapsiblePanel;
    }

    private CollapsiblePanel createAdvancedDatasetOptions(int dataset) {
        CollapsiblePanel Advanced = new CollapsiblePanel("Advanced");
        JPanel advancedpanel = new JPanel();
        advancedpanel.setLayout(new BorderLayout());
        JLabel RanksLabel = new JLabel("Ranks:"){
            private static final long serialVersionUID = 4549754054012943869L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        RanksLabel.setToolTipText(rankTip);
        JButton selectRanksFileButton = new JButton();
        if (dataset == 1) {
            this.Dataset1RankFileTextField = new JFormattedTextField();
            this.Dataset1RankFileTextField.setColumns(this.defaultColumns);
            this.Dataset1RankFileTextField.setFont(new Font("Dialog", 1, 10));
            selectRanksFileButton.setText("...");
            selectRanksFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectRanksFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectRank1FileButtonActionPerformed(evt);
                }
            });
        } else {
            this.Dataset2RankFileTextField = new JFormattedTextField();
            this.Dataset2RankFileTextField.setColumns(this.defaultColumns);
            this.Dataset2RankFileTextField.setFont(new Font("Dialog", 1, 10));
            selectRanksFileButton.setText("...");
            selectRanksFileButton.setMargin(new Insets(0, 0, 0, 0));
            selectRanksFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    EnrichmentMapInputPanel.this.selectRank2FileButtonActionPerformed(evt);
                }
            });
        }
        JPanel RanksPanel = new JPanel();
        RanksPanel.setLayout(new BorderLayout());
        RanksPanel.add((Component)RanksLabel, "West");
        if (dataset == 1) {
            RanksPanel.add((Component)this.Dataset1RankFileTextField, "Center");
        } else {
            RanksPanel.add((Component)this.Dataset2RankFileTextField, "Center");
        }
        RanksPanel.add((Component)selectRanksFileButton, "East");
        JLabel PhenotypesLabel = new JLabel("Phenotypes:");
        JLabel vsLabel = new JLabel("VS.");
        if (dataset == 1) {
            this.Dataset1Phenotype1TextField = new JFormattedTextField((Object)"UP");
            this.Dataset1Phenotype1TextField.setColumns(4);
            this.Dataset1Phenotype1TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            this.Dataset1Phenotype2TextField = new JFormattedTextField((Object)"DOWN");
            this.Dataset1Phenotype2TextField.setColumns(4);
            this.Dataset1Phenotype2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        } else {
            this.Dataset2Phenotype1TextField = new JFormattedTextField((Object)"UP");
            this.Dataset2Phenotype1TextField.setColumns(4);
            this.Dataset2Phenotype1TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
            this.Dataset2Phenotype2TextField = new JFormattedTextField((Object)"DOWN");
            this.Dataset2Phenotype2TextField.setColumns(4);
            this.Dataset2Phenotype2TextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        }
        JPanel PhenotypesPanel = new JPanel();
        PhenotypesPanel.setLayout(new FlowLayout());
        PhenotypesPanel.add(PhenotypesLabel);
        if (dataset == 1) {
            PhenotypesPanel.add(this.Dataset1Phenotype1TextField);
            PhenotypesPanel.add(vsLabel);
            PhenotypesPanel.add(this.Dataset1Phenotype2TextField);
        } else {
            PhenotypesPanel.add(this.Dataset2Phenotype1TextField);
            PhenotypesPanel.add(vsLabel);
            PhenotypesPanel.add(this.Dataset2Phenotype2TextField);
        }
        advancedpanel.add((Component)RanksPanel, "North");
        advancedpanel.add((Component)PhenotypesPanel, "South");
        Advanced.getContentPane().add((Component)advancedpanel, "North");
        return Advanced;
    }

    private CollapsiblePanel createParametersPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel pvalueCutOffLabel = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(3);
        this.pvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String pvalueCutOffTip = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(pvalueCutOffTip);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel pvalueCutOffPanel = new JPanel();
        pvalueCutOffPanel.setLayout(new BorderLayout());
        pvalueCutOffPanel.setToolTipText(pvalueCutOffTip);
        pvalueCutOffPanel.add((Component)pvalueCutOffLabel, "West");
        pvalueCutOffPanel.add((Component)this.pvalueTextField, "East");
        JLabel qvalueCutOffLabel = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(3);
        this.qvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String qvalueCutOffTip = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(qvalueCutOffTip);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel qvalueCutOffPanel = new JPanel();
        qvalueCutOffPanel.setLayout(new BorderLayout());
        qvalueCutOffPanel.setToolTipText(qvalueCutOffTip);
        qvalueCutOffPanel.add((Component)qvalueCutOffLabel, "West");
        qvalueCutOffPanel.add((Component)this.qvalueTextField, "East");
        this.jaccard = new JRadioButton("Jaccard Coefficient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.overlap = new JRadioButton("Overlap Coefficient");
        this.overlap.setActionCommand("overlap");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(this.jaccard);
        jaccardOrOverlap.add(this.overlap);
        jaccardOrOverlap.add(this.combined);
        this.jaccard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.overlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.combined.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        JPanel index_buttons = new JPanel();
        index_buttons.setLayout(new BorderLayout());
        index_buttons.add((Component)this.jaccard, "North");
        index_buttons.add((Component)this.overlap, "Center");
        index_buttons.add((Component)this.combined, "South");
        JLabel coeffecientCutOffLabel = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(3);
        this.coeffecientTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String coeffecientCutOffTip = "Sets the Jaccard or Overlap coefficient cutoff \nonly edges with a Jaccard or Overlap coefficient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(coeffecientCutOffTip);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.params.setSimilarityCutOffChanged(false);
        JLabel combinedCutoff = new JLabel("Combined Constant");
        this.combinedConstantTextField = new JFormattedTextField(this.decFormat);
        this.combinedConstantTextField.setColumns(3);
        this.combinedConstantTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.combinedConstantTextField.setValue(0.5);
        JPanel kconstantPanel = new JPanel();
        kconstantPanel.setLayout(new BorderLayout());
        kconstantPanel.add((Component)combinedCutoff, "West");
        kconstantPanel.add((Component)this.combinedConstantTextField, "East");
        JPanel coeffecientCutOffPanel = new JPanel();
        coeffecientCutOffPanel.setLayout(new BorderLayout());
        coeffecientCutOffPanel.setToolTipText(coeffecientCutOffTip);
        coeffecientCutOffPanel.add((Component)index_buttons, "West");
        coeffecientCutOffPanel.add((Component)coeffecientCutOffLabel, "Center");
        coeffecientCutOffPanel.add((Component)this.coeffecientTextField, "East");
        coeffecientCutOffPanel.add((Component)kconstantPanel, "South");
        panel.add(pvalueCutOffPanel);
        panel.add(qvalueCutOffPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        collapsiblePanel.getContentPane().add((Component)coeffecientCutOffPanel, "South");
        return collapsiblePanel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapInputPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Build");
        importButton.addActionListener(new BuildEnrichmentMapActionListener(this));
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setInputWindow(null);
        cytoPanel.remove((Component)this);
    }

    public void close() {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setInputWindow(null);
        cytoPanel.remove((Component)this);
    }

    private void populateFieldsFromRpt(File rptFile, boolean dataset1) {
        TextFileReader reader = new TextFileReader(rptFile.getAbsolutePath());
        reader.read();
        String fullText = reader.getText();
        HashMap<String, String> rpt = new HashMap<String, String>();
        String[] lines = fullText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length == 2) {
                rpt.put(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length != 3) continue;
            rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
        }
        String timestamp = (String)rpt.get("producer_timestamp");
        String method = (String)rpt.get("producer_class");
        method = method.split("\\p{Punct}")[2];
        String out_dir = (String)rpt.get("param out");
        String job_dir_name = null;
        String data = (String)rpt.get("param res");
        String label = (String)rpt.get("param rpt_label");
        String classes = (String)rpt.get("param cls");
        String gmt = (String)rpt.get("param gmx");
        String gmt_nopath = gmt.substring(gmt.lastIndexOf(File.separator) + 1, gmt.length() - 1);
        String gseaHtmlReportFile = (String)rpt.get("file");
        String phenotype1 = "na";
        String phenotype2 = "na";
        if (classes != null && method.equalsIgnoreCase("Gsea")) {
            String[] classes_split = classes.split("#");
            String phenotypes = classes_split[1];
            String[] phenotypes_split = phenotypes.split("_versus_");
            phenotype1 = phenotypes_split[0];
            phenotype2 = phenotypes_split[1];
            if (dataset1) {
                this.params.setClassFile1(classes_split[0]);
                this.params.setDataset1Phenotype1(phenotype1);
                this.params.setDataset1Phenotype2(phenotype2);
                this.Dataset1Phenotype1TextField.setText(phenotype1);
                this.Dataset1Phenotype1TextField.setValue(phenotype1);
                this.Dataset1Phenotype2TextField.setText(phenotype2);
                this.Dataset1Phenotype2TextField.setValue(phenotype2);
            } else {
                this.params.setClassFile2(classes_split[0]);
                this.params.setDataset2Phenotype1(phenotype1);
                this.params.setDataset2Phenotype2(phenotype2);
                this.Dataset2Phenotype1TextField.setText(phenotype1);
                this.Dataset2Phenotype2TextField.setText(phenotype2);
                this.Dataset2Phenotype1TextField.setValue(phenotype1);
                this.Dataset2Phenotype2TextField.setValue(phenotype2);
            }
        } else if (method.equalsIgnoreCase("GseaPreranked")) {
            data = (String)rpt.get("param rnk");
            phenotype1 = "na_pos";
            phenotype2 = "na_neg";
            if (dataset1) {
                this.params.setDataset1Phenotype1(phenotype1);
                this.params.setDataset1Phenotype2(phenotype2);
                this.Dataset1Phenotype1TextField.setText(phenotype1);
                this.Dataset1Phenotype2TextField.setText(phenotype2);
                this.Dataset1Phenotype1TextField.setValue(phenotype1);
                this.Dataset1Phenotype2TextField.setValue(phenotype2);
            } else {
                this.params.setDataset2Phenotype1(phenotype1);
                this.params.setDataset2Phenotype2(phenotype2);
                this.Dataset2Phenotype1TextField.setText(phenotype1);
                this.Dataset2Phenotype2TextField.setText(phenotype2);
                this.Dataset2Phenotype1TextField.setValue(phenotype1);
                this.Dataset2Phenotype2TextField.setValue(phenotype2);
            }
            if (rpt.containsKey("param phenotypes")) {
                String phenotypes = (String)rpt.get("param phenotypes");
                String[] phenotypes_split = phenotypes.split("_versus_");
                if (dataset1) {
                    this.Dataset1Phenotype1TextField.setValue(phenotypes_split[0]);
                    this.Dataset1Phenotype2TextField.setValue(phenotypes_split[1]);
                } else {
                    this.Dataset2Phenotype1TextField.setValue(phenotypes_split[0]);
                    this.Dataset2Phenotype2TextField.setValue(phenotypes_split[1]);
                }
            }
            if (rpt.containsKey("param expressionMatrix")) {
                data = (String)rpt.get("param expressionMatrix");
            }
        } else {
            JOptionPane.showMessageDialog(this, "The class field in the rpt file has been modified or doesn't specify a class file\n but the analysis is a classic GSEA not PreRanked.  ");
        }
        String results1 = "";
        String results2 = "";
        String ranks = "";
        job_dir_name = label + "." + method + "." + timestamp;
        results1 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
        results2 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
        ranks = "" + out_dir + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
        if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
            String out_dir_new = rptFile.getAbsolutePath();
            out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator));
            if (!(out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator))).equalsIgnoreCase(out_dir)) {
                results1 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                results2 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                ranks = out_dir_new + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
                    results1 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                    results2 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                    ranks = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                } else {
                    out_dir = out_dir_new;
                    gseaHtmlReportFile = "" + out_dir + File.separator + job_dir_name + File.separator + "index.html";
                }
            }
        }
        if (dataset1) {
            if (this.params.getGMTFileName() == null || this.params.getGMTFileName().equalsIgnoreCase("")) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.params.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            boolean AutoPopulate = true;
            if (!this.params.getGMTFileName().equalsIgnoreCase(gmt)) {
                File currentGMTFilename = new File(this.params.getGMTFileName());
                File newGMTFilename = new File(gmt);
                if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                    int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                    if (answer == 1) {
                        this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                        this.GMTFileNameTextField.setText(gmt);
                        this.params.setGMTFileName(gmt);
                        this.GMTFileNameTextField.setToolTipText(gmt);
                    } else if (answer == 2) {
                        AutoPopulate = false;
                    }
                }
            }
            if (AutoPopulate) {
                this.GCTFileName1TextField.setForeground(this.checkFile(data));
                this.GCTFileName1TextField.setText(data);
                this.params.setExpressionFileName1(data);
                this.params.setData(true);
                this.GCTFileName1TextField.setToolTipText(data);
                this.Dataset1RankFileTextField.setForeground(this.checkFile(ranks));
                this.Dataset1RankFileTextField.setText(ranks);
                this.params.setDataset1RankedFile(ranks);
                this.Dataset1RankFileTextField.setToolTipText(ranks);
                this.params.setEnrichmentDataset1FileName1(results1);
                this.params.setEnrichmentDataset1FileName2(results2);
                this.params.setGseaHtmlReportFileDataset1(gseaHtmlReportFile);
                this.setDatasetnames(results1, results2, dataset1);
            }
        } else {
            if (this.params.getGMTFileName() == null || this.params.getGMTFileName().equalsIgnoreCase("")) {
                this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                this.GMTFileNameTextField.setText(gmt);
                this.params.setGMTFileName(gmt);
                this.GMTFileNameTextField.setToolTipText(gmt);
            }
            boolean AutoPopulate = true;
            if (!this.params.getGMTFileName().equalsIgnoreCase(gmt)) {
                File currentGMTFilename = new File(this.params.getGMTFileName());
                File newGMTFilename = new File(gmt);
                if (!currentGMTFilename.getName().equalsIgnoreCase(newGMTFilename.getName())) {
                    int answer = JOptionPane.showConfirmDialog(this, "This analysis GMT file does not match the previous dataset loaded.\n If you want to use the current GMT file but still use the new rpt file to populated fields press YES,\n If you want to change the GMT file to the one in this rpt file and populate the fields with the rpt file press NO,\n to choose a different rpt file press CANCEL\n", "GMT files name mismatch", 1);
                    if (answer == 1) {
                        this.GMTFileNameTextField.setForeground(this.checkFile(gmt));
                        this.GMTFileNameTextField.setText(gmt);
                        this.params.setGMTFileName(gmt);
                        this.GMTFileNameTextField.setToolTipText(gmt);
                    } else if (answer == 2) {
                        AutoPopulate = false;
                    }
                }
            }
            if (AutoPopulate) {
                this.GCTFileName2TextField.setForeground(this.checkFile(data));
                this.GCTFileName2TextField.setText(data);
                this.params.setExpressionFileName2(data);
                this.params.setData2(true);
                this.GCTFileName2TextField.setToolTipText(data);
                this.Dataset2RankFileTextField.setForeground(this.checkFile(ranks));
                this.Dataset2RankFileTextField.setText(ranks);
                this.params.setDataset2RankedFile(ranks);
                this.Dataset2RankFileTextField.setToolTipText(ranks);
                this.params.setEnrichmentDataset2FileName1(results1);
                this.params.setEnrichmentDataset2FileName2(results2);
                this.params.setGseaHtmlReportFileDataset2(gseaHtmlReportFile);
                this.setDatasetnames(results1, results2, dataset1);
            }
        }
    }

    protected void setDatasetnames(String file1, String file2, boolean dataset1) {
        if (dataset1) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset1FileNameTextField.setText(file1);
            this.Dataset1FileNameTextField.setToolTipText(file1);
            this.Dataset1FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset1FileName2TextField.setText(file2);
            this.Dataset1FileName2TextField.setToolTipText(file2);
        } else {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset2FileNameTextField.setText(file1);
            this.Dataset2FileNameTextField.setToolTipText(file1);
            this.Dataset2FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset2FileName2TextField.setText(file2);
            this.Dataset2FileName2TextField.setToolTipText(file2);
        }
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("GSEA")) {
            this.params.setMethod("GSEA");
        } else if (analysisType.equalsIgnoreCase("generic")) {
            this.params.setMethod("generic");
        } else if (analysisType.equalsIgnoreCase("DAVID/BiNGO")) {
            this.params.setMethod("DAVID/BiNGO");
        }
        boolean datasets_collapsed = this.datasets.isCollapsed();
        boolean dataset1_collapsed = this.dataset1.isCollapsed();
        boolean dataset2_collapsed = this.dataset2.isCollapsed();
        this.datasets.remove(this.DatasetsPanel);
        this.DatasetsPanel.remove(this.dataset1);
        this.DatasetsPanel.remove(this.dataset2);
        this.dataset1 = this.createDataset1Panel();
        this.dataset1.setCollapsed(dataset1_collapsed);
        this.DatasetsPanel.add(this.dataset1);
        this.dataset2 = this.createDataset2Panel();
        this.dataset2.setCollapsed(dataset2_collapsed);
        this.DatasetsPanel.add(this.dataset2);
        this.DatasetsPanel.revalidate();
        this.datasets.getContentPane().add((Component)this.DatasetsPanel, "North");
        this.datasets.setCollapsed(datasets_collapsed);
        this.datasets.revalidate();
        this.UpdatePanel(this.params);
    }

    private void UpdatePanel(EnrichmentMapParameters params) {
        if (params.getEnrichmentDataset1FileName1() != null) {
            this.Dataset1FileNameTextField.setText(params.getEnrichmentDataset1FileName1());
            this.Dataset1FileNameTextField.setToolTipText(params.getEnrichmentDataset1FileName1());
        }
        if (params.getEnrichmentDataset2FileName1() != null) {
            this.Dataset2FileNameTextField.setText(params.getEnrichmentDataset2FileName1());
            this.Dataset2FileNameTextField.setToolTipText(params.getEnrichmentDataset2FileName1());
        }
        if (params.getExpressionFileName1() != null) {
            this.GCTFileName1TextField.setText(params.getExpressionFileName1());
            this.GCTFileName1TextField.setToolTipText(params.getExpressionFileName1());
        }
        if (params.getExpressionFileName2() != null) {
            this.GCTFileName2TextField.setText(params.getExpressionFileName2());
            this.GCTFileName2TextField.setToolTipText(params.getExpressionFileName2());
        }
        if (params.getDataset1RankedFile() != null) {
            this.Dataset1RankFileTextField.setText(params.getDataset1RankedFile());
            this.Dataset1RankFileTextField.setToolTipText(params.getDataset1RankedFile());
        }
        if (params.getDataset2RankedFile() != null) {
            this.Dataset2RankFileTextField.setText(params.getDataset2RankedFile());
            this.Dataset2RankFileTextField.setToolTipText(params.getDataset2RankedFile());
        }
        if (params.getDataset1Phenotype1() != null) {
            this.Dataset1Phenotype1TextField.setText(params.getDataset1Phenotype1());
            this.Dataset1Phenotype1TextField.setValue(params.getDataset1Phenotype1());
            this.Dataset1Phenotype1TextField.setToolTipText(params.getDataset1Phenotype1());
        }
        if (params.getDataset1Phenotype2() != null) {
            this.Dataset1Phenotype2TextField.setText(params.getDataset1Phenotype2());
            this.Dataset1Phenotype2TextField.setValue(params.getDataset1Phenotype2());
            this.Dataset1Phenotype2TextField.setToolTipText(params.getDataset1Phenotype2());
        }
        if (params.getDataset2Phenotype1() != null) {
            this.Dataset2Phenotype1TextField.setText(params.getDataset2Phenotype1());
            this.Dataset2Phenotype1TextField.setValue(params.getDataset2Phenotype1());
            this.Dataset2Phenotype1TextField.setToolTipText(params.getDataset2Phenotype1());
        }
        if (params.getDataset2Phenotype2() != null) {
            this.Dataset2Phenotype2TextField.setText(params.getDataset2Phenotype2());
            this.Dataset2Phenotype2TextField.setValue(params.getDataset2Phenotype2());
            this.Dataset2Phenotype2TextField.setToolTipText(params.getDataset2Phenotype2());
        }
        if (params.getMethod().equalsIgnoreCase("GSEA")) {
            if (params.getEnrichmentDataset1FileName2() != null) {
                this.Dataset1FileName2TextField.setText(params.getEnrichmentDataset1FileName2());
                this.Dataset1FileName2TextField.setToolTipText(params.getEnrichmentDataset1FileName2());
            }
            if (params.getEnrichmentDataset2FileName2() != null) {
                this.Dataset2FileName2TextField.setText(params.getEnrichmentDataset2FileName2());
                this.Dataset2FileName2TextField.setToolTipText(params.getEnrichmentDataset2FileName2());
            }
        } else if (params.getEnrichmentDataset1FileName2() != null || params.getEnrichmentDataset2FileName2() != null) {
            JOptionPane.showMessageDialog(this, "Running Enrichment Map with Generic input allows for only one enrichment results file.\n  The second file specified has been removed.");
            if (params.getEnrichmentDataset1FileName2() != null) {
                params.setEnrichmentDataset1FileName2(null);
            }
            if (params.getEnrichmentDataset2FileName2() != null) {
                params.setEnrichmentDataset2FileName2(null);
            }
        }
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.params.setSimilarityMetric("JACCARD");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("combined")) {
            this.params.setSimilarityMetric("COMBINED");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gmt");
        filter.setDescription("All GMT files");
        File file = FileUtil.getFile((String)"Import GMT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.GMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.GMTFileNameTextField.setText(file.getAbsolutePath());
            this.params.setGMTFileName(file.getAbsolutePath());
            this.GMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectGCTFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gct");
        filter.addExtension("rpt");
        filter.addExtension("rnk");
        filter.addExtension("txt");
        filter.setDescription("All GCT files");
        File file = FileUtil.getFile((String)"Import GCT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else {
                this.GCTFileName1TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName1TextField.setText(file.getAbsolutePath());
                this.params.setExpressionFileName1(file.getAbsolutePath());
                this.GCTFileName1TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setData(true);
        }
    }

    private void selectGCTFileButton2ActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("gct");
        filter.addExtension("txt");
        filter.addExtension("rnk");
        filter.addExtension("rpt");
        filter.setDescription("All GCT files");
        File file = FileUtil.getFile((String)"Import GCT File", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else {
                this.GCTFileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.GCTFileName2TextField.setText(file.getAbsolutePath());
                this.params.setExpressionFileName2(file.getAbsolutePath());
                this.GCTFileName2TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
            this.params.setData2(true);
        }
    }

    private void selectDataset1FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("rpt");
        filter.addExtension("xls");
        filter.addExtension("bgo");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else {
                this.Dataset1FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset1FileNameTextField.setText(file.getAbsolutePath());
                this.params.setEnrichmentDataset1FileName1(file.getAbsolutePath());
                this.Dataset1FileNameTextField.setToolTipText(file.getAbsolutePath());
            }
        }
    }

    private void selectDataset1File2ButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("rpt");
        filter.addExtension("xls");
        filter.addExtension("bgo");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, true);
            } else {
                this.Dataset1FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset1FileName2TextField.setText(file.getAbsolutePath());
                this.params.setEnrichmentDataset1FileName2(file.getAbsolutePath());
                this.Dataset1FileName2TextField.setToolTipText(file.getAbsolutePath());
            }
        }
    }

    private void selectDataset2FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.addExtension("rpt");
        filter.addExtension("bgo");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else {
                this.Dataset2FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset2FileNameTextField.setText(file.getAbsolutePath());
                this.params.setEnrichmentDataset2FileName1(file.getAbsolutePath());
                this.Dataset2FileNameTextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
        }
    }

    private void selectDataset2File2ButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.addExtension("rpt");
        filter.addExtension("bgo");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import dataset result file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            if (file.getPath().contains(".rpt")) {
                this.populateFieldsFromRpt(file, false);
            } else {
                this.Dataset2FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
                this.Dataset2FileName2TextField.setText(file.getAbsolutePath());
                this.params.setEnrichmentDataset2FileName2(file.getAbsolutePath());
                this.Dataset2FileName2TextField.setToolTipText(file.getAbsolutePath());
            }
            this.params.setTwoDatasets(true);
        }
    }

    private void selectRank1FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("rnk");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import rank file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset1RankFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1RankFileTextField.setText(file.getAbsolutePath());
            this.params.setDataset1RankedFile(file.getAbsolutePath());
            this.Dataset1RankFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectRank2FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("rnk");
        filter.setDescription("All result files");
        File file = FileUtil.getFile((String)"import rank file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset2RankFileTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2RankFileTextField.setText(file.getAbsolutePath());
            this.params.setDataset2RankedFile(file.getAbsolutePath());
            this.Dataset2RankFileTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void resetPanel() {
        this.params = new EnrichmentMapParameters();
        this.GMTFileNameTextField.setText("");
        this.GMTFileNameTextField.setToolTipText(null);
        this.GCTFileName1TextField.setText("");
        this.GCTFileName1TextField.setToolTipText(null);
        this.GCTFileName2TextField.setText("");
        this.GCTFileName2TextField.setToolTipText(null);
        this.Dataset1FileNameTextField.setText("");
        this.Dataset1FileNameTextField.setToolTipText(null);
        this.Dataset1FileName2TextField.setText("");
        this.Dataset1FileName2TextField.setToolTipText(null);
        this.Dataset2FileNameTextField.setText("");
        this.Dataset2FileNameTextField.setToolTipText(null);
        this.Dataset2FileName2TextField.setText("");
        this.Dataset2FileName2TextField.setToolTipText(null);
        this.Dataset1RankFileTextField.setText("");
        this.Dataset1RankFileTextField.setToolTipText(null);
        this.Dataset2RankFileTextField.setText("");
        this.Dataset2RankFileTextField.setToolTipText(null);
        this.Dataset1Phenotype1TextField.setText(this.params.getDataset1Phenotype1());
        this.Dataset1Phenotype2TextField.setText(this.params.getDataset1Phenotype2());
        this.Dataset2Phenotype1TextField.setText(this.params.getDataset2Phenotype1());
        this.Dataset2Phenotype2TextField.setText(this.params.getDataset2Phenotype2());
        this.Dataset1Phenotype1TextField.setValue(this.params.getDataset1Phenotype1());
        this.Dataset1Phenotype2TextField.setValue(this.params.getDataset1Phenotype2());
        this.Dataset2Phenotype1TextField.setValue(this.params.getDataset2Phenotype1());
        this.Dataset2Phenotype2TextField.setValue(this.params.getDataset2Phenotype2());
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(this.params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        this.qvalueTextField.setValue(this.params.getQvalue());
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.params.setSimilarityCutOffChanged(false);
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea.setSelected(true);
            this.generic.setSelected(false);
            this.david.setSelected(false);
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(true);
            this.david.setSelected(false);
        } else if (this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(false);
            this.david.setSelected(true);
        }
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public void updateContents(EnrichmentMapParameters current_params) {
        this.params = new EnrichmentMapParameters();
        this.params.copy(current_params);
        this.GMTFileNameTextField.setText(current_params.getGMTFileName());
        this.GCTFileName1TextField.setText(current_params.getExpressionFileName1());
        this.GCTFileName2TextField.setText(current_params.getExpressionFileName2());
        this.Dataset1FileNameTextField.setText(current_params.getEnrichmentDataset1FileName1());
        this.Dataset1FileName2TextField.setText(current_params.getEnrichmentDataset1FileName2());
        this.Dataset2FileNameTextField.setText(current_params.getEnrichmentDataset2FileName1());
        this.Dataset2FileName2TextField.setText(current_params.getEnrichmentDataset2FileName2());
        this.Dataset1RankFileTextField.setText(current_params.getDataset1RankedFile());
        this.Dataset2RankFileTextField.setText(current_params.getDataset2RankedFile());
        this.Dataset1Phenotype1TextField.setText(current_params.getDataset1Phenotype1());
        this.Dataset1Phenotype2TextField.setText(current_params.getDataset1Phenotype2());
        this.Dataset2Phenotype1TextField.setText(current_params.getDataset2Phenotype1());
        this.Dataset2Phenotype2TextField.setText(current_params.getDataset2Phenotype2());
        this.Dataset1Phenotype1TextField.setValue(current_params.getDataset1Phenotype1());
        this.Dataset1Phenotype2TextField.setValue(current_params.getDataset1Phenotype2());
        this.Dataset2Phenotype1TextField.setValue(current_params.getDataset2Phenotype1());
        this.Dataset2Phenotype2TextField.setValue(current_params.getDataset2Phenotype2());
        this.pvalueTextField.setText(Double.toString(current_params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(current_params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(current_params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(current_params.getPvalue());
        this.qvalueTextField.setValue(current_params.getQvalue());
        this.coeffecientTextField.setValue(current_params.getSimilarityCutOff());
        this.combinedConstantTextField.setValue(current_params.getCombinedConstant());
        if (current_params.getMethod().equalsIgnoreCase("GSEA")) {
            this.gsea.setSelected(true);
            this.generic.setSelected(false);
            this.david.setSelected(false);
        } else if (current_params.getMethod().equalsIgnoreCase("generic")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(true);
            this.david.setSelected(false);
        } else if (current_params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            this.gsea.setSelected(false);
            this.generic.setSelected(false);
            this.david.setSelected(true);
        }
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public EnrichmentMapParameters getParams() {
        return this.params;
    }

    public void setParams(EnrichmentMapParameters params) {
        this.params = params;
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == EnrichmentMapInputPanel.this.pvalueTextField) {
                Number value = (Number)EnrichmentMapInputPanel.this.pvalueTextField.getValue();
                if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapInputPanel.this.params.setPvalue(value.doubleValue());
                } else {
                    source.setValue(EnrichmentMapInputPanel.this.params.getPvalue());
                    message = message + "The pvalue cutoff must be greater than or equal 0 and less than or equal to 1.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapInputPanel.this.qvalueTextField) {
                Number value = (Number)EnrichmentMapInputPanel.this.qvalueTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0) {
                    EnrichmentMapInputPanel.this.params.setQvalue(value.doubleValue());
                } else {
                    source.setValue(EnrichmentMapInputPanel.this.params.getQvalue());
                    message = message + "The FDR q-value cutoff must be between 0 and 100.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapInputPanel.this.coeffecientTextField) {
                Number value = (Number)EnrichmentMapInputPanel.this.coeffecientTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapInputPanel.this.params.setSimilarityCutOff(value.doubleValue());
                    EnrichmentMapInputPanel.this.params.setSimilarityCutOffChanged(true);
                } else {
                    source.setValue(EnrichmentMapInputPanel.this.params.getSimilarityCutOff());
                    message = message + "The Overlap/Jaccard Coefficient cutoff must be between 0 and 1.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapInputPanel.this.combinedConstantTextField) {
                Number value = (Number)EnrichmentMapInputPanel.this.combinedConstantTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapInputPanel.this.params.setCombinedConstant(value.doubleValue());
                    if (!EnrichmentMapInputPanel.this.params.isSimilarityCutOffChanged() && EnrichmentMapInputPanel.this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
                        EnrichmentMapInputPanel.this.params.setSimilarityCutOff(EnrichmentMapInputPanel.this.params.getDefaultOverlapCutOff() * value.doubleValue() + (1.0 - value.doubleValue()) * EnrichmentMapInputPanel.this.params.getDefaultJaccardCutOff());
                    }
                } else {
                    source.setValue(0.5);
                    message = message + "The combined Overlap/Jaccard Coefficient constant must be between 0 and 1.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapInputPanel.this.GMTFileNameTextField) {
                String value = EnrichmentMapInputPanel.this.GMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setGMTFileName(value);
                } else if (!EnrichmentMapInputPanel.this.GMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.GMTFileNameTextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setGMTFileName(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.GCTFileName1TextField) {
                String value = EnrichmentMapInputPanel.this.GCTFileName1TextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setExpressionFileName1(value);
                    EnrichmentMapInputPanel.this.params.setData(false);
                } else if (!EnrichmentMapInputPanel.this.GCTFileName1TextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.GCTFileName1TextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setExpressionFileName1(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.GCTFileName2TextField) {
                String value = EnrichmentMapInputPanel.this.GCTFileName2TextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setExpressionFileName2(value);
                    EnrichmentMapInputPanel.this.params.setData2(false);
                } else if (!EnrichmentMapInputPanel.this.GCTFileName2TextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.GCTFileName2TextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setExpressionFileName2(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset1FileNameTextField) {
                String value = EnrichmentMapInputPanel.this.Dataset1FileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setEnrichmentDataset1FileName1(value);
                } else if (!EnrichmentMapInputPanel.this.Dataset1FileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.Dataset1FileNameTextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setEnrichmentDataset1FileName1(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset1FileName2TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset1FileName2TextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setEnrichmentDataset1FileName2(value);
                } else if (!EnrichmentMapInputPanel.this.Dataset1FileName2TextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.Dataset1FileName2TextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setEnrichmentDataset1FileName2(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset2FileNameTextField) {
                String value = EnrichmentMapInputPanel.this.Dataset2FileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setEnrichmentDataset2FileName1(value);
                } else if (!EnrichmentMapInputPanel.this.Dataset2FileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.Dataset2FileNameTextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setEnrichmentDataset2FileName1(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset2FileName2TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset2FileName2TextField.getText();
                if (value.equalsIgnoreCase("")) {
                    EnrichmentMapInputPanel.this.params.setEnrichmentDataset2FileName2(value);
                } else if (!EnrichmentMapInputPanel.this.Dataset2FileName2TextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (EnrichmentMapInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        EnrichmentMapInputPanel.this.Dataset2FileName2TextField.setForeground(EnrichmentMapInputPanel.this.checkFile(value));
                    } else {
                        EnrichmentMapInputPanel.this.params.setEnrichmentDataset2FileName2(value);
                    }
                }
            } else if (source == EnrichmentMapInputPanel.this.Dataset1Phenotype1TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset1Phenotype1TextField.getText();
                EnrichmentMapInputPanel.this.params.setDataset1Phenotype1(value);
            } else if (source == EnrichmentMapInputPanel.this.Dataset1Phenotype2TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset1Phenotype2TextField.getText();
                EnrichmentMapInputPanel.this.params.setDataset1Phenotype2(value);
            } else if (source == EnrichmentMapInputPanel.this.Dataset2Phenotype1TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset2Phenotype1TextField.getText();
                EnrichmentMapInputPanel.this.params.setDataset2Phenotype1(value);
            } else if (source == EnrichmentMapInputPanel.this.Dataset2Phenotype2TextField) {
                String value = EnrichmentMapInputPanel.this.Dataset2Phenotype2TextField.getText();
                EnrichmentMapInputPanel.this.params.setDataset2Phenotype2(value);
            }
            if (invalid) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

